
/**************************************************************************
 *
 *  $Id: secudefs.h 1.4 2006/08/22 15:32:28 martin REL_M $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Check the current compiler type to decide if pragma pack() is 
 *    required to pack cross-platform data structures.
 *
 * -----------------------------------------------------------------------
 *  $Log: secudefs.h $
 *  Revision 1.4  2006/08/22 15:32:28  martin
 *  Added standard file header.
 *  Use C99 fixed-size types in structures.
 *  Revision 1.3  2004/09/20 12:52:16  andre
 *  control codes moved to gpspriv.h
 *  Revision 1.2  2004/06/01 11:19:21Z  andre
 *  Revision 1.1  2004/05/05 11:11:43Z  andre
 *  Initial revision
 *
 **************************************************************************/

#ifndef _SECUDEFS_H
#define _SECUDEFS_H

#include <words.h>
#include <use_pack.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Start of header body */



#if defined( _USE_PACK )        // set byte alignment
  #pragma pack( 1 )
#endif


typedef uint16_t METHOD_CODE;      // number of crypto method
typedef char PASSWORD[32];         // password max 256 Bit
typedef char PUBLIC_KEY[32];       // public key max 256 Bit

// info structure requested before password encryption
// to be requested from xport
typedef struct {
  uint32_t flags;                  //
  uint32_t supp_flags;             // bitmask for supported crypto methods
  uint32_t status;                 // status locked / open 
} SECU_INFO;


// public key structure to be requested from xport
// immediately before sending SECU_SETTINGS 
typedef struct {
  uint32_t flags;
  PUBLIC_KEY public_key;
} SECU_PUBLIC_KEY; 


// password settings to be sent to xport
typedef struct {
  uint32_t flags;                         // store flag etc.
  METHOD_CODE method_code;                // method code according to enum
  PUBLIC_KEY public_key;                  // own public key if key exchange required
  PASSWORD password;                      // current password
  PASSWORD new_password;                  // new password if password shall be set
} SECU_SETTINGS;

// bitmasks to be used with secu_settings.flags
#define MSK_FLAG_CHANGE_PASSWORD   0x0001



#if defined( _USE_PACK )
  #pragma pack()
#endif

#ifdef __cplusplus
}
#endif

#endif
