
/**************************************************************************
 *
 *  $Id: mbgserio.h 1.7.1.13 2016/11/23 13:41:37 martin TEST $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions and prototypes for mbgserio.c.
 *
 * -----------------------------------------------------------------------
 *  $Log: mbgserio.h $
 *  Revision 1.7.1.13  2016/11/23 13:41:37  martin
 *  Defined DEFAULT_SERIAL_DEVICE_NAME_2 as default name
 *  for a second serial port to be used by specific applications.
 *  Revision 1.7.1.12  2016/11/15 15:48:16  martin
 *  Allocate a device control structure when opening a port,
 *  and free the structure when the port is closed.
 *  Modified some internal structure fields.
 *  Updated function prototypes.
 *  Revision 1.7.1.11  2016/11/08 17:22:47  martin
 *  Updated function prototypes.
 *  Revision 1.7.1.10  2015/12/10 16:30:17  martin
 *  *** empty log message ***
 *  Revision 1.7.1.9  2015/10/30 11:10:40  martin
 *  Revision 1.7.1.8  2015/10/06 14:50:49Z  martin
 *  Revision 1.7.1.7  2015/10/06 14:20:02Z  martin
 *  Account for library module chk_tstr renamed to mbg_tstr.
 *  Revision 1.7.1.6  2015/09/07 10:40:59  martin
 *  Revision 1.7.1.5  2015/08/27 16:18:49  martin
 *  Updated function prototypes.
 *  Revision 1.7.1.4  2014/03/11 12:26:46  martin
 *  Revision 1.7.1.3  2014/03/04 12:08:13  martin
 *  Revision 1.7.1.2  2014/01/08 17:19:42Z  martin
 *  MBG_TGT_POSIX
 *  New libusb
 *  Revision 1.7.1.1  2014/01/07 17:00:29  martin
 *  Use common Meinberg error codes.
 *  Revision 1.7  2013/02/01 16:10:45  martin
 *  Got rid of _mbg_open/close/read/write() macros.
 *  Functions are now used instead.
 *  Updated function prototypes.
 *  Revision 1.6  2011/08/23 10:15:25Z  martin
 *  Updated function prototypes.
 *  Revision 1.5  2011/08/04 09:48:55  martin
 *  Support flushing output.
 *  Re-ordered some definitions.
 *  Revision 1.4  2009/09/01 10:54:29  martin
 *  Include mbg_tmo.h for the new portable timeout functions.
 *  Added symbols for return codes in case of an error.
 *  Code cleanup.
 *  Revision 1.3  2009/04/01 14:17:31  martin
 *  Cleanup for CVI.
 *  Revision 1.2  2008/09/04 15:11:36Z  martin
 *  Preliminary support for device lists.
 *  Updated function prototypes.
 *  Revision 1.1  2007/11/12 16:48:02  martin
 *  Initial revision.
 *
 **************************************************************************/

#ifndef _MBGSERIO_H
#define _MBGSERIO_H


/* Other headers to be included */

#include <mbg_tgt.h>
#include <mbg_tmo.h>
#include <mbgerror.h>

#include <stdlib.h>
#include <string.h>

#if defined( MBG_TGT_POSIX )
  #include <termios.h>
#endif

#if _USE_MBG_TSTR
  #include <mbg_tstr.h>
#else
  // dummy types to avoid compiler errors
  typedef int MBG_TSTR_RCV_FNC;
  typedef int MBG_TSTR_RCV_ARG;
#endif

#if !defined( _USE_SELECT_FOR_SERIAL_IO )
  #if defined( MBG_TGT_POSIX )
    #define _USE_SELECT_FOR_SERIAL_IO  1
  #else
    #define _USE_SELECT_FOR_SERIAL_IO  0
  #endif
#endif


#ifdef _MBGSERIO
 #define _ext
 #define _DO_INIT
#else
 #define _ext extern
#endif


/* Start of header body */

#if !defined( DEFAULT_SERIAL_DEVICE_NAME )
  // For applications which 2 serial ports we also define
  // default names for the second port to be used.
  #if defined( MBG_TGT_WIN32 ) || defined( MBG_TGT_DOS )
    #define DEFAULT_SERIAL_DEVICE_NAME   "COM1"
    #define DEFAULT_SERIAL_DEVICE_NAME_2 "COM2"
  #elif defined( MBG_TGT_LINUX )
    #define DEFAULT_SERIAL_DEVICE_NAME   "/dev/ttyS0"
    #define DEFAULT_SERIAL_DEVICE_NAME_2 "/dev/ttyS1"
  #else
    #error DEFAULT_SERIAL_DEVICE_NAME needs to be defined for this target.
  #endif
#endif


/*
 * The following macros control parts of the build process.
 * The default values are suitable for most cases but can be
 * overridden by global definitions, if required.
 */

#if _IS_MBG_FIRMWARE

  // This handle type in not used by the firmware.
  // However, we define it to avoid build errors.
  typedef int MBG_HANDLE;

#else

  #if defined( MBG_TGT_CVI )

    #include <rs232.h>

  #elif defined( MBG_TGT_WIN32 )

    #include <io.h>

  #elif defined( MBG_TGT_DOS )

    #if defined( _USE_V24TOOLS )
      #include <v24tools.h>
    #endif

  #endif

#endif



typedef struct _MBG_STR_LIST
{
  char *s;
  struct _MBG_STR_LIST *next;

} MBG_STR_LIST;



typedef struct
{
  MBG_PORT_HANDLE port_handle;   ///< the handle that will be used for the device

  ulong poll_timeout;            ///< The default timeout when waiting for data

  #if defined( MBG_TGT_WIN32 )
    DCB org_dcb;
    int org_dcb_has_been_read;

    COMMTIMEOUTS org_commtimeouts;
    int org_commtimeouts_have_been_read;

    COMMPROP comm_prop;          ///< configuration settings supported by the driver (r/o)
    int comm_prop_have_been_read;
  #endif

  #if defined( MBG_TGT_POSIX )
    struct termios org_tio;      ///< saved original port settings
    int org_tio_has_been_read;
  #endif

} MBGSERIO_DEV;



/* function prototypes: */

#ifdef __cplusplus
extern "C" {
#endif

/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 /**
 * @brief Close a serial port specified by a ::MBGSERIO_DEV structure
 *
 * After the port has been closed the buffer which had been allocated
 * for the ::MBGSERIO_DEV structure is freed, and the pointer to that
 * buffer is set to NULL.
 *
 * @param[in,out]  pp_mdev  Address of a pointer to the control structure including the port handle
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgserio_close( MBGSERIO_DEV **pp_mdev ) ;

 /**
 * @brief Open a serial port and set up a ::MBGSERIO_DEV structure
 *
 * @param[in,out]  pp_mdev   Address of a pointer to a ::MBGSERIO_DEV device control structure
 *                           allocated and set up by this call. Set to NULL on error.
 * @param[in]      dev_name  Device name of the port to be opened.
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgserio_open( MBGSERIO_DEV **pp_mdev, const char *dev_name ) ;

 _NO_MBG_API_ATTR int _MBG_API mbgserio_setup_port_str_list( MBG_STR_LIST **list, int max_devs ) ;
 _NO_MBG_API_ATTR void _MBG_API mbgserio_free_str_list( MBG_STR_LIST *list ) ;
 /**
 * @brief
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgserio_set_parms( MBGSERIO_DEV *mdev, uint32_t baud_rate, const char *framing ) ;

 _NO_MBG_API_ATTR int _MBG_API mbgserio_read( MBGSERIO_DEV *mdev, void *buffer, unsigned int count ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgserio_write( MBGSERIO_DEV *mdev, const void *buffer, unsigned int count ) ;
 _NO_MBG_API_ATTR void _MBG_API mbgserio_flush_tx( MBGSERIO_DEV *mdev ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgserio_read_wait( MBGSERIO_DEV *mdev, void *buffer, uint count ) ;

/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif

/* End of header body */

#undef _ext
#undef _DO_INIT

#endif  /* _MBGSERIO_H */
