
/**************************************************************************
 *
 *  $Id: mbgextio.h 1.16.1.126 2017/04/12 08:35:11 martin TEST $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions and prototypes for mbgextio.c.
 *
 * -----------------------------------------------------------------------
 *  $Log: mbgextio.h $
 *  Revision 1.16.1.126  2017/04/12 08:35:11  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.125  2017/04/05 16:07:36  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.124  2017/03/27 10:38:41  thomas-b
 *  Added functions to read and write PTPv1 common datasets
 *  Revision 1.16.1.123  2017/03/20 10:10:03  martin
 *  Fixed build without _PRELIMINARY_CODE.
 *  Revision 1.16.1.122  2017/03/07 13:45:56  thomas-b
 *  Added functions to get and set ignore lock
 *  Revision 1.16.1.121  2017/03/03 06:46:05  thomas-b
 *  Added functions to read/write NTP key, server, refclock and orphan mode settings
 *  Revision 1.16.1.120  2017/02/23 14:32:09  thomas-b
 *  *** empty log message ***
 *  Revision 1.16.1.119  2017/02/22 08:31:14  thomas-b
 *  Added functions to read/write event info and read monitoring status and event status
 *  Revision 1.16.1.118  2017/02/16 13:01:53  thomas-b
 *  Changed get and set functions for PTPv2 port dataset to use idx structure
 *  Revision 1.16.1.117  2017/02/16 09:27:59  thomas-b
 *  Fixed doxygen docu
 *  Revision 1.16.1.116  2017/02/16 09:24:33  thomas-b
 *  Added functions to get and set PTPv2 common datasets
 *  Revision 1.16.1.115  2017/02/15 16:17:38  martin
 *  *** empty log message ***
 *  Revision 1.16.1.114  2017/02/08 13:12:36  thomas-b
 *  Added functions to get and set SNMP configuration
 *  Revision 1.16.1.113  2017/02/07 14:24:52  thomas-b
 *  Added function mbgextio_dev_has_monitoring, which checks if the extended feature MBG_XFEATURE_MONITORING is set
 *  Revision 1.16.1.112  2017/02/07 14:10:19  daniel
 *  Added calls to check for new License TLV feature types
 *  Revision 1.16.1.111  2016/12/07 09:34:14  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.110  2016/11/30 16:12:55  thomas-b
 *  Added functions to get/set SCU_STAT_INFO/SCU_STAT_SETTINGS
 *  Revision 1.16.1.109  2016/11/22 10:33:15  philipp
 *  Implemented I/O ports
 *  Revision 1.16.1.108  2016/11/02 12:15:18  thomas-b
 *  Added function to check if a device has MBG_XFEATURE_REQ_TTM and adapted the documentation for mbgextio_get_time
 *  Revision 1.16.1.107  2016/10/31 09:28:06  martin
 *  Doxygen fixes.
 *  Revision 1.16.1.106  2016/10/25 09:11:19  thomas-b
 *  Added functions to get CFGH, ALM and IONO structures from a device
 *  Revision 1.16.1.105  2016/10/24 13:59:43  thomas-b
 *  Removed needless space from comment
 *  Fixed mbgextio_rcv_msg_unlocked for reception of XBP packets
 *  Revision 1.16.1.104  2016/10/20 14:46:04  thomas-b
 *  Added function to check if XBP is supported
 *  Revision 1.16.1.103  2016/10/20 11:29:15  martin
 *  Added missing const qualifier in mbgextio_get_utc_param().
 *  Revision 1.16.1.102  2016/10/20 10:43:35  thomas-b
 *  Added function to check if a device is a bus level device
 *  Revision 1.16.1.101  2016/10/19 14:33:44  thomas-b
 *  Added functions to read and write ucap via network configuration
 *  Revision 1.16.1.100  2016/10/14 11:09:41  thomas-b
 *  Added function to check MBG_XFEATURE_UCAP_NET
 *  Revision 1.16.1.99  2016/09/29 14:35:12  thomas-b
 *  Moved new get and set functions for NET_CFG_API stage 2 to mbgextio
 *  Revision 1.16.1.98  2016/09/29 12:19:58  thomas-b
 *  Added function to check transactions feature
 *  Revision 1.16.1.97  2016/09/20 13:52:38  martin
 *  Moved GPS_REQACK preprocessor handling to the header file.
 *  Revision 1.16.1.96  2016/08/23 15:12:01  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.95  2016/08/23 08:33:39  udo
 *  renamed some Time Mon functions
 *  Revision 1.16.1.94  2016/08/22 14:14:48  gregoire.diehl
 *  new call: mbgextio_get_corr_info
 *  Revision 1.16.1.93  2016/08/15 09:42:19Z  udo
 *  added mbgextio_time_mon_get_target_ext_data_set_idx()
 *  Revision 1.16.1.92  2016/08/11 11:30:54  martin
 *  Conditionally support time monitoring API.
 *  Revision 1.16.1.91  2016/08/01 10:33:02  daniel
 *  Updated function prototypes
 *  Revision 1.16.1.90  2016/07/07 15:03:32  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.89  2016/06/15 10:15:50  thomas-b
 *  Added functions which check if the user capture feature is supported by a device
 *  Revision 1.16.1.88  2016/06/14 10:33:22  thomas-b
 *  Added functions which check if the event log feature is supported by a device
 *  Revision 1.16.1.87  2016/06/08 09:55:14  thomas-b
 *  Added function mbgextio_open_serial_force_default
 *  Revision 1.16.1.86  2016/06/07 14:50:34  udo
 *  Reset Meinberg USB device in case if the open_usb function return MBG_ERR_BUSY
 *  Revision 1.16.1.85  2016/06/07 07:43:07  philipp
 *  New function to check for Irig Rx feature
 *  Revision 1.16.1.84  2016/06/02 10:23:58  philipp
 *  Renaming all MBG_EXT_REV_INFO related stuff to MBG_EXT_SYS_INFO
 *  Revision 1.16.1.83  2016/05/30 08:10:45  thomas-b
 *  Added functions to check several builtin features
 *  Revision 1.16.1.82  2016/05/27 05:18:20  philipp
 *  New functions mbgextio_get_xmr_ext_source_stats_idx and mbgextio_get_xmr_ext_source_metrics_idx
 *  Revision 1.16.1.81  2016/05/25 09:23:00  philipp
 *  New function mbgextio_get_xmr_ext_source_stats_idx
 *  Revision 1.16.1.80  2016/05/20 13:37:55  philipp
 *  New function mbgextio_set_gpio_settings_idx
 *  Revision 1.16.1.79  2016/05/20 09:41:36  thomas-b
 *  Removed functions which check for a specific IMS card
 *  Revision 1.16.1.78  2016/05/20 08:51:23  thomas-b
 *  Added functions mbgextio_dev_has_time_scale and mbgextio_dev_has_tzcode
 *  Revision 1.16.1.77  2016/05/20 07:51:35  thomas-b
 *  Added function mbgextio_dev_has_tzdl
 *  Revision 1.16.1.76  2016/05/20 06:42:09  thomas-b
 *  Added function mbgextio_dev_has_enable_flags
 *  Revision 1.16.1.75  2016/05/17 13:29:38  philipp
 *  New function to check whether device is LNO
 *  Revision 1.16.1.74  2016/05/17 06:33:10  philipp
 *  New function to check whether a device has serial outputs
 *  Revision 1.16.1.73  2016/05/12 10:41:38  philipp
 *  New functions to check bpe card and IRIG Tx feature
 *  Revision 1.16.1.72  2016/05/10 06:15:29  philipp
 *  New function to check whether a device has programmable pulses
 *  Revision 1.16.1.71  2016/04/26 06:55:47  thomas-b
 *  Added functions to check if NET_CFG and LAN_IP4 APIs are supported
 *  Revision 1.16.1.70  2016/04/25 14:47:15  martin
 *  *** empty log message ***
 *  Revision 1.16.1.69  2016/04/22 10:54:00  philipp
 *  New function to check whether device is LIU
 *  Revision 1.16.1.68  2016/04/20 13:20:27  thomas-b
 *  Added function to check if a device supports NTP
 *  Revision 1.16.1.67  2016/04/20 09:26:13  philipp
 *  Moved all HPS-PTP related structures to gpspriv.h and removed related extended feature bit from gpsdefs.h.
 *  Also removed functions from mbgextio and xdevfeat since HPS-PTP handling needs a redesign concerning structures.
 *  Thus, handle everything explicitly for now!
 *  -> Redesing this A.S.A.P.!!!
 *  Revision 1.16.1.66  2016/04/15 08:17:26  philipp
 *  New feature MBG_XFEATURE_EXT_PTP
 *  Revision 1.16.1.65  2016/04/13 07:01:21  philipp
 *  New function to check whether device is HPS
 *  Revision 1.16.1.64  2016/04/12 13:27:41  philipp
 *  Several new functions to check for device models and device features
 *  Revision 1.16.1.63  2016/04/11 13:56:48  thomas-b
 *  Added function mbgextio_dev_has_xmulti_ref
 *  Revision 1.16.1.62  2016/04/07 14:08:45  philipp
 *  Added function prototype mbgextio_get_ext_rev_info
 *  Revision 1.16.1.61  2016/04/07 12:46:19  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.60  2016/03/24 14:08:51  martin
 *  *** empty log message ***
 *  Revision 1.16.1.59  2016/03/22 12:53:20  thomas-b
 *  Added functions to find and free Meinberg LAN devices
 *  Revision 1.16.1.58  2016/03/18 11:21:56Z  martin
 *  *** empty log message ***
 *  Revision 1.16.1.57  2016/03/18 10:48:33  martin
 *  *** empty log message ***
 *  Revision 1.16.1.56  2016/03/17 11:33:11  philipp
 *  Added XMR functions
 *  Revision 1.16.1.55  2016/03/16 15:09:11  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.54  2016/03/14 11:53:34  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.53  2016/03/11 08:20:12  marvin
 *  Added function to save PTP unicast master settings.
 *  Revision 1.16.1.52  2016/02/25 12:03:18Z  udo
 *  Revision 1.16.1.51  2016/02/17 15:03:17  udo
 *  used MBG_TIME_MON_TARGET_STATUS_IDX
 *  Revision 1.16.1.47  2016/02/03 09:30:57  martin
 *  Fixed build without libusb.
 *  Revision 1.16.1.46  2016/02/03 09:16:50Z  martin
 *  *** empty log message ***
 *  Revision 1.16.1.45  2016/02/02 15:58:13  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.44  2016/01/19 14:13:55  udo
 *  improve time monitor functions
 *  Revision 1.16.1.43  2016/01/18 08:53:35  udo
 *  added support for PTP Time Monitoring on TSU/HPS100
 *  Revision 1.16.1.42  2016/01/04 15:55:41  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.41  2015/12/10 11:55:16  martin
 *  *** empty log message ***
 *  Revision 1.16.1.40  2015/12/07 16:36:37  martin
 *  *** empty log message ***
 *  Revision 1.16.1.39  2015/12/03 16:00:40  martin
 *  *** empty log message ***
 *  Revision 1.16.1.38  2015/12/01 11:36:02  martin
 *  *** empty log message ***
 *  Revision 1.16.1.37  2015/11/30 08:16:15  philipp
 *  Added (wrapper) functions to test for TLV features
 *  Revision 1.16.1.36  2015/11/26 16:19:27  martin
 *  Reworked check feature API causing some other API calls to be
 *  simplified/changed since receiver info is now stored inside
 *  the message control block.
 *  Revision 1.16.1.35  2015/11/23 12:55:26  philipp
 *  Removed TLV functions
 *  Revision 1.16.1.33  2015/11/20 10:06:36  philipp
 *  Changed USB direct I/O receive buffer size to fit maximum message length
 *  Revision 1.16.1.32  2015/11/20 08:14:39  philipp
 *  Added id member to struct MBG_TLV_ANNOUNCE
 *  Revision 1.16.1.31  2015/11/20 07:27:38  philipp
 *  Adjusted functions and prototypes to match new TLV structures from gpsdefs.h
 *  Revision 1.16.1.30  2015/11/19 13:15:46  philipp
 *  Added TLV functionality
 *  Revision 1.16.1.29  2015/10/30 11:08:12  martin
 *  Removed obsolete definitions originating from mbgserio.h.
 *  Revision 1.16.1.28  2015/10/19 16:42:21Z  martin
 *  *** empty log message ***
 *  Revision 1.16.1.27  2015/10/19 09:35:13  martin
 *  *** empty log message ***
 *  Revision 1.16.1.26  2015/10/09 11:09:18  martin
 *  *** empty log message ***
 *  Revision 1.16.1.25  2015/10/06 14:19:09  martin
 *  *** empty log message ***
 *  Revision 1.16.1.24  2015/10/02 08:57:47  thomas-b
 *  Added several functions to retrieve and set parameter structures of the new FDM API
 *  Revision 1.16.1.23  2015/10/02 08:18:51  martin
 *  *** empty log message ***
 *  Revision 1.16.1.22  2015/09/15 13:25:53  martin
 *  *** empty log message ***
 *  Revision 1.16.1.21  2015/09/09 11:05:46  gregoire
 *  Revision 1.16.1.20  2015/09/09 08:41:02Z  martin
 *  Revision 1.16.1.19  2015/09/09 08:26:28  martin
 *  Revision 1.16.1.18  2015/09/08 15:25:11  martin
 *  Revision 1.16.1.17  2015/09/04 09:44:44  daniel
 *  Updated function prototypes
 *  Revision 1.16.1.16  2015/09/02 16:42:21  martin
 *  Preliminary code which is only included if a preprocessor symbol
 *  _PRELIMINARY_CODE is defined in the project Makefile.
 *  Revision 1.16.1.15  2015/08/27 16:21:32  martin
 *  Revision 1.16.1.14  2015/08/20 09:08:17  martin
 *  Revision 1.16.1.13  2015/08/18 09:54:03  martin
 *  Revision 1.16.1.12  2015/08/12 15:53:58Z  martin
 *  Revision 1.16.1.11  2015/07/22 16:02:08  martin
 *  Started to support variable USB endpoint numbers.
 *  Revision 1.16.1.10  2015/07/14 15:10:27  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.9  2015/07/14 13:24:59  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.8.1.10  2015/05/27 09:23:57  daniel
 *  Fixed USB_DIRECT_IO stuff
 *  Revision 1.16.1.8.1.9  2015/05/21 11:01:00  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.8.1.8  2015/05/19 13:20:59  daniel
 *  Preliminary support for USB_DIRECT_IO
 *  Revision 1.16.1.8.1.6  2015/05/13 09:50:51  martin
 *  Added mbgextio_xmt_ack() and mbgextio_xmt_nack().
 *  Revision 1.16.1.8.1.5  2015/04/15 15:36:19  martin
 *  Doxygen fixes.
 *  Revision 1.16.1.8.1.4  2015/03/03 10:14:50  martin
 *  Updated function prototypes.
 *  Revision 1.16.1.8.1.3  2014/11/04 15:09:37  martin
 *  More XBP stuff.
 *  Revision 1.16.1.8.1.2  2014/11/04 11:31:17  martin
 *  Revision 1.16.1.8.1.1  2014/10/30 16:14:07  martin
 *  Started to support XBP addressing.
 *  Revision 1.16.1.8  2014/10/30 16:03:09  martin
 *  Doxygen fixes.
 *  Revision 1.16.1.7  2014/10/30 14:47:06  martin
 *  Support FTDI devices.
 *  Updated USB support.
 *  Updated function prototypes.
 *  Revision 1.16.1.6  2013/11/28 15:51:48Z  marvin
 *  Added mbgextio_get_ntp_peer_state_idx.
 *  Revision 1.16.1.5  2013/11/26 16:06:48Z  marvin
 *  Added mbgextio_get_ntp_sys_state.
 *  Revision 1.16.1.4  2013/11/21 07:46:52Z  marvin
 *  Added mbgextio_xmt_secu_settings.
 *  Revision 1.16.1.3  2013/11/12 12:12:05Z  marvin
 *  Changed calls for NTP info and settings.
 *  Revision 1.16.1.2  2013/10/14 08:54:22Z  marvin
 *  Added mbgextio_set_ntp_clnt_mode_cfg.
 *  Revision 1.16.1.1  2013/09/25 11:10:10Z  marvin
 *  Added support for NTP and PTP.
 *  Revision 1.16  2013/09/10 08:56:35Z  marvin
 *  Changed Doxygen comments.
 *  Revision 1.15  2013/09/05 15:11:40Z  marvin
 *  Added support for LAN interface setup.
 *  Added support for PTP state.
 *  Added support for XMR.
 *  Added support for NTP info.
 *  Revision 1.14  2013/09/02 15:16:49Z  marvin
 *  Added support for XMR (get multi ref info, set multi ref settings)
 *  Revision 1.13  2013/08/28 11:01:42Z  marvin
 *  Added read and set tr_distance and gnss_mode.
 *  Revision 1.12  2013/04/11 14:18:47Z  Gregoire
 *  new prototypes for sending havequick rx and tx settings to clock
 *  Revision 1.11  2013/02/06 15:44:57Z  martin
 *  Updated function prototypes.
 *  Revision 1.10  2013/02/01 15:59:42  martin
 *  Updated function prototypes.
 *  Revision 1.9  2012/10/30 16:19:19  martin
 *  Support USB I/O.
 *  Started to migrate to opaque stuctures.
 *  Updated function prototypes.
 *  Revision 1.8  2011/04/08 11:26:09  martin
 *  New macros _ttm_time_set_unavail() and _ttm_time_is_avail().
 *  Revision 1.7  2009/10/02 14:21:08  martin
 *  Updated function prototypes.
 *  Revision 1.6  2009/10/01 11:13:42Z  martin
 *  Updated function prototypes.
 *  Revision 1.5  2009/03/10 17:03:09Z  martin
 *  Updated function prototypes.
 *  Revision 1.4  2008/09/04 14:13:19Z  martin
 *  Added macro _mbgextio_xmt_msg().
 *  Updated function prototypes.
 *  Removed obsolete code.
 *  Revision 1.3  2007/02/27 10:30:06Z  martin
 *  Added some global variables.
 *  Updated function prototypes.
 *  Revision 1.2  2006/12/21 10:56:35  martin
 *  Updated function prototypes.
 *  Revision 1.1  2006/08/24 12:40:37  martin
 *  Initial revision.
 *
 **************************************************************************/

#ifndef _MBGEXTIO_H
#define _MBGEXTIO_H


/* Other headers to be included */

#include <mbg_arch.h>
#include <gpsserio.h>
#include <mbggeo.h>

#if _USE_PCPSDEFS
  #include <pcpsdefs.h>
#endif

#if _USE_TIME_MON
  #include <time_mon.h>
#endif

#include <time.h>

#ifdef _MBGEXTIO
 #define _ext
 #define _DO_INIT
#else
 #define _ext extern
#endif

/* Start of header body */


/**
 * @defgroup mbgextio_chk_supp_fncs mbgextio functions used to check if a particular feature is supported
 * @ingroup chk_supp_fncs
 *
 * Each of these functions can be used to check if a device supports a particular feature.
 * ::MBG_SUCCESS is returned if the requested feature is supported, otherwise one of the
 * @ref MBG_ERROR_CODES is returned, as appropriate.
 */


// The macros below can be used to set a TTM variable to a state
// indicating "time not available", and to check this state.
// This can be used for example to indicate if a capture event
// could have been read from a device, or not.
#define _ttm_time_set_unavail( _t )       do { (_t)->tm.sec = (uint8_t) 0xFF; } while ( 0 )
#define _ttm_time_is_avail( _t )          ( (uint8_t) (_t)->tm.sec != (uint8_t) 0xFF )


#if !_USE_SERIAL_IO_FTDI
  // just to avoid build errors if FTDI serial is not supported
  #define FT_STATUS int
  #define FT_HANDLE int
#endif


#if !_USE_USB_IO
  // just to avoid build errors if USB is not supported
  typedef int MBG_USB_DEV_INFO;
  typedef int libusb_device;
#endif


#if !defined( _MBGEXTIO_REQ_ACK )
  // If _MBGEXTIO_REQ_ACK is != 0 then mbgextio_...() functions writing
  // configuration parameters send the cmd code with the ACK request bit set
  // which lets mbgextio_xmt_msg() try to receive a response from the device
  // after the parameters have been sent.
  #define _MBGEXTIO_REQ_ACK  1
#endif

#if _MBGEXTIO_REQ_ACK
  #define OPT_GPS_ACK_CODE   GPS_REQACK
#else
  #define OPT_GPS_ACK_CODE   0   // dummy
#endif


#if !defined MBGEXTIO_READ_BUFFER_SIZE
  #if _USE_SOCKET_IO || _USE_USB_IO
    #define MBGEXTIO_READ_BUFFER_SIZE  1000
  #else
    #if defined _USE_USB_DIRECT_IO
      #define MBGEXTIO_READ_BUFFER_SIZE (MAX_MSG_DATA_SIZE + 1)   // See gpsserio.h + SOH
    #else
      #define MBGEXTIO_READ_BUFFER_SIZE  10
    #endif
  #endif
#endif


_ext uint32_t mbg_baud_rates[N_MBG_BAUD_RATES]
#ifdef _DO_INIT
  = MBG_BAUD_RATES
#endif
;

_ext const char *mbg_baud_rate_strs[N_MBG_BAUD_RATES]
#ifdef _DO_INIT
  = MBG_BAUD_STRS
#endif
;

_ext const char *mbg_framing_strs[N_MBG_FRAMINGS]
#ifdef _DO_INIT
  = MBG_FRAMING_STRS
#endif
;


#if _USE_SOCKET_IO

  #define MBG_LAN_REQUEST_CONFIG          0x000000F8
  #define MBG_LAN_RESPOND_CONFIG          0x000000F9
  #define MBG_LAN_UDP_BROADCAST_PORT      30718

  typedef struct
  {
    uint8_t interface_mode;
    uint8_t line_speed;
    uint8_t flow_control;
    uint8_t reserved_0;
    uint16_t own_tcp_port;
    uint16_t remote_tcp_port;
    uint32_t remote_ip_address;
    uint8_t connect_mode;
    uint8_t disconnect_mode;
    uint8_t disconnect_timeout_min;
    uint8_t disconnect_timeout_sec;
    uint8_t trigger_char_semd_imm0;
    uint8_t trigger_char_semd_imm1;
    uint8_t flush_mode;
    uint8_t pack_control;
    uint32_t reserved_1[3];
    uint8_t terminal_name[16];
  } MBG_LAN_DEV_CHAN;

  typedef struct
  {
    uint32_t command;
    uint32_t ip_address;
    uint8_t reserved_0;
    uint8_t flags;
    uint8_t prefix;
    uint8_t reserved_1;
    uint32_t telnet_password;
    uint32_t gateway_ip_address;
    MBG_LAN_DEV_CHAN channel_0;
    MBG_LAN_DEV_CHAN channel_1;
    uint32_t reserved_2;
    uint32_t reserved_3;
  } MBG_LAN_DEV_CFG;

  typedef struct mbg_lan_dev_list
  {
    MBG_LAN_DEV_CFG config;
    struct mbg_lan_dev_list *next;
  } MBG_LAN_DEV_LIST;

#else

  typedef int MBG_LAN_DEV_CHAN;
  typedef int MBG_LAN_DEV_CFG;
  typedef int MBG_LAN_DEV_LIST;

#endif


/**
 * @brief Type of functions to check if a feature is supported
 */
typedef int _MBG_API MBGEXTIO_CHK_SUPP_FNC( const MBG_MSG_CTL *pmctl );


/* function prototypes: */

#ifdef __cplusplus
extern "C" {
#endif


#if defined( MBG_TGT_WIN32 )
  void deinit_winsock( void );
  int check_init_winsock( void );
#endif


/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 const char *mbgextio_get_cmd_name( GPS_CMD cmd_code ) ;
 /**
 * @brief Sets up a list of all available Meinberg LAN devices in the network
 *
 * List entries will be allocated and have to be freed by calling ::mbgextio_free_lan_devices
 *
 * @param[out]    list        Pointer to the list
 * @param[in]     timeout_ms  Timeout in ms for each network interface
 *
 * @return One of the @ref MBG_RETURN_CODES or the number of found devices on success
 *
 * @see ::mbgextio_free_lan_devices
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_find_lan_devices( MBG_LAN_DEV_LIST **list, uint16_t timeout_ms ) ;

 /**
 * @brief Frees the ::MBG_LAN_DEV_LIST allocated by ::mbgextio_find_lan_devices
 *
 * @param[in]     list      The list that will be freed
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_find_lan_devices
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_free_lan_devices( MBG_LAN_DEV_LIST *list ) ;

 /**
 * @brief Send security settings for the socket connection
 *
 * If new_passwd is not a NULL pointer, the old_passwd
 * will be overwritten by the new_passwd.
 *
 * @param[in,out] pmctl       Pointer to a valid message control structure
 * @param[in]     p_addr      Pointer to an XBP address specifier, or NULL
 * @param[in]     old_passwd  Pointer to the current LAN port password of the device
 * @param[in]     new_passwd  Pointer to the new LAN port password for the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_open_socket
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_secu_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const char *old_passwd, const char *new_passwd ) ;

 /**
 * @brief Open a binary communication channel via a LAN/socket connection
 *
 * @param[in]  host    DNS name or IP address of the target device
 * @param[out] ppmctl  Address of a pointer to a ::MBG_MSG_CTL control structure
 *                     allocated and set up by this call.
 *                     Pointer is set to NULL on error.
 * @param[in]  passwd  Password string for the encrypted communication
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_open_serial
 * @see ::mbgextio_open_serial_ftdi
 * @see ::mbgextio_open_usb
 * @see ::mbgextio_open_usb_direct_io
 * @see ::mbgextio_close_connection
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_open_socket( const char *host, MBG_MSG_CTL **ppmctl, const char *passwd ) ;

 int mbgextio_open_serial_raw( const char *dev, MBG_MSG_CTL **ppmctl, uint32_t baud_rate, const char *framing ) ;
 /**
 * @brief Open a binary communication channel using direct serial I/O
 *
 * Commonly used serial parameters are 19200/8N1, see
 * ::MBG_DEFAULT_BAUDRATE and ::MBG_DEFAULT_FRAMING.
 * Some newer devices may also support ::MBG_DEFAULT_BAUDRATE_HS.
 *
 * @param[in]  dev        Name of the serial port to which the device is connected,
 *                        depending on the naming conventions of the host system.
 * @param[out] ppmctl     Address of a pointer to a ::MBG_MSG_CTL control structure
 *                        allocated and set up by this call. Set to NULL on error.
 * @param[in]  baud_rate  Baud rate used for serial communication
 * @param[in]  framing    Framing used for serial communication
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_force_conn_serial
 * @see ::mbgextio_open_serial_ftdi
 * @see ::mbgextio_force_conn_serial_ftdi
 * @see ::mbgextio_open_socket
 * @see ::mbgextio_open_usb
 * @see ::mbgextio_open_usb_direct_io
 * @see ::mbgextio_close_connection
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_open_serial( const char *dev, MBG_MSG_CTL **ppmctl, uint32_t baud_rate, const char *framing ) ;

 /**
 * @brief Open a binary communication channel forcing default serial parameters
 *
 * If current serial paramaters (baud rate and framing) do not match the default
 * parameters for binary communication then the serial device is forced into
 * binary communication mode.
 *
 * @param[in]  dev        Name of the serial port to which the device is connected,
 *                        depending on the naming conventions of the host system.
 * @param[out] ppmctl     Address of a pointer to a ::MBG_MSG_CTL control structure
 *                        allocated and set up by this call. Set to NULL on error.
 * @param[in]  baud_rate  Baud rate used for serial communication
 * @param[in]  framing    Framing used for serial communication
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_open_serial
 * @see ::mbgextio_open_serial_raw
 * @see ::mbgserio_write
 * @see ::mbgextio_close_connection
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_open_serial_force_default( const char *dev, MBG_MSG_CTL **ppmctl, uint32_t baud_rate, const char *framing ) ;

 /**
 * @brief Get the port handle of a serial FTDI device
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return the port handle retrieved from the message control structure
 */
 _NO_MBG_API_ATTR FT_HANDLE _MBG_API mbgextio_get_serial_ftdi_port_handle( MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Open a binary communication channel using serial FTDI D2xx port
 *
 * Commonly used serial parameters are 19200/8N1, see
 * ::MBG_DEFAULT_BAUDRATE and ::MBG_DEFAULT_FRAMING.
 * Some newer devices may also support ::MBG_DEFAULT_BAUDRATE_HS.
 *
 * @param[in]  device_num  device number from a list set up by FT_ListDevices()
 * @param[out] ppmctl      Address of a pointer to a ::MBG_MSG_CTL control structure
 *                         allocated and set up by this call. Set to NULL on error.
 * @param[in] baud_rate    Baud rate used for serial communication
 * @param[in] framing      Framing used for serial communication
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_force_conn_serial_ftdi
 * @see ::mbgextio_open_serial
 * @see ::mbgextio_force_conn_serial
 * @see ::mbgextio_open_socket
 * @see ::mbgextio_open_usb
 * @see ::mbgextio_open_usb_direct_io
 * @see ::mbgextio_close_connection
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_open_serial_ftdi( int device_num, MBG_MSG_CTL **ppmctl, uint32_t baud_rate, const char *framing ) ;

 /**
 * @brief Open a binary communication channel using direct USB I/O
 *
 * @param[in]  mdev_info  The USB device to communicate with.
 * @param[out] ppmctl     Address of a pointer to a ::MBG_MSG_CTL control structure
 *                        allocated and set up by this call. Set to NULL on error.
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_open_socket
 * @see ::mbgextio_open_serial
 * @see ::mbgextio_open_serial_ftdi
 * @see ::mbgextio_close_connection
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_open_usb( const MBG_USB_DEV_INFO *mdev_info, MBG_MSG_CTL **ppmctl ) ;

 /**
 * @brief Reset an USB device in case that the open_usb function return MBG_ERR_BUSY
 *
 * @param[in]  mdev_info  The USB device to communicate with.
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_open_socket
 * @see ::mbgextio_open_serial
 * @see ::mbgextio_open_serial_ftdi
 * @see ::mbgextio_close_connection
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_reset_usb( const MBG_USB_DEV_INFO *mdev_info ) ;

 /**
 * @brief Open a binary communication channel using direct USB I/O
 *
 * //### TODO group opening functions, ref to group only
 *
 * @param[in]  ldev    A libusb_device to communicate with.
 * @param[out] ppmctl  Address of a pointer to a ::MBG_MSG_CTL control structure
 *                     allocated and set up by this call. Set to NULL on error.
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_open_socket
 * @see ::mbgextio_open_serial
 * @see ::mbgextio_open_serial_ftdi
 * @see ::mbgextio_close_connection
 */
 int mbgextio_open_usb_ldev( libusb_device *ldev, MBG_MSG_CTL **ppmctl ) ;

 /**
 * @brief Open a binary communication channel using direct USB I/O
 *
 * Currently it is only supported by Linux systems since a file like
 * USB device (e.g. "/dev/mbgims") is required and needs to support
 * basic I/O operations like write, read, etc...
 *
 * @param[in]   dev     Path to file like USB device
 * @param[in]   flags   Bitwise OR flags of access modes like W,RW,RO,etc.
 * @param[out]  ppmctl  Address of a pointer to a ::MBG_MSG_CTL control structure
 *                      allocated and set up by this call. Set to NULL on error.
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_open_socket
 * @see ::mbgextio_open_serial
 * @see ::mbgextio_open_serial_ftdi
 * @see ::mbgextio_open_usb
 * @see ::mbgextio_open_usb_direct_io
 * @see ::mbgextio_close_connection
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_open_usb_direct_io( const char *dev, int flags, MBG_MSG_CTL **ppmctl ) ;

 /**
 * @brief Close a binary communication channel and release resources
 *
 * Closes a binary communication channel which has been opened by one
 * of the mbgextio_open_...() functions and releases the buffers which
 * have been allocated when the channel was opened.
 *
 * The pointer to the message control structure passed by address is set
 * to NULL after the channel has been closed and the resources have
 * been released.
 *
 * @param[in,out] ppmctl Address of a pointer to a message control structure
 *                       created when the communication channel was opened
 *                       by one of the mbgextio_open_...() calls.
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_open_socket
 * @see ::mbgextio_open_serial
 * @see ::mbgextio_open_serial_ftdi
 * @see ::mbgextio_open_usb
 * @see ::mbgextio_open_usb_direct_io
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_close_connection( MBG_MSG_CTL **ppmctl ) ;

 /**
 * @brief Try to force a serial connection to a device
 *
 * A device's serial port may have been configured to work by default
 * in a way which is not appropriate for binary communication, e.g. using
 * a low communication speed, or some framing like "7E2" which messes up
 * binary data since the parity bit overrides a data bit.
 *
 * This function sends a special ASCII string to a device which lets the device
 * temporarily switch to a specific baud rate and 8N1 framing which is usually
 * used for binary communication, see ::MBG_DEFAULT_BAUDRATE,
 * ::MBG_DEFAULT_BAUDRATE_HS, and ::MBG_DEFAULT_FRAMING.
 *
 * Since the current settings of the device's serial port are unknown this
 * this command is sent in all common combinations of baud rates and
 * framings.
 *
 * If the connected device supports this it should be possible to open
 * the serial communication channel using the default parameters after
 * this function has finished.
 *
 * @param[in] dev  Name of the serial port to which the device is connected,
 *                 depending on the naming conventions of the target system
 *
 * @return One of the negative @ref MBG_ERROR_CODES on error,
 *         else the determined baud rate.
 *
 * @see ::mbgextio_open_serial
 * @see ::mbgextio_open_serial_ftdi
 */
 _NO_MBG_API_ATTR long _MBG_API mbgextio_force_conn_serial( const char *dev ) ;

 /**
 * @brief Try to force a serial connection to a device via the FTDI API
 *
 * A device's serial port may have been configured to work by default
 * in a way which is not appropriate for binary communication, e.g. using
 * a low communication speed, or some framing like "7E2" which messes up
 * binary data since the parity bit overrides a data bit.
 *
 * This function sends a special ASCII string to a device which lets the device
 * temporarily switch to a specific baud rate and 8N1 framing which is usually
 * used for binary communication, see ::MBG_DEFAULT_BAUDRATE,
 * ::MBG_DEFAULT_BAUDRATE_HS, and ::MBG_DEFAULT_FRAMING.
 *
 * Since the current settings of the device's serial port are unknown this
 * this command is sent in all common combinations of baud rates and
 * framings.
 *
 * If the connected device supports this it should be possible to open
 * the serial communication channel using the default parameters after
 * this function has finished.
 *
 * @param[in] device_num  device number from a list set up by FT_ListDevices()
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_open_serial_ftdi
 */
 _NO_MBG_API_ATTR long _MBG_API mbgextio_force_conn_serial_ftdi( int device_num ) ;

 /**
 * @brief Set a message callback function
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     fnc    Address of the callback function to be registered
 *
 * @return Address of the allocated receive buffer
 *
 * @see ::mbgextio_get_rcv_buffer_size
 * @see ::mbgextio_get_xmt_buffer_addr
 * @see ::mbgextio_get_xmt_buffer_size
 */
 _NO_MBG_API_ATTR void _MBG_API mbgextio_register_msg_callback( MBG_MSG_CTL *pmctl, MBG_MSG_HANDLER *fnc ) ;

 /**
 * @brief Retrieve address of the ::RECEIVER_INFO read from the device
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return Address of the ::RECEIVER_INFO read from the device when the device was opened
 */
 _NO_MBG_API_ATTR RECEIVER_INFO * _MBG_API mbgextio_get_receiver_info_addr( MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Retrieve address of the allocated receive buffer
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return Address of the allocated receive buffer
 *
 * @see ::mbgextio_get_rcv_buffer_size
 * @see ::mbgextio_get_xmt_buffer_addr
 * @see ::mbgextio_get_xmt_buffer_size
 */
 _NO_MBG_API_ATTR MBG_MSG_BUFF * _MBG_API mbgextio_get_rcv_buffer_addr( MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Retrieve size of the allocated receive buffer
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return Size of the allocated receive buffer
 *
 * @see ::mbgextio_get_rcv_buffer_addr
 * @see ::mbgextio_get_xmt_buffer_addr
 * @see ::mbgextio_get_xmt_buffer_size
 */
 _NO_MBG_API_ATTR size_t _MBG_API mbgextio_get_rcv_buffer_size( MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Retrieve address of the allocated transmit buffer
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return Address of the allocated transmit buffer
 *
 * @see ::mbgextio_get_rcv_buffer_addr
 * @see ::mbgextio_get_rcv_buffer_size
 * @see ::mbgextio_get_xmt_buffer_size
 */
 _NO_MBG_API_ATTR MBG_MSG_BUFF * _MBG_API mbgextio_get_xmt_buffer_addr( MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Retrieve size of the allocated transmit buffer
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return Size of the allocated transmit buffer
 *
 * @see ::mbgextio_get_rcv_buffer_addr
 * @see ::mbgextio_get_rcv_buffer_size
 * @see ::mbgextio_get_xmt_buffer_addr
 */
 _NO_MBG_API_ATTR size_t _MBG_API mbgextio_get_xmt_buffer_size( MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Set device poll timeout
 *
 * @param[in,out] pmctl        Pointer to a valid message control structure
 * @param[in]     new_timeout  New poll timeout value [ms]
 *
 * @return Previous poll timeout value [ms]
 *
 * @see ::mbgextio_get_dev_poll_timeout
 * @see ::mbgextio_set_msg_rcv_timeout
 * @see ::mbgextio_get_msg_rcv_timeout
 */
 _NO_MBG_API_ATTR ulong _MBG_API mbgextio_set_dev_poll_timeout( MBG_MSG_CTL *pmctl, ulong new_timeout ) ;

 /**
 * @brief Get device poll timeout
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return Current poll timeout value [ms]
 *
 * @see ::mbgextio_set_dev_poll_timeout
 * @see ::mbgextio_set_msg_rcv_timeout
 * @see ::mbgextio_get_msg_rcv_timeout
 */
 _NO_MBG_API_ATTR ulong _MBG_API mbgextio_get_dev_poll_timeout( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Set message receive timeout value
 *
 * @param[in,out] pmctl        Pointer to a valid message control structure
 * @param[in]     new_timeout  New timeout value [ms]
 *
 * @see ::mbgextio_set_dev_poll_timeout
 * @see ::mbgextio_get_dev_poll_timeout
 * @see ::mbgextio_get_msg_rcv_timeout
 */
 _NO_MBG_API_ATTR void _MBG_API mbgextio_set_msg_rcv_timeout( MBG_MSG_CTL *pmctl, ulong new_timeout ) ;

 /**
 * @brief Get message receive timeout value
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return Current timeout value [ms]
 *
 * @see ::mbgextio_set_dev_poll_timeout
 * @see ::mbgextio_get_dev_poll_timeout
 * @see ::mbgextio_set_msg_rcv_timeout
 */
 _NO_MBG_API_ATTR ulong _MBG_API mbgextio_get_msg_rcv_timeout( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Get last NACK error code
 *
 * If an API call has returned ::MBG_ERR_RCVD_NACK then this
 * function can be used to retrieve an associated error code
 * which eventually specifies the reason for the NACK message.
 *
 * A NACK message can be received from a device after the device
 * has received a command which it doesn't recognize, or a
 * parameter set which it doesn't accept, and the message can
 * optionally contain one of the @ref MBG_ERROR_CODES.
 *
 * If the NACK message contains an error code then that code is
 * saved, otherwise the saved code is set to ::MBG_ERR_UNSPEC.
 * A saved error code is available and can be retrieved until
 * the next API call starts to read some data from the device,
 * in which case the stored code is set to ::MBG_SUCCESS.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return The saved return code, i.e. one of the @ref MBG_RETURN_CODES.
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_last_nack_err_code( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device is a legacy device
 *
 * Legacy devices don't support the standard binary protocol, so the
 * standard binary API functions must *not* be used with such a device.
 * Any attempt to access the device using the standard binary API
 * functions may have unpredictable side-effects for the device, but
 * the low level read/write functions can be used to access the device
 * via a proprietary protocol, depending on the device type.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_DEV_NOT_SUPP
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_is_legacy( const MBG_MSG_CTL *pmctl ) ;

 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_pos_xyz( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_pos_lla( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_time_ttm( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_ant_info( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_ant_cable_length( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_io_ports( const MBG_MSG_CTL *pmctl ) ;
 /**
 * @brief Check if a device supports the ::STAT_INFO structure and API
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_gps_stat_info( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device can receive the GPS satellite system
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_is_gps( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the GNSS API
 *
 * This is usually supported by devices which can receive signals
 * from different satellite systems, e.g. GPS, GLONASS, ...
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::mbgextio_chk_get_all_gnss_info
 * @see ::MBG_GNSS_TYPES
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_is_gnss( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device is a bus level device
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_is_bus_lvl_dev( const MBG_MSG_CTL *pmctl ) ;

 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_enable_flags( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_time_scale( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_tzdl( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_tzcode( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_ims( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_synth( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_gpio( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_prog_pulses( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_irig_tx( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_irig_rx( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_serouts( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_bvar_stat( const MBG_MSG_CTL *pmctl ) ;
 /**
 * @brief Check if the device supports the SCU_STAT structures
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref mbgextio_chk_supp_fncs
 * @see ::mbgextio_get_scu_stat_info
 * @see ::mbgextio_set_scu_stat_settings
 * @see @ref group_scu
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_scu_stat( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a timecode receiver provides ::MBG_RAW_IRIG_DATA
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::mbgextio_get_raw_irig_data
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_raw_irig_data( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the old LAN_IP4 API
 *
 * The LAN_IP4 API provides structures and functions to configure
 * parts of the networking of a device and is superseded by the
 * NET_CFG API. Some devices combine NET_CFG and LAN_IP4.
 * Therefore, ::mbgextio_get_all_net_cfg_info should be used
 * preferably to read the network configuration.
 * It will translate the old structures into the new ones.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::mbgextio_get_all_net_cfg_info
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_lan_ip4( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the new NET_CFG API
 *
 * The NET_CFG API provides structures and functions to configure
 * the complete networking part of a device and supersedes the
 * LAN_IP4 API. Not all devices support the whole feature set
 * of the NET_CFG API or combine NET_CFG and LAN_IP4.
 * Therefore, ::mbgextio_get_all_net_cfg_info should be used
 * preferably to read the network configuration.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::mbgextio_get_all_net_cfg_info
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_net_cfg( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the PTP API
 *
 * The PTP API consists of different calls and associated structures
 * which * have evolved over time. Not all devices support every call,
 * so ::mbgextio_get_all_ptp_cfg_info takes care to check which parts are
 * supported and thus should be used preferably to read PTP information.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::mbgextio_get_all_ptp_cfg_info
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_ptp( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the NTP API
 *
 * The NTP API consists of different calls and associated structures
 * which have evolved over time. Not all devices support every call,
 * so ::mbgextio_get_all_ntp_cfg_info takes care to check which parts are
 * supported and thus should be used preferably to read NTP information.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::mbgextio_get_all_ntp_cfg_info
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_ntp( const MBG_MSG_CTL *pmctl ) ;

 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_evt_log( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_ucap( const MBG_MSG_CTL *pmctl ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_ucap_net( const MBG_MSG_CTL *pmctl ) ;
 /**
 * @brief Check if a device supports the TLV API
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref group_tlv_api
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_tlv_api( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports a firmware update via TLV
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::TODO  //refer to fw update function
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_supp_tlv_fw_update( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports creating / sending a diagnostics file via TLV
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::TODO  //refer to get diag function
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_supp_tlv_diag_file( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports upports PTPv2 license infos
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::TODO  //refer to get diag function
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_supp_tlv_ptpv2_license( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports supports PTPv1 License Infos via TLV
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::TODO  //refer to get diag function
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_supp_tlv_ptpv1_license( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports supports NTP license infos via TLV
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::TODO  //refer to get diag function
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_supp_tlv_ntp_license( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports supportsTime Monitor License infos via TLV
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::TODO  //refer to get diag function
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_supp_tlv_time_monitor_license( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the ::GPS_SAVE_CFG command
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::mbgextio_cmd_save_cfg
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_cmd_save_cfg( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the extended feature monitoring
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see xdevfeat_has_monitoring
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_monitoring( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the LED API
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::TODO ###
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_led_api( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the LNE API
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::TODO ###
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_lne_api( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the power control API
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see ::TODO ###
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_pwr_ctl_api( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device has MBG_XFEATURE_EXT_SYS_INFO
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_ext_sys_info( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device has MBG_XFEATURE_TRANSACTIONS
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_transactions( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device has MBG_XFEATURE_REBOOT
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_reboot( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device has MBG_XFEATURE_REQ_TTM
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref mbgextio_chk_supp_fncs
 * @see mbgextio_get_time
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_req_ttm( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the up-to-date extended multi ref API
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_xmulti_ref( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Check if a device supports the extended binary protocl (XBP) feature
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup mbgextio_chk_supp_fncs
 * @see @ref mbgextio_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_dev_has_xbp( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Generic reception of a binary message
 *
 * @note A certain message type to be waited for can be specified by
 * passing one of the ::GPS_CMD_CODES.
 * If the special cmd code ::GPS_WILDCARD is specified the function returns
 * successfully after *any* type of binary message has been received.
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[in]     cmd       One of the command codes enumerated in ::GPS_CMD_CODES, or ::GPS_WILDCARD
 * @param[out]    buf       Pointer to a buffer to be filled with the requested data, or NULL
 * @param[in]     buf_size  Size of the buffer specified by buf
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_rcv_msg_unlocked
 * @see ::mbgextio_xmt_msg  //##++++
 * @see ::mbgextio_xmt_cmd
 * @see ::mbgextio_req_data
 * @see ::mbgextio_xmt_cmd_us
 * @see ::mbgextio_req_data_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_rcv_msg_unlocked( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd, void *buf, size_t buf_size ) ;

 /**
 * @brief Generic reception of a binary message
 *
 * @note A certain message type to be waited for can be specified by
 * passing one of the ::GPS_CMD_CODES.
 * If the special cmd code ::GPS_WILDCARD is specified the function returns
 * successfully after *any* type of binary message has been received.
 *
 * //##++ TODO: callback function to handle asynchronous spontaneous messages
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[in]     cmd       One of the command codes enumerated in ::GPS_CMD_CODES, or ::GPS_WILDCARD
 * @param[out]    buf       Pointer to a buffer to be filled with the requested data, or NULL
 * @param[in]     buf_size  Size of the buffer specified by buf
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_rcv_msg_unlocked
 * @see ::mbgextio_xmt_msg  //##++++
 * @see ::mbgextio_xmt_cmd
 * @see ::mbgextio_req_data
 * @see ::mbgextio_xmt_cmd_us
 * @see ::mbgextio_req_data_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_rcv_msg( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd, void *buf, size_t buf_size ) ;

 /**
 * @brief Set up and send a generic binary message
 *
 * This function should preferably be used only as low level function
 * called from within more specific functions used to send specific data.
 *
 * If this function is called directly with a buffer p to be sent then the
 * device mutex is acquired by this function, and after this the specified
 * buffer p  is copied to the transmit buffer.
 *
 * However, other (higher level) API functions which set up the transmit
 * buffer directly have to acquire the device mutex by themselves *before*
 * they set up the transmit buffer, and then pass p as NULL pointer to
 * indicate the transmit buffer has already been set up. The correct number
 * of bytes to be sent (n_bytes) has to be specified anyway, though.
 *
 * @param[in,out] pmctl    Pointer to a valid message control structure
 * @param[in]     p_addr   Pointer to an XBP address specifier, or NULL
 * @param[in]     cmd      One of the command codes enumerated in ::GPS_CMD_CODES
 * @param[in]     p        Address of a data structure according to the specified cmd parameter, or NULL
 * @param[in]     n_bytes  Size of the data structure addressed by parameter p
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_msg( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd, const void *p, uint16_t n_bytes ) ;

 /**
 * @brief Transmit a command-only message without additional data.
 *
 * If the caller has or'ed the cmd code with ::GPS_REQACK then this
 * function expects an ACK or a NACK message to be replied by the device.
 *
 * Transmission is protected by a mutex which is acquired before
 * and released after the binary message has been sent.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     cmd    One of the command codes enumerated in ::GPS_CMD_CODES, optionally or'ed with ::GPS_REQACK
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_xmt_msg
 * @see ::mbgextio_rcv_msg_unlocked
 * @see ::mbgextio_req_data
 * @see ::mbgextio_xmt_cmd_us
 * @see ::mbgextio_req_data_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_cmd( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd ) ;

 /**
 * @brief Transmit a message with a single ushort (uint16_t) parameter
 *
 * The uint16_t parameter us is often used to send an index value when requesting
 * a certain element of an array of same data structures.
 *
 * Transmission is protected by a mutex which is acquired before
 * and released after the binary message has been sent.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     cmd    One of the command codes enumerated in ::GPS_CMD_CODES
 * @param[in]     us     The ushort parameter for the command code
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_xmt_msg
 * @see ::mbgextio_rcv_msg_unlocked
 * @see ::mbgextio_xmt_cmd
 * @see ::mbgextio_req_data
 * @see ::mbgextio_req_data_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_cmd_us( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd, uint16_t us ) ;

 /**
 * @brief Transmit a message without a single ushort (16 bit) parameter
 *
 * The ushort parameter is often used to send an index value when requesting
 * a specific element of an array of data structures.
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[in]     cmd       One of the command codes enumerated in ::GPS_CMD_CODES
 * @param[out]    buf       Pointer to a buffer to be filled with the requested data, or NULL
 * @param[in]     buf_size  Size of the buffer specified by buf
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_xmt_msg
 * @see ::mbgextio_rcv_msg_unlocked
 * @see ::mbgextio_xmt_cmd
 * @see ::mbgextio_xmt_cmd_us
 * @see ::mbgextio_req_data_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_req_data( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd, void *buf, size_t buf_size ) ;

 /**
 * @brief Read a specific element of an array of data structures
 *
 * This function dos not lock/unlock the device mutex, so this has to be done by
 * The type of data is implicitly associated with the cmd parameter.
 * The type of data is implicitly associated with the cmd parameter.
 * Usually the number of supported array elements has to be determined
 * by some other means, e.g. from a field in the ::RECEIVER_INFO structure.
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[in]     cmd       One of the command codes enumerated in ::GPS_CMD_CODES
 * @param[in]     idx       The index of the array element to read
 * @param[out]    buf       Pointer to a buffer to be filled with the requested data, or NULL
 * @param[in]     buf_size  Size of the buffer specified by buf
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_xmt_msg
 * @see ::mbgextio_rcv_msg_unlocked
 * @see ::mbgextio_xmt_cmd
 * @see ::mbgextio_req_data
 * @see ::mbgextio_xmt_cmd_us
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_req_data_idx_unlocked( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd, uint16_t idx, void *buf, size_t buf_size ) ;

 /**
 * @brief Read a specific element of an array of data structures
 *
 * The type of data is implicitly associated with the cmd parameter.
 * Usually the number of supported array elements has to be determined
 * by some other means, e.g. from a field in the ::RECEIVER_INFO structure.
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[in]     cmd       One of the command codes enumerated in ::GPS_CMD_CODES
 * @param[in]     idx       The index of the array element to read
 * @param[out]    buf       Pointer to a buffer to be filled with the requested data, or NULL
 * @param[in]     buf_size  Size of the buffer specified by buf
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_xmt_msg
 * @see ::mbgextio_rcv_msg_unlocked
 * @see ::mbgextio_xmt_cmd
 * @see ::mbgextio_req_data
 * @see ::mbgextio_xmt_cmd_us
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_req_data_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd, uint16_t idx, void *buf, size_t buf_size ) ;

 /**
 * @brief Read a receiver info structure
 *
 * The ::RECEIVER_INFO should be read at first to identify the connected
 * device and determine the basic features supported by the device.
 *
 * @note Some very old devices may not provide a ::RECEIVER_INFO,
 * so ::mbgextio_setup_receiver_info should be called preferably
 * to read the receiver info using this function, if supported,
 * or set up a default structure for devices which don't provide
 * a receiver info.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_setup_receiver_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_receiver_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, RECEIVER_INFO *p ) ;

 /**
 * @brief Read I/O port limits in ::MBG_IO_PORT_LIMITS format
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent by the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_io_port_settings_idx
 * @see ::mbgextio_get_io_port_info_idx
 * @see ::mbgextio_get_io_port_type_info_idx
 * @see ::mbgextio_get_io_port_status_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_io_port_limits( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IO_PORT_LIMITS *p ) ;

 /**
 * @brief Send I/O port settings in ::MBG_IO_PORT_SETTINGS format
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of I/O port settings to be configured, 0..MBG_IO_PORT_LIMITS::num_ports - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_io_port_limits
 * @see ::mbgextio_get_io_port_info_idx
 * @see ::mbgextio_get_io_port_type_info_idx
 * @see ::mbgextio_get_io_port_status_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_io_port_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_IO_PORT_SETTINGS *p, uint8_t idx ) ;

 /**
 * @brief Read I/O port info in ::MBG_IO_PORT_INFO_IDX format
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be read from the device
 * @param[in]     idx    Index of I/O port info to be read, 0..MBG_IO_PORT_LIMITS::num_ports - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_io_port_limits
 * @see ::mbgextio_set_io_port_settings_idx
 * @see ::mbgextio_get_io_port_type_info_idx
 * @see ::mbgextio_get_io_port_status_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_io_port_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IO_PORT_INFO_IDX *p, uint8_t idx ) ;

 /**
 * @brief Read I/O port type info in ::MBG_IO_PORT_TYPE_INFO_IDX format
 *
 * @param[in,out] pmctl          Pointer to a valid message control structure
 * @param[in]     p_addr         Pointer to an XBP address specifier, or NULL
 * @param[out]    p              Pointer to the data structure to be read from the device
 * @param[in]     port_idx       Index of I/O port to be read, 0..MBG_IO_PORT_LIMITS::num_ports - 1
 * @param[in]     port_type_idx  Index of I/O port type info to be read, 0..MBG_IO_PORT_INFO::num_types - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_io_port_limits
 * @see ::mbgextio_set_io_port_settings_idx
 * @see ::mbgextio_get_io_port_info_idx
 * @see ::mbgextio_get_io_port_status_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_io_port_type_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IO_PORT_TYPE_INFO_IDX *p, uint8_t port_idx, uint8_t port_type_idx) ;

 /**
 * @brief Read I/O port status in ::MBG_IO_PORT_STATUS_IDX format
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to be read from the device
 * @param[in]     idx       Index of I/O port to be read, 0..MBG_IO_PORT_LIMITS::num_ports - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_io_port_limits
 * @see ::mbgextio_set_io_port_settings_idx
 * @see ::mbgextio_get_io_port_info_idx
 * @see ::mbgextio_get_io_port_type_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_io_port_status_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IO_PORT_STATUS_IDX *p, uint8_t idx) ;

 /**
 * @brief Setup a receiver info structure
 *
 * The ::RECEIVER_INFO should be read at first to identify the connected
 * device and determine the basic features supported by the device.
 *
 * @note Some very old devices may not provide a ::RECEIVER_INFO.
 * This function tries to read the ::RECEIVER_INFO from the device,
 * and sets up a default structure if the device doesn't support this.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_receiver_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_setup_receiver_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, RECEIVER_INFO *p ) ;

 /**
 * @brief Read the software revision
 *
 * @deprecated This function is deprecated since the ::SW_REV structure
 * is also a member of the ::RECEIVER_INFO. This call may be required,
 * though, for very old devices which don't support the ::RECEIVER_INFO.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_setup_receiver_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_sw_rev( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, SW_REV *p ) ;

 /**
 * @brief Read the status of ignore lock
 *
 * @note Only supported if ::GPS_HAS_IGNORE_LOCK
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @see mbgextio_set_ignore_lock
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ignore_lock( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, IGNORE_LOCK *p ) ;

 /**
 * @brief Send the ignore lock configuration
 *
 * @note Only supported if ::GPS_HAS_IGNORE_LOCK
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ignore_lock
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ignore_lock( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const IGNORE_LOCK *p ) ;

 /**
 * @brief Read the status of buffered variables
 *
 * @note Only supported if ::GPS_MODEL_HAS_BVAR_STAT
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_bvar_stat( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, BVAR_STAT *p ) ;

 /**
 * @brief Read the current time as ::TTM strucure
 *
 * @note This function is only supported if the device has ::MBG_XFEATURE_REQ_TTM
 *
 * The returned time is not very accurate since the request can be sent at any time and
 * the response is sent immediately and not after a second change.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see mbgextio_dev_has_req_ttm
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_time( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, TTM *p ) ;

 /**
 * @brief Set the device's time by sending a ::TTM strucure
 *
 * @note The function is not supported by all devices. Time has to be
 * passed as local time according to the device's ::TZDL settings.
 * New time is only set with some tens of ms accuracy.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_time( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const TTM *p ) ;

 /**
 * @brief Set the device's position by sending an ::LLA array
 *
 * @note This function is only supported by GPS receivers
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    lla    Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_pos_lla( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const LLA lla ) ;

 /**
 * @brief Read the current receiver position as ::LLA array
 *
 * @note This function is only supported by GPS receivers
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    lla    Pointer to the data array to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_pos_lla( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, LLA lla ) ;

 /**
 * @brief Read the current receiver position as ::XYZ array
 *
 * @note This function is only supported by GPS receivers
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    xyz    Pointer to the data array to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_pos_xyz( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XYZ xyz ) ;

 /**
 * @brief Read the current receiver position as ::POS structure
 *
 * @note This function is only supported by GPS receivers
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p_pos  Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_pos( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, POS *p_pos ) ;

 /**
 * @brief Read the local time conversion parameters in ::TZDL format
 *
 * @note Some devices may not support ::TZDL settings
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_tzdl( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, TZDL *p ) ;

 /**
 * @brief Set the local time conversion parameters in ::TZDL format
 *
 * @note Some devices may not support ::TZDL settings
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_tzdl( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const TZDL *p ) ;

 /**
 * @brief Read serial port parameters in ::PORT_PARM format
 *
 * @deprecated This function is deprecated since the ::PORT_PARM structure
 * supports only 2 serial ports, and does not not support configuration
 * of a string type. The function ::mbgextio_get_serial_settings should
 * be used instead.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_serial_settings
 * @see ::mbgextio_save_serial_settings
 * @see ::mbgextio_set_port_parm
 * @see ::mbgextio_setup_receiver_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_port_parm( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, PORT_PARM *p ) ;

 /**
 * @brief Send serial port parameters in ::PORT_PARM format
 *
 * @deprecated This function is deprecated since the ::PORT_PARM structure
 * supports only 2 serial ports, and does not not support configuration
 * of a string type. The function ::mbgextio_save_serial_settings should
 * be used instead.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_serial_settings
 * @see ::mbgextio_save_serial_settings
 * @see ::mbgextio_get_port_parm
 * @see ::mbgextio_setup_receiver_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_port_parm( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const PORT_PARM *p ) ;

 /**
 * @brief Read the frequency synthesizer settings
 *
 * @note Some devices may not provide a frequency synthesizer
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_synth
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_synth( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, SYNTH *p ) ;

 /**
 * @brief Write the frequency synthesizer settings
 *
 * @note Some devices may not provide a frequency synthesizer
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_synth
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_synth( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const SYNTH *p ) ;

 /**
 * @brief Read the GPS antenna info structure
 *
 * @note This is only supported by GPS receivers.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ant_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ANT_INFO *p ) ;

 /**
 * @brief Read a user capture event in ::TTM format
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_clr_ucap_buff
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ucap( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, TTM *p ) ;

 /**
 * @brief Read the user capture network global info in ::MBG_UCAP_NET_GLB_INFO format
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_ucap_net
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ucap_net_glb_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_UCAP_NET_GLB_INFO *p ) ;

 /**
 * @brief Send the user capture network global configuration in ::MBG_UCAP_NET_GLB_SETTINGS format
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_ucap_net
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ucap_net_glb_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_UCAP_NET_GLB_SETTINGS *p ) ;

 /**
 * @brief Read the user capture network receiver info with the given index
 * in ::MBG_UCAP_NET_RECV_INFO_IDX format
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received dat
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_UCAP_NET_GLB_INFO::settings::num_recvs
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_ucap_net
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ucap_net_recv_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_UCAP_NET_RECV_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send the user capture network receiver configuration with the given index
 * in ::MBG_UCAP_NET_RECV_SETTINGS_IDX format
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the array element to be sent, 0..::MBG_UCAP_NET_GLB_INFO::settings::num_recvs
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_ucap_net
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ucap_net_recv_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_UCAP_NET_RECV_SETTINGS_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read the enable flags controlling when output signals are enabled
 *
 * @note Some devices may not support ::ENABLE_FLAGS
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_enable_flags
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_enable_flags( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ENABLE_FLAGS *p ) ;

 /**
 * @brief Send the enable flags controlling when output signals are enabled
 *
 * @note Some devices may not support ::ENABLE_FLAGS
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_enable_flags
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_enable_flags( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const ENABLE_FLAGS *p ) ;

 /**
 * @brief Read GPS status info
 *
 * @note This is only supported by GPS receivers
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_gps_stat_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, STAT_INFO *p ) ;

 /**
 * @brief Read the configured length of the antenna cable
 *
 * This is only supported by GPS/GNSS receivers, check ::GPS_MODEL_HAS_ANT_CABLE_LEN
 *
 * @note Some older devices may not reply to this request unless
 * the application has registered itself as terminal application
 * (GPS_AUTO_ON is not sufficient).
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_ant_cable_len
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ant_cable_len( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ANT_CABLE_LEN *p ) ;

 /**
 * @brief Send the GPS antenna cable length configuration
 *
 * This is only supported by GPS/GNSS receivers, check ::GPS_MODEL_HAS_ANT_CABLE_LEN

 * @note Different devices may accept different maximum values, so the
 * written value should be re-read using ::mbgextio_get_ant_cable_len
 * to check if the parameter has been accepted.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ant_cable_len
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ant_cable_len( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const ANT_CABLE_LEN *p ) ;

 /**
 * @brief Read configuration info and supported features of the device's IRIG output
 *
 * @note This is only supported if ::GPS_HAS_IRIG_TX is set in ::RECEIVER_INFO::features
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_irig_tx_settings
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_irig_tx_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, IRIG_INFO *p ) ;

 /**
 * @brief Send new configuration settings for the device's IRIG output
 *
 * @note This is only supported if ::GPS_HAS_IRIG_TX is set in ::RECEIVER_INFO::features
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_irig_tx_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_irig_tx_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const IRIG_SETTINGS *p ) ;

 /**
 * @brief Read configuration info and supported features for the device's IRIG input
 *
 * @note This is only supported if ::GPS_HAS_IRIG_RX is set in ::RECEIVER_INFO::features
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_irig_rx_settings
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_irig_rx_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, IRIG_INFO *p ) ;

 /**
 * @brief Send new configuration settings for the device's IRIG input
 *
 * @note This is only supported if ::GPS_HAS_IRIG_RX is set in ::RECEIVER_INFO::features
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_irig_rx_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_irig_rx_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const IRIG_SETTINGS *p ) ;

 /**
 * @brief Read raw IRIG data
 *
 * The ::MBG_RAW_IRIG_DATA structure can be read for debugging purposes,
 * to decode application defined bits in the control field (CF) segment
 * of the incoming time code, etc. Usually the data set is only updated
 * once per second, even if the code format provides many data frames
 * per second.
 *
 * @note Call ::mbgextio_dev_has_raw_irig_data to check if this is supported.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @see ::mbgextio_dev_has_raw_irig_data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_raw_irig_data( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_RAW_IRIG_DATA *p ) ;

 /**
 * @brief Read current ref offset to %UTC configuration
 *
 * @note This is only supported if ::GPS_HAS_REF_OFFS is set in ::RECEIVER_INFO::features,
 * usually with IRIG receivers
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_ref_offs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ref_offs( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_REF_OFFS *p ) ;

 /**
 * @brief Send new ref offset to %UTC settings
 *
 * @note This is only supported if ::GPS_HAS_REF_OFFS is set in ::RECEIVER_INFO::features,
 * usually with IRIG receivers
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ref_offs
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ref_offs( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_REF_OFFS *p ) ;

 /**
 * @brief Read current debug status
 *
 * @note This is only supported if ::GPS_HAS_DEBUG_STATUS is set in ::RECEIVER_INFO::features,
 * usually with IRIG receivers
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_debug_status( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_DEBUG_STATUS *p ) ;

 /**
 * @brief Read current optional settings and supported options
 *
 * @note This is only supported if ::GPS_HAS_OPT_SETTINGS is set in ::RECEIVER_INFO::features
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_opt_settings
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_opt_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_OPT_INFO *p ) ;

 /**
 * @brief Send new optional settings flags
 *
 * @note This is only supported if ::GPS_HAS_OPT_SETTINGS is set in ::RECEIVER_INFO::features
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_opt_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_opt_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_OPT_SETTINGS *p ) ;

 /**
 * @brief Read information on a specific supported string format
 *
 * Retrieve a single entry from an array of supported string types.
 * The number of supported string types is specified in ::RECEIVER_INFO::n_str_type.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::RECEIVER_INFO::n_str_type - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_str_type_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_str_type_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, STR_TYPE_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read an array of all supported string types
 *
 * The number of supported string types is specified in ::RECEIVER_INFO::n_str_type.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    stii   An array which can hold at least ::RECEIVER_INFO::n_str_type entries
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_str_type_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_str_type_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, STR_TYPE_INFO_IDX stii[] ) ;

 /**
 * @brief Read current settings and capabilities of a specific serial port
 *
 * The number of serial ports provided by the device is specified in ::RECEIVER_INFO::n_com_ports.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::RECEIVER_INFO::n_com_ports - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_port_info
 * @see ::mbgextio_set_port_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_port_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, PORT_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read an array of current settings and capabilities of all serial ports
 *
 * The number of serial ports provided by the device is specified in ::RECEIVER_INFO::n_com_ports.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    pii    An array which can hold at least ::RECEIVER_INFO::n_com_ports entries
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_port_info_idx
 * @see ::mbgextio_set_port_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_port_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, PORT_INFO_IDX pii[] ) ;

 /**
 * @brief Send configuration settings for a specific serial port
 *
 * The number of serial ports provided by the device is specified in ::RECEIVER_INFO::n_com_ports.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the serial port to be configured, 0..::RECEIVER_INFO::n_com_ports - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_port_info_idx
 * @see ::mbgextio_get_all_port_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_port_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const PORT_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read current settings and capabilities of a specific programmable pulse output
 *
 * The number of supported pulse outputs is specified in ::RECEIVER_INFO::n_prg_out.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::RECEIVER_INFO::n_prg_out - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_pout_info
 * @see ::mbgextio_set_pout_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_pout_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, POUT_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read an array of current settings and capabilities of all programmable pulse outputs
 *
 * The number of supported pulse outputs is specified in ::RECEIVER_INFO::n_prg_out.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    pii    An array which can hold at least ::RECEIVER_INFO::n_prg_out entries
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_pout_info_idx
 * @see ::mbgextio_set_pout_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_pout_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, POUT_INFO_IDX *pii ) ;

 /**
 * @brief Send configuration settings for a specific programmable pulse output
 *
 * The number of supported pulse outputs is specified in ::RECEIVER_INFO::n_prg_out.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the pulse output to be configured, 0..RECEIVER_INFO::n_prg_out - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_pout_info_idx
 * @see ::mbgextio_get_all_pout_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_pout_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const POUT_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Send configuration settings for a specific GPIO
 *
 * @note This is only supported if ::GPS_HAS_GPIO is set in ::RECEIVER_INFO::features
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the pulse output to be configured, 0..MBG_GPIO_CFG_LIMITS::num_io - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_gpio_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_gpio_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_GPIO_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Clear the user capture event buffer on-board the device
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ucap
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_clr_ucap_buff( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr ) ;

 /**
 * @brief Read time scale configuration parameters
 *
 * @note Some devices may not support a configurable time scale
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_time_scale_settings
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_time_scale_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_TIME_SCALE_INFO *p ) ;

 /**
 * @brief Send new time scale configuration settings
 *
 * @note Some devices may not support a configurable time scale
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_time_scale_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_time_scale_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_TIME_SCALE_SETTINGS *p ) ;

 /**
 * @brief Clear the on-board event log
 *
 * @note Some devices don't provide an on-board event log
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_num_evt_log_entries
 * @see ::mbgextio_get_first_evt_log_entry
 * @see ::mbgextio_get_next_evt_log_entry
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_clr_evt_log( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr ) ;

 /**
 * @brief Read the current number of entries in the on-board event log
 *
 * @note Some devices don't provide an on-board event log
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_clr_evt_log
 * @see ::mbgextio_get_first_evt_log_entry
 * @see ::mbgextio_get_next_evt_log_entry
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_num_evt_log_entries( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_NUM_EVT_LOG_ENTRIES *p ) ;

 /**
 * @brief Return the first entry from the on-board event log
 *
 * This resets an internal counter, so subsequent calls to
 * ::mbgextio_get_next_evt_log_entry will retrieve the following entries.
 *
 * @note Some devices don't provide an on-board event log
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_clr_evt_log
 * @see ::mbgextio_get_num_evt_log_entries
 * @see ::mbgextio_get_next_evt_log_entry
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_first_evt_log_entry( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_EVT_LOG_ENTRY *p ) ;

 /**
 * @brief Return the next entry from the on-board event log
 *
 * This increments an internal counter, so subsequent calls will
 * return subsequent entries. ::mbgextio_get_first_evt_log_entry
 * should be called first to reset the counter and retrieve the
 * oldest log entry.
 *
 * @note Some devices don't provide an on-board event log
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_clr_evt_log
 * @see ::mbgextio_get_num_evt_log_entries
 * @see ::mbgextio_get_first_evt_log_entry
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_next_evt_log_entry( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_EVT_LOG_ENTRY *p ) ;

 /**
 * @brief Read the current IMS state and supported IMS features
 *
 * @note This is only supported if ::mbgextio_dev_has_ims returns MBG_SUCCESS
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ims_sensor_state_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ims_state( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IMS_STATE *p ) ;

 /**
 * @brief Read sensor values from a specified sensor on the device
 *
 * Info on supported sensors can be retrieved using ::mbgextio_get_ims_state.
 * Valid range for the sensor index is [0..::MBG_IMS_STATE::num_sensors - 1].
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    The index of the array element to read
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ims_state
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ims_sensor_state_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IMS_SENSOR_STATE_IDX *p, uint16_t idx ) ;

 /**
 * @brief Set the XMR holdover interval
 *
 * @todo In which case is this supported?
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_holdover_interval_counter
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_holdover_interval( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const XMR_HOLDOVER_INTV *p ) ;

 /**
 * @brief Read the XMR holdover interval counter
 *
 * @todo In which case is this supported?
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_holdover_interval
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_holdover_interval_counter( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XMR_HOLDOVER_INTV *p ) ;

 /**
 * @brief Read the multi ref info from a device
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_xmulti_ref_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XMULTI_REF_INFO_IDX *p ) ;

 /**
 * @brief Read the local time conversion configuration in ::TZCODE format
 *
 * @note Some devices may not support ::TZCODE configuration
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_tzcode
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_tzcode( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, TZCODE *p ) ;

 /**
 * @brief Set the local time conversion configuration in ::TZCODE format
 *
 * @note Some devices may not support ::TZCODE configuration
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_tzcode
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_tzcode( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const TZCODE *p ) ;

 /**
 * @brief Send new configuration settings for the device's HAVEQUICK output
 *
 * @note This is only supported if ::GPS_HAS_HAVEQUICK is set in ::RECEIVER_INFO::features
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see  //##+++++++++++++++++++++
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_hq_tx_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const HAVEQUICK_SETTINGS *p ) ;

 /**
 * @brief Send new configuration settings for the device's HAVEQUICK input
 *
 * @note This is only supported if ::MULTI_REF_HAVEQUICK is > 0 in ::XMULTI_REF_INSTANCES::n_inst  //##+++++++++++++++++++++++ ???
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see  //##+++++++++++++++++++++
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_hq_rx_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const HAVEQUICK_SETTINGS *p ) ;

 /**
 * @brief Read the distance from transmitter ::TR_DISTANCE format
 *
 * @note Some devices may not support ::TR_DISTANCE configuration
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_tr_distance
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_tr_distance( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, TR_DISTANCE *p ) ;

 /**
 * @brief Set the transmitter distance (km) in ::TR_DISTANCE format
 *
 * @note Some devices may not support ::TR_DISTANCE configuration
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_tr_distance
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_tr_distance( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const TR_DISTANCE *p ) ;

 /**
 * @brief Read current GNSS mode settings and supported features
 *
 * @note Some devices may not support GNSS configuration
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to a ::MBG_GNSS_MODE_INFO structure to be filled up
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_gnss_mode_settings
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_gnss_mode_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_GNSS_MODE_INFO *p ) ;

 /**
 * @brief Write GNSS mode settings
 *
 * @note Some devices may not support GNSS configuration
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to a ::MBG_GNSS_MODE_SETTINGS structure to be sent
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_gnss_mode_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_gnss_mode_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_GNSS_MODE_SETTINGS *p ) ;

 /**
 * @brief ::TODO
 *
 * ### TODO this is obsolete
 * Retrieve a single entry from an array of supported string types.
 * The number of supported string types is specified in ::RECEIVER_INFO::n_str_type.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::TODO
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_gnss_sat_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GNSS_SAT_INFO *p ) ;

 /**
 * @brief ::TODO
 *
 * ### TODO
 * Retrieve a single entry from an array of supported string types.
 * The number of supported string types is specified in ::RECEIVER_INFO::n_str_type.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::RECEIVER_INFO::n_str_type - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::TODO
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_gnss_sat_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GNSS_SAT_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief ::TODO Read an array of all supported string types
 *
 * The number of supported string types is specified in ::RECEIVER_INFO::n_str_type.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    gsii   ::TODO
 * @param[in]     p_mi   ::TODO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::TODO
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_gnss_sat_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GNSS_SAT_INFO_IDX gsii[], const MBG_GNSS_MODE_INFO *p_mi ) ;

 /**
 * @brief ::TODO
 *
 * ### TODO
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::RECEIVER_INFO::n_str_type - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see @ref group_gnss_sv_status ::TODO
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_gnss_sv_status_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GNSS_SV_STATUS_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read ::XMULTI_REF_INSTANCES
 *
 * Only if ::GPS_HAS_XMULTI_REF is set in ::RECEIVER_INFO::features AND
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_xmr_ext_src_info_idx
 * @see ::mbgextio_get_xmr_info_idx
 * @see ::mbgextio_get_xmr_status_idx
 * @see ::mbgextio_set_xmr_settings_idx
 * @see ::mbgextio_get_xmr_ext_source_stats_idx
 * @see ::mbgextio_get_xmr_ext_source_metrics_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_xmr_instances( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XMULTI_REF_INSTANCES *p ) ;

 /**
 * @brief Read ::XMR_EXT_SRC_INFO_IDX
 *
 * Only if ::GPS_HAS_XMULTI_REF is set in ::RECEIVER_INFO::features AND
 *         ::XMRIF_MSK_EXT_SRC_INFO_SUPP is set in ::XMULTI_REF_INSTANCES::flags.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::XMULTI_REF_INSTANCES::n_xmr_settings-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_xmr_instances
 * @see ::mbgextio_get_xmr_holdover_status
 * @see ::mbgextio_get_xmr_info_idx
 * @see ::mbgextio_get_xmr_status_idx
 * @see ::mbgextio_set_xmr_settings_idx
 * @see ::mbgextio_get_xmr_ext_source_stats_idx
 * @see ::mbgextio_get_xmr_ext_source_metrics_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_xmr_ext_src_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XMR_EXT_SRC_INFO_IDX *p, uint16_t idx) ;

 /**
 * @brief Read ::XMR_HOLDOVER_STATUS
 *
 * Only if ::GPS_HAS_XMULTI_REF is set in ::RECEIVER_INFO::features AND
 *         ::XMRIF_MSK_HOLDOVER_STATUS_SUPP is set in ::XMULTI_REF_INSTANCES::flags.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_xmr_instances
 * @see ::mbgextio_get_xmr_ext_src_info_idx
 * @see ::mbgextio_get_xmr_info_idx
 * @see ::mbgextio_get_xmr_status_idx
 * @see ::mbgextio_set_xmr_settings_idx
 * @see ::mbgextio_get_xmr_ext_source_stats_idx
 * @see ::mbgextio_get_xmr_ext_source_metrics_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_xmr_holdover_status( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XMR_HOLDOVER_STATUS *p ) ;

 /**
 * @brief Read ::XMULTI_REF_INFO_IDX for a specific XMR source
 *
 * Only if ::GPS_HAS_XMULTI_REF is set in ::RECEIVER_INFO::features.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..0..::XMULTI_REF_INSTANCES::n_xmr_settings-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_xmr_instances
 * @see ::mbgextio_get_xmr_ext_src_info_idx
 * @see ::mbgextio_get_xmr_holdover_status
 * @see ::mbgextio_get_xmr_status_idx
 * @see ::mbgextio_set_xmr_settings_idx
 * @see ::mbgextio_get_xmr_ext_source_stats_idx
 * @see ::mbgextio_get_xmr_ext_source_metrics_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_xmr_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XMULTI_REF_INFO_IDX *p, uint16_t idx) ;

 /**
 * @brief Read ::XMULTI_REF_STATUS_IDX for a specific XMR source
 *
 * Only if ::GPS_HAS_XMULTI_REF is set in ::RECEIVER_INFO::features.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..0..::XMULTI_REF_INSTANCES::n_xmr_settings-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_xmr_instances
 * @see ::mbgextio_get_xmr_ext_src_info_idx
 * @see ::mbgextio_get_xmr_holdover_status
 * @see ::mbgextio_get_xmr_info_idx
 * @see ::mbgextio_set_xmr_settings_idx
 * @see ::mbgextio_get_xmr_ext_source_stats_idx
 * @see ::mbgextio_get_xmr_ext_source_metrics_idx
 * @see ::mbgextio_get_xmr_ext_source_metrics_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_xmr_status_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XMULTI_REF_STATUS_IDX *p, uint16_t idx) ;

 /**
 * @brief Read ::XMR_STATS_IDX for a specific XMR source
 *
 * Only if ::mbgextio_dev_xmr_has_ext_source_stats returns ::MBG_SUCCESS for the specific index
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MULTI_REF_TYPES-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_xmr_instances
 * @see ::mbgextio_get_xmr_ext_src_info_idx
 * @see ::mbgextio_get_xmr_holdover_status
 * @see ::mbgextio_get_xmr_info_idx
 * @see ::mbgextio_set_xmr_settings_idx
 * @see ::mbgextio_get_xmr_info_idx
 * @see ::mbgextio_get_xmr_status_idx
 * @see ::mbgextio_get_xmr_ext_source_metrics_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_xmr_ext_source_stats_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XMR_STATS_IDX *p, uint16_t idx) ;

 /**
 * @brief Read ::XMR_METRICS_IDX for a specific XMR source
 *
 * Only if ::mbgextio_dev_xmr_has_ext_source_stats returns ::MBG_SUCCESS for the specific index
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MULTI_REF_TYPES-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_xmr_instances
 * @see ::mbgextio_get_xmr_ext_src_info_idx
 * @see ::mbgextio_get_xmr_holdover_status
 * @see ::mbgextio_get_xmr_info_idx
 * @see ::mbgextio_set_xmr_settings_idx
 * @see ::mbgextio_get_xmr_info_idx
 * @see ::mbgextio_get_xmr_status_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_xmr_ext_source_metrics_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XMR_METRICS_IDX *p, uint16_t idx) ;

 /**
 * @brief Set ::XMULTI_REF_SETTINGS for a specific XMR source
 *
 * Only if ::GPS_HAS_XMULTI_REF is set in ::RECEIVER_INFO::features.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the array element to be retrieved, 0..0..::XMULTI_REF_INSTANCES::n_xmr_settings-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_xmr_instances
 * @see ::mbgextio_get_xmr_ext_src_info_idx
 * @see ::mbgextio_get_xmr_holdover_status
 * @see ::mbgextio_get_xmr_info_idx
 * @see ::mbgextio_get_xmr_status_idx
 * @see ::mbgextio_get_xmr_ext_source_stats_idx
 * @see ::mbgextio_get_xmr_ext_source_metrics_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_xmr_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const XMULTI_REF_SETTINGS *p, uint16_t idx) ;

 /**
 * @brief Read the lan interface configuration ::LAN_IF_INFO format
 *
 * @note ptp or xmr with ntp feature must set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see //##+++++++++++++
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_lan_if_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, LAN_IF_INFO *p ) ;

 /**
 * @brief Read the lan ipv4 configuration state ::IP4_SETTINGS format
 *
 * @note ptp or xmr with ntp feature must set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see //##+++++++++++++
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ip4_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, IP4_SETTINGS *p ) ;

 /**
 * @brief Save the current ipv4 settings ::IP4_SETTINGS format
 *
 * @note ptp or xmr with ntp feature must set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see //##+++++++++++++
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ip4_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const IP4_SETTINGS *p ) ;

 /**
 * @brief Read the current lan ipv4 state ::IP4_SETTINGS format
 *
 * @note ptp or xmr with ntp feature must set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see //##+++++++++++++
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ip4_state( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, IP4_SETTINGS *p ) ;

 /**
 * @brief Read the current state of PTP device ::PTP_STATE format
 *
 * @note ptp feature must set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see //##+++++++++++++
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_state( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, PTP_STATE *p ) ;

 /**
 * @brief Read the ptp configuration ::PTP_CFG_INFO format
 *
 * @note ptp feature must set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see //##+++++++++++++
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_cfg_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, PTP_CFG_INFO *p ) ;

 /**
 * @brief Read the ptp configuration ::PTP_UC_MASTER_CFG_LIMITS format
 *
 * @note ptp feature must set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see //##+++++++++++++
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_uc_master_cfg_limits( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, PTP_UC_MASTER_CFG_LIMITS *p ) ;

 /**
 * @brief Read the ptp configuration ::ALL_PTP_UC_MASTER_INFO_IDX format
 *
 * @note ptp feature must set and read number of ptp unicast masters before.
 *
 * @param[in,out] pmctl                     Pointer to a valid message control structure
 * @param[in]     p_addr                    Pointer to an XBP address specifier, or NULL
 * @param[out]    ptp_uc_master_info_idx    Pointer to an array of ::PTP_UC_MASTER_INFO_IDX structures to be filled up
 * @param[in]     ptp_uc_master_cfg_limits  Pointer to a ::PTP_UC_MASTER_CFG_LIMITS structure read before
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see //##+++++++++++++ TODO
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_ptp_uc_master_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, PTP_UC_MASTER_INFO_IDX *ptp_uc_master_info_idx, const PTP_UC_MASTER_CFG_LIMITS *ptp_uc_master_cfg_limits ) ;

 /**
 * @brief Send configuration settings for PTP
 *
 * @note This is only supported by PTP devices
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_cfg_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const PTP_CFG_SETTINGS *p ) ;

 /**
 * @brief Send PTP unicast master configuration settings for a PTP unicast slave mode device.
 *
 * The number of supported PTP Masters is specified in ::PTP_UC_MASTER_CFG_LIMITS::n_supp_master.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the PTP unicast grandmaster to be configured, 0 ... PTP_UC_MASTER_CFG_LIMITS::n_supp_master - 1 .
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_ptp_cfg_settings
 * @see ::mbgextio_get_all_ptp_uc_master_info
 * @see ::mbgextio_get_ptp_uc_master_cfg_limits
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_state
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_uc_master_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const PTP_UC_MASTER_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read the PTPv1 default dataset in ::MBG_PTP_V1_DEFAULT_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_set_ptp_v1_default_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_v1_default_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_PTP_V1_DEFAULT_DATASET *p ) ;

 /**
 * @brief Send PTPv1 default dataset to a device in ::MBG_PTP_V1_DEFAULT_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v1_default_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_v1_default_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_PTP_V1_DEFAULT_DATASET *p ) ;

 /**
 * @brief Read the PTPv1 current dataset in ::MBG_PTP_V1_CURRENT_DATASET format
 *
 * @note only supported if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_set_ptp_v1_current_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_v1_current_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_PTP_V1_CURRENT_DATASET *p ) ;

 /**
 * @brief Send PTPv1 current dataset to a device in ::MBG_PTP_V1_CURRENT_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v1_current_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_v1_current_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_PTP_V1_CURRENT_DATASET *p ) ;

 /**
 * @brief Read the PTPv1 parent dataset in ::MBG_PTP_V1_PARENT_DATASET format
 *
 * @note only supported if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_set_ptp_v1_parent_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_v1_parent_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_PTP_V1_PARENT_DATASET *p ) ;

 /**
 * @brief Send PTPv1 parent dataset to a device in ::MBG_PTP_V1_PARENT_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v1_parent_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_v1_parent_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_PTP_V1_PARENT_DATASET *p ) ;

 /**
 * @brief Read the PTPv1 time properties dataset in ::MBG_PTP_V1_TIME_PROPERTIES_DATASET format
 *
 * @note only supported if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_set_ptp_v1_time_properties_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_v1_time_properties_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_PTP_V1_TIME_PROPERTIES_DATASET *p ) ;

 /**
 * @brief Send PTPv1 time properties dataset to a device in ::MBG_PTP_V1_TIME_PROPERTIES_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v1_time_properties_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_v1_time_properties_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_PTP_V1_TIME_PROPERTIES_DATASET *p ) ;

 /**
 * @brief Read the PTPv1 port dataset with the appropriate index in ::MBG_PTP_V1_PORT_DATASET_IDX format
 *
 * @note only supported if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to return the received data
 * @param[in]     idx       Index of the port dataset be received, 0..::MBG_PTP_V1_DEFAULT_DATASET::number_ports - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_set_ptp_v1_port_dataset_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_v1_port_dataset_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_PTP_V1_PORT_DATASET_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send PTPv1 port dataset with the appropriate index to a device in ::MBG_PTP_V1_PORT_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to be sent to the device
 * @param[in]     idx       Index of the port dataset to be written, 0..::MBG_PTP_V1_DEFAULT_DATASET::number_ports - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v1_port_dataset_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_v1_port_dataset_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_PTP_V1_PORT_DATASET *p, uint16_t idx ) ;

 /**
 * @brief Read the PTPv2 default dataset in ::MBG_PTP_V2_DEFAULT_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_set_ptp_v2_default_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_v2_default_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_PTP_V2_DEFAULT_DATASET *p ) ;

 /**
 * @brief Send PTPv2 default dataset to a device in ::MBG_PTP_V2_DEFAULT_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v2_default_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_v2_default_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_PTP_V2_DEFAULT_DATASET *p ) ;

 /**
 * @brief Read the PTPv2 current dataset in ::MBG_PTP_V2_CURRENT_DATASET format
 *
 * @note only supported if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_set_ptp_v2_current_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_v2_current_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_PTP_V2_CURRENT_DATASET *p ) ;

 /**
 * @brief Send PTPv2 current dataset to a device in ::MBG_PTP_V2_CURRENT_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v2_current_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_v2_current_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_PTP_V2_CURRENT_DATASET *p ) ;

 /**
 * @brief Read the PTPv2 parent dataset in ::MBG_PTP_V2_PARENT_DATASET format
 *
 * @note only supported if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_set_ptp_v2_parent_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_v2_parent_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_PTP_V2_PARENT_DATASET *p ) ;

 /**
 * @brief Send PTPv2 parent dataset to a device in ::MBG_PTP_V2_PARENT_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v2_parent_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_v2_parent_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_PTP_V2_PARENT_DATASET *p ) ;

 /**
 * @brief Read the PTPv2 time properties dataset in ::MBG_PTP_V2_TIME_PROPERTIES_DATASET format
 *
 * @note only supported if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_set_ptp_v2_time_properties_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_v2_time_properties_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_PTP_V2_TIME_PROPERTIES_DATASET *p ) ;

 /**
 * @brief Send PTPv2 time properties dataset to a device in ::MBG_PTP_V2_TIME_PROPERTIES_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v2_time_properties_dataset
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_v2_time_properties_dataset( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_PTP_V2_TIME_PROPERTIES_DATASET *p ) ;

 /**
 * @brief Read the PTPv2 port dataset with the appropriate index in ::MBG_PTP_V2_PORT_DATASET_IDX format
 *
 * @note only supported if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to return the received data
 * @param[in]     idx       Index of the port dataset be received, 0..::MBG_PTP_V2_DEFAULT_DATASET::number_ports - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_set_ptp_v2_port_dataset_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ptp_v2_port_dataset_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_PTP_V2_PORT_DATASET_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send PTPv2 port dataset with the appropriate index to a device in ::MBG_PTP_V2_PORT_DATASET format
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[out]    p         Pointer to the data structure to be sent to the device
 * @param[in]     idx       Index of the port dataset be written, 0..::MBG_PTP_V2_DEFAULT_DATASET::number_ports - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v2_port_dataset_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ptp_v2_port_dataset_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_PTP_V2_PORT_DATASET *p, uint16_t idx ) ;

 /**
 * @brief Read the monitoring limits in ::MBG_MONITORING_LIMITS format
 *
 * @note extended feature ::MBG_XFEATURE_MONITORING must be set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_monitoring_limits( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_MONITORING_LIMITS *p ) ;

 /**
 * @brief Read the SNMP global info in ::MBG_SNMP_GLB_INFO format
 *
 * @note ::MBG_MONITORING_TYPE_MSK_SNMP must be set in MBG_MONITORING_LIMITS::supp_types
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_set_snmp_glb_settings
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_snmp_glb_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_SNMP_GLB_INFO *p ) ;

 /**
 * @brief Send the SNMP global settings in ::MBG_SNMP_GLB_SETTINGS format
 *
 * @note ::MBG_MONITORING_TYPE_MSK_SNMP must be set in MBG_MONITORING_LIMITS::supp_types
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_snmp_glb_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_snmp_glb_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_SNMP_GLB_SETTINGS *p ) ;

 /**
 * @brief Read SNMP v1 or v2 info in ::MBG_SNMP_V12_INFO_IDX format
 *
 * @note ::MBG_MONITORING_TYPE_MSK_SNMP must be set in MBG_MONITORING_LIMITS::supp_types
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the SNMP info to be received, 0 ... MBG_SNMP_GLB_SETTINGS::num_v12_settings - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_snmp_glb_info
 * @see ::mbgextio_set_snmp_v12_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_snmp_v12_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_SNMP_V12_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Write SNMP v1 or v2 settings in ::MBG_SNMP_V12_SETTINGS format
 *
 * @note ::MBG_MONITORING_TYPE_MSK_SNMP must be set in MBG_MONITORING_LIMITS::supp_types
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the SNMP settings to be written, 0 ... MBG_SNMP_GLB_SETTINGS::num_v12_settings - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_snmp_glb_info
 * @see ::mbgextio_get_snmp_v12_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_snmp_v12_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_SNMP_V12_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read SNMP v1 or v2 trap info in ::MBG_SNMP_V12_TRAP_INFO_IDX format
 *
 * @note ::MBG_MONITORING_TYPE_MSK_SNMP must be set in MBG_MONITORING_LIMITS::supp_types
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the SNMP trap info to be received, 0 ... MBG_SNMP_GLB_SETTINGS::num_v12_trap_receivers - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_snmp_glb_info
 * @see ::mbgextio_set_snmp_v12_trap_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_snmp_v12_trap_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_SNMP_V12_TRAP_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Write SNMP v1 or v2 trap settings in ::MBG_SNMP_V12_TRAP_SETTINGS format
 *
 * @note ::MBG_MONITORING_TYPE_MSK_SNMP must be set in MBG_MONITORING_LIMITS::supp_types
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the SNMP settings to be written, 0 ... MBG_SNMP_GLB_SETTINGS::num_v12_trap_receivers - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_snmp_glb_info
 * @see ::mbgextio_get_snmp_v12_trap_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_snmp_v12_trap_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_SNMP_V12_TRAP_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read SNMP v3 info in ::MBG_SNMP_V3_INFO_IDX format
 *
 * @note ::MBG_MONITORING_TYPE_MSK_SNMP must be set in MBG_MONITORING_LIMITS::supp_types
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the SNMP info to be received, 0 ... MBG_SNMP_GLB_SETTINGS::num_v3_settings - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_snmp_glb_info
 * @see ::mbgextio_set_snmp_v3_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_snmp_v3_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_SNMP_V3_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Write SNMP v3 settings in ::MBG_SNMP_V3_SETTINGS format
 *
 * @note ::MBG_MONITORING_TYPE_MSK_SNMP must be set in MBG_MONITORING_LIMITS::supp_types
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the SNMP settings to be written, 0 ... MBG_SNMP_GLB_SETTINGS::num_v3_settings - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_snmp_glb_info
 * @see ::mbgextio_get_snmp_v3_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_snmp_v3_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_SNMP_V3_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read SNMP v3 trap info in ::MBG_SNMP_V3_TRAP_INFO_IDX format
 *
 * @note ::MBG_MONITORING_TYPE_MSK_SNMP must be set in MBG_MONITORING_LIMITS::supp_types
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the SNMP trap info to be received, 0 ... MBG_SNMP_GLB_SETTINGS::num_v3_trap_receivers - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_snmp_glb_info
 * @see ::mbgextio_set_snmp_v3_trap_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_snmp_v3_trap_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_SNMP_V3_TRAP_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Write SNMP v3 trap settings in ::MBG_SNMP_V3_TRAP_SETTINGS format
 *
 * @note ::MBG_MONITORING_TYPE_MSK_SNMP must be set in MBG_MONITORING_LIMITS::supp_types
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the SNMP trap settings to be written, 0 ... MBG_SNMP_GLB_SETTINGS::num_v3_trap_receivers - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_snmp_glb_info
 * @see ::mbgextio_get_snmp_v3_trap_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_snmp_v3_trap_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_SNMP_V3_TRAP_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read monitoring event info in ::MBG_EVENT_INFO_IDX format
 *
 * @note extended feature ::MBG_XFEATURE_MONITORING must be set
 * idx shall be the type of the appropriate event, it should be checked
 * if this event is supported in ::MBG_MONITORING_LIMITS::supp_events
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the event info to be received, type of the appropriate event
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_monitoring_limits
 * @see ::mbgextio_set_event_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_event_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_EVENT_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Write monitoring event settings in ::MBG_EVENT_SETTINGS format
 *
 * @note extended feature ::MBG_XFEATURE_MONITORING must be set
 * idx shall be the type of the appropriate event, it should be checked
 * if this event is supported in ::MBG_MONITORING_LIMITS::supp_events
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the event settings to be written, type of the appropriate event
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_monitoring_limits
 * @see ::mbgextio_get_event_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_event_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_EVENT_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read the monitoring status in ::MBG_MONITORING_STATUS format
 *
 * @note extended feature ::MBG_XFEATURE_MONITORING must be set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_monitoring_status( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_MONITORING_STATUS *p ) ;

 /**
 * @brief Read monitoring event status in ::MBG_EVENT_STATUS_IDX format
 *
 * @note extended feature ::MBG_XFEATURE_MONITORING must be set
 * idx shall be the type of the appropriate event, it should be checked
 * if this event is supported in ::MBG_MONITORING_LIMITS::supp_events
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the event info to be received, type of the appropriate event
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_monitoring_limits
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_event_status_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_EVENT_STATUS_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read the ntp global information ::NTP_GLB_INFO format
 *
 * @note ntp feature must set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_clnt_mode_info
 * @see ::mbgextio_get_ntp_peer_settings_idx
 * @see ::mbgextio_set_ntp_peer_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_glb_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_GLB_INFO *p ) ;

 /**
 * @brief Send the NTP global configuration
 *
 * @note This is only supported by NTP devices
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ant_cable_len
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ntp_glb_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const NTP_GLB_SETTINGS *p ) ;

 /**
 * @brief Read the NTP symmetric key limits in ::NTP_SYMM_KEY_LIMITS format
 *
 * @note ::NTP_MSK_SYMM_KEYS must be set in ::NTP_GLB_INFO::supp_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_symm_key_limits( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_SYMM_KEY_LIMITS *p ) ;

 /**
 * @brief Read the NTP symmetric key info with the given index in ::NTP_SYMM_KEY_INFO_IDX format
 *
 * @note ::NTP_MSK_SYMM_KEYS must be set in ::NTP_GLB_INFO::supp_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the NTP symmetric key info to be queried, 0 ... ::NTP_GLB_SETTINGS::num_symm_keys - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_get_ntp_symm_key_limits
 * @see ::mbgextio_set_ntp_symm_key_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_symm_key_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_SYMM_KEY_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send NTP symmetric key settings with the given index in ::NTP_SYMM_KEY_SETTINGS format
 *
 * @note ::NTP_MSK_SYMM_KEYS must be set in ::NTP_GLB_INFO::supp_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the NTP symmetric key to be configured, 0 ... ::NTP_GLB_SETTINGS::num_symm_keys - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_get_ntp_symm_key_limits
 * @see ::mbgextio_get_ntp_symm_key_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ntp_symm_key_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const NTP_SYMM_KEY_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read the NTP trusted key info with the given index in ::NTP_TRUSTED_KEY_INFO_IDX format
 *
 * @note ::NTP_MSK_TRUSTED_KEYS must be set in ::NTP_GLB_INFO::supp_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the NTP trusted key info to be queried, 0 ... ::NTP_GLB_SETTINGS::num_trusted_keys - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_set_ntp_trusted_key_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_trusted_key_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_TRUSTED_KEY_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send NTP trusted key settings with the given index in ::NTP_TRUSTED_KEY_SETTINGS format
 *
 * @note ::NTP_MSK_TRUSTED_KEYS must be set in ::NTP_GLB_INFO::supp_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the NTP trusted key to be configured, 0 ... ::NTP_GLB_SETTINGS::num_trusted_keys - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_get_ntp_trusted_key_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ntp_trusted_key_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const NTP_TRUSTED_KEY_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read the NTP misc limits in ::NTP_MISC_LIMITS format
 *
 * @note ::NTP_MSK_MISCELLANEOUS must be set in ::NTP_GLB_INFO::supp_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_misc_limits( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_MISC_LIMITS *p ) ;

 /**
 * @brief Read the NTP orphan mode information in ::NTP_MISC_ORPHAN_MODE_INFO format
 *
 * @note ::NTP_MISC_MSK_ORPHAN_MODE must be set in ::NTP_MISC_LIMITS::supp_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_get_ntp_misc_limits
 * @see ::mbgextio_set_ntp_misc_orphan_mode_settings
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_misc_orphan_mode_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_MISC_ORPHAN_MODE_INFO *p ) ;

 /**
 * @brief Send the NTP orphan mode configuration in ::NTP_MISC_ORPHAN_MODE_SETTINGS format
 *
 * @note ::NTP_MISC_MSK_ORPHAN_MODE must be set in ::NTP_MISC_LIMITS::supp_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_get_ntp_misc_limits
 * @see ::mbgextio_get_ntp_misc_orphan_mode_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ntp_misc_orphan_mode_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const NTP_MISC_ORPHAN_MODE_SETTINGS *p ) ;

 /**
 * @brief Read the ntp global information ::NTP_CLNT_MODE_INFO format
 *
 * @note ntp feature must set
 * @note ntp client mode must set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_set_ntp_clnt_mode_cfg
 * @see ::mbgextio_get_ntp_peer_settings_idx
 * @see ::mbgextio_set_ntp_peer_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_clnt_mode_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_CLNT_MODE_INFO *p ) ;

 /**
 * @brief Send the NTP client mode configuration
 *
 * @note This is only supported by NTP devices
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_get_ntp_clnt_mode_info
 * @see ::mbgextio_get_ntp_peer_settings_idx
 * @see ::mbgextio_set_ntp_peer_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ntp_clnt_mode_cfg( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const NTP_CLNT_MODE_SETTINGS *p ) ;

 /**
 * @brief Read the ntp peer settings of current idx ::NTP_PEER_SETTINGS format
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the NTP peer settings to be configured, 0 ... NTP_CLNT_MODE_INFO::n_supp_peers - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_set_ntp_peer_settings_idx
 * @see ::mbgextio_get_ntp_clnt_mode_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_peer_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_PEER_SETTINGS_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send configuration settings for a specific NTP peer
 *
 * The number of supported NTP peers is specified in ::NTP_CLNT_MODE_INFO::n_supp_peers -1.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the NTP peer to be configured, 0 ... NTP_CLNT_MODE_INFO::n_supp_peers - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_get_ntp_peer_settings_idx
 * @see ::mbgextio_get_ntp_clnt_mode_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ntp_peer_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const NTP_PEER_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read the ntp server mode information in ::NTP_SRV_MODE_INFO format
 *
 * @note NTP feature ::GPS_FEAT_NTP must be set
 * @note NTP roles ::NTP_ROLE_SERVER or ::NTP_ROLE_CLIENT_SERVER must be set in ::NTP_GLB_INFO::supp_ntp_roles
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_set_ntp_srv_mode_cfg
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_srv_mode_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_SRV_MODE_INFO *p ) ;

 /**
 * @brief Send the NTP server mode configuration
 *
 * @note NTP feature ::GPS_FEAT_NTP must be set
 * @note NTP roles ::NTP_ROLE_SERVER or ::NTP_ROLE_CLIENT_SERVER must be set in ::NTP_GLB_INFO::supp_ntp_roles
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_get_ntp_srv_mode_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ntp_srv_mode_cfg( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const NTP_SRV_MODE_SETTINGS *p ) ;

 /**
 * @brief Read the NTP refclock config info with the given index in ::NTP_REFCLK_CFG_INFO_IDX format
 *
 * @note NTP feature ::GPS_FEAT_NTP must be set
 * @note NTP roles ::NTP_ROLE_SERVER or ::NTP_ROLE_CLIENT_SERVER must be set in ::NTP_GLB_INFO::supp_ntp_roles
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the NTP refclock config to be queried, 0 ... ::NTP_SRV_MODE_SETTINGS::num_refclks - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_get_ntp_srv_mode_info
 * @see ::mbgextio_set_ntp_refclk_cfg_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_refclk_cfg_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_REFCLK_CFG_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send NTP refclk config settings with the given index in ::NTP_REFCLK_CFG_SETTINGS format
 *
 * @note NTP feature ::GPS_FEAT_NTP must be set
 * @note NTP roles ::NTP_ROLE_SERVER or ::NTP_ROLE_CLIENT_SERVER must be set in ::NTP_GLB_INFO::supp_ntp_roles
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the NTP refclock config to be set, 0 ... ::NTP_SRV_MODE_SETTINGS::num_refclks - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_glb_info
 * @see ::mbgextio_get_ntp_srv_mode_info
 * @see ::mbgextio_get_ntp_refclk_cfg_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ntp_refclk_cfg_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const NTP_REFCLK_CFG_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read the current system state of ntp device ::NTP_SYS_STATE format
 *
 * @note NTP feature must set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_ntp_clnt_mode_cfg
 * @see ::mbgextio_get_ntp_glb_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_sys_state( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_SYS_STATE *p ) ;

 /**
 * @brief Read the NTP peer state of current idx ::NTP_PEER_STATE format
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the NTP peer state to be configured, 0 ... NTP_CLNT_MODE_INFO::n_supp_peers - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ntp_sys_state
 * @see ::mbgextio_get_ntp_peer_settings_idx
 * @see ::mbgextio_get_ntp_clnt_mode_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ntp_peer_state_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, NTP_PEER_STATE_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read the network global config information ::MBG_NET_GLB_CFG_INFO format
 *
 * @note GPS_HAS_NET_CFG must set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_net_glb_cfg_settings
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_glb_cfg_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_NET_GLB_CFG_INFO *p ) ;

 /**
 * @brief Set the device's global network configuration settings
 *
 * @note The function is not supported by all devices.  //##++++++++++++
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_net_glb_cfg_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_net_glb_cfg_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_NET_GLB_CFG_SETTINGS *p ) ;

 /**
 * @brief Read a network DNS server entry in ::MBG_IP_ADDR_IDX format
 *
 * The number of DNS server provided by the device is specified in ::MBG_NET_GLB_CFG_INFO::n_supp_dns_srvr
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_NET_GLB_CFG_INFO::n_supp_dns_srvr - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_net_dns_srvr_idx
 * @see ::mbgextio_get_net_stat_dns_srvr_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_dns_srvr_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IP_ADDR_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send the network DNS server address in ::MBG_IP_ADDR format
 *
 * The number of DNS search domains supported by the device
 * is specified in ::MBG_NET_GLB_CFG_INFO::n_supp_dns_srvr
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the DNS server port to be configured, 0..::MBG_NET_GLB_CFG_INFO::n_supp_dns_srvr - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_net_dns_srvr_idx
 * @see ::mbgextio_get_net_stat_dns_srvr_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_net_dns_srvr_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_IP_ADDR *p, uint16_t idx ) ;

 /**
 * @brief Read the network DNS search domain in ::MBG_NET_NAME_IDX format
 *
 * The number of DNS search domains supported by the device
 * is specified in ::MBG_NET_GLB_CFG_INFO::n_supp_dns_srch_dom
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_NET_GLB_CFG_INFO::n_supp_dns_srch_dom - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_net_dns_srch_dom_idx
 * @see ::mbgextio_get_net_stat_dns_srch_dom_stat_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_dns_srch_dom_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_NET_NAME_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send the network DNS search domain in ::MBG_NET_NAME format
 *
 * The number of DNS search domains supported by the device
 * is specified in ::MBG_NET_GLB_CFG_INFO::n_supp_dns_srch_dom
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the DNS search domain entry to be configured, 0..::MBG_NET_GLB_CFG_INFO::n_supp_dns_srch_dom - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_net_dns_srch_dom_idx
 * @see ::mbgextio_get_net_stat_dns_srch_dom_stat_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_net_dns_srch_dom_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_NET_NAME *p, uint16_t idx ) ;

 /**
 * @brief Read the current network DNS server in ::MBG_IP_ADDR_IDX format
 *
 * The number of DNS servers supported by the device
 * is specified in ::MBG_NET_GLB_CFG_INFO::n_supp_dns_srvr
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_NET_GLB_CFG_INFO::n_supp_dns_srvr - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_net_dns_srvr_idx
 * @see ::mbgextio_set_net_dns_srvr_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_stat_dns_srvr_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IP_ADDR_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read the current network DNS search domain in ::MBG_NET_NAME_IDX format
 *
 * The number of DNS search domains supported by the device
 * is specified in ::MBG_NET_GLB_CFG_INFO::n_supp_dns_srch_dom
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_NET_GLB_CFG_INFO::n_supp_dns_srch_dom - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_net_dns_srch_dom_idx
 * @see ::mbgextio_get_net_dns_srch_dom_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_stat_dns_srch_dom_stat_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_NET_NAME_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read ::MBG_NET_INTF_LINK_INFO_IDX from the config with the given index
 *
 * @note GPS_HAS_NET_CFG must be set and MBG_NET_GLB_SUPP_STAGE_2_MASK must be set in ::MBG_NET_GLB_CFG_INFO::feat_flags
 *
 * The number of ::MBG_NET_INTF_LINK_INFO_IDX provided by the device is specified in
 * ::MBG_NET_GLB_CFG_INFO::glb_settings::num_intf_link.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_NET_GLB_CFG_INFO::glb_settings::num_intf_link - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_net_cfg_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_intf_link_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_NET_INTF_LINK_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send the network link configuration in ::MBG_NET_INTF_LINK_SETTINGS format
 *
 * @note GPS_HAS_NET_CFG must be set and MBG_NET_GLB_SUPP_STAGE_2_MASK must be set in ::MBG_NET_GLB_CFG_INFO::feat_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the link to be configured, 0..::MBG_NET_GLB_CFG_INFO::num_intf_link - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_net_intf_link_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_net_intf_link_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_NET_INTF_LINK_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read ::MBG_NET_INTF_ADDR_INFO_IDX from the config with the given index
 *
 * @note GPS_HAS_NET_CFG must be set and MBG_NET_GLB_SUPP_STAGE_2_MASK must be set in ::MBG_NET_GLB_CFG_INFO::feat_flags
 *
 * The number of ::MBG_NET_INTF_ADDR_INFO_IDX provided by the device is specified in
 * ::MBG_NET_GLB_CFG_INFO::glb_settings::num_intf_addr.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_NET_GLB_CFG_INFO::glb_settings::n_supp_intf_addr - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_net_cfg_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_intf_addr_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_NET_INTF_ADDR_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send the network addr configuration in ::MBG_NET_INTF_ADDR_SETTINGS format
 *
 * @note GPS_HAS_NET_CFG must be set and MBG_NET_GLB_SUPP_STAGE_2_MASK must be set in ::MBG_NET_GLB_CFG_INFO::feat_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the link to be configured, 0..::MBG_NET_GLB_CFG_INFO::n_supp_intf_addr - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_net_intf_addr_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_net_intf_addr_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_NET_INTF_ADDR_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read ::MBG_NET_INTF_ROUTE_INFO_IDX from the config with the given index
 *
 * @note GPS_HAS_NET_CFG must be set and MBG_NET_GLB_SUPP_STAGE_2_MASK must be set in ::MBG_NET_GLB_CFG_INFO::feat_flags
 *
 * The number of ::MBG_NET_INTF_ROUTE_INFO_IDX provided by the device is specified in
 * ::MBG_NET_GLB_CFG_INFO::glb_settings::num_intf_route.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_NET_GLB_CFG_INFO::glb_settings::num_intf_route - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_net_cfg_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_intf_route_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_NET_INTF_ROUTE_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Send the network addr configuration in ::MBG_NET_INTF_ROUTE_SETTINGS format
 *
 * @note GPS_HAS_NET_CFG must be set and MBG_NET_GLB_SUPP_STAGE_2_MASK must be set in ::MBG_NET_GLB_CFG_INFO::feat_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the link to be configured, 0..::MBG_NET_GLB_CFG_INFO::num_intf_route - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_net_intf_route_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_net_intf_route_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_NET_INTF_ROUTE_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Read the network global status information ::MBG_NET_GLB_CFG_INFO format
 *
 * @note GPS_HAS_NET_CFG must be set and MBG_NET_GLB_SUPP_STAGE_2_MASK must be set in ::MBG_NET_GLB_CFG_INFO::feat_flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_net_glb_cfg_settings
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_stat_glb_cfg_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_NET_GLB_CFG_INFO *p ) ;

 /**
 * @brief Read ::MBG_NET_INTF_LINK_INFO_IDX from the status with the given index
 *
 * @note GPS_HAS_NET_CFG must be set and MBG_NET_GLB_SUPP_STAGE_2_MASK must be set in ::MBG_NET_GLB_CFG_INFO::feat_flags
 *
 * The number of ::MBG_NET_INTF_LINK_INFO_IDX provided by the device is specified in
 * ::MBG_NET_GLB_CFG_INFO::glb_settings::num_intf_link.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_NET_GLB_CFG_INFO::glb_settings::num_intf_link - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_net_status_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_stat_intf_link_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_NET_INTF_LINK_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read ::MBG_NET_INTF_ADDR_INFO_IDX from the status with the given index
 *
 * @note GPS_HAS_NET_CFG must be set and MBG_NET_GLB_SUPP_STAGE_2_MASK must be set in ::MBG_NET_GLB_CFG_INFO::feat_flags
 *
 * The number of ::MBG_NET_INTF_ADDR_INFO_IDX provided by the device is specified in
 * ::MBG_NET_GLB_CFG_INFO::glb_settings::num_intf_addr.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_NET_GLB_CFG_INFO::glb_settings::num_intf_addr - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_net_status_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_stat_intf_addr_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_NET_INTF_ADDR_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read ::MBG_NET_INTF_ROUTE_INFO_IDX from the status with the given index
 *
 * @note GPS_HAS_NET_CFG must be set and MBG_NET_GLB_SUPP_STAGE_2_MASK must be set in ::MBG_NET_GLB_CFG_INFO::feat_flags
 *
 * The number of ::MBG_NET_INTF_ROUTE_INFO_IDX provided by the device is specified in
 * ::MBG_NET_GLB_CFG_INFO::glb_settings::num_intf_route.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_NET_GLB_CFG_INFO::glb_settings::num_intf_route - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_net_status_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_net_stat_intf_route_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_NET_INTF_ROUTE_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read the ::XBP_LIMITS to check which XBP features are supported
 *
 * @note Only supported if ::GPS_HAS_XBP is set in ::RECEIVER_INFO::features
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_xbp_node_limits
 * @see ::mbgextio_get_xbp_node_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_xbp_limits( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XBP_LIMITS *p ) ;

 /**
 * @brief Read the ::XBP_NODE_LIMITS to check how many ports are provided
 *
 * @note Only supported if ::XBP_FEAT_MASK_NODES is set in ::XBP_LIMITS::features.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_xbp_limits
 * @see ::mbgextio_get_xbp_node_info_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_xbp_node_limits( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XBP_NODE_LIMITS *p ) ;

 /**
 * @brief Read the ::XBP_NODE_INFO for a specific node in ::XBP_NODE_INFO_IDX format
 *
 * The supported number of nodes is provided by ::XBP_NODE_LIMITS::node_count.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::XBP_NODE_LIMITS::node_count-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_xbp_limits
 * @see ::mbgextio_get_xbp_node_limits
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_xbp_node_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, XBP_NODE_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read the ::XBP_NODE_INFO for a specific node in ::XBP_NODE_INFO_IDX format
 * //##+++++++++++++++++++++++++
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_setup_xbp_node_list( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr ) ;

 /**
 * @brief Read configuration and health data of all satellites from a device
 *
 * @note Only supported by GPS receivers
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_cfgh( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, CFGH *p ) ;

 /**
 * @brief Read the GPS almanach for the specified SV from a device
 *
 * @note Only supported by GPS receivers
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     svno   SV number, for which the ::SV_ALM structure shall be requested
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_sv_alm( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, SV_ALM *p, SVNO svno ) ;

 /**
 * @brief Read the ionospheric correction parameters from a device
 *
 * @note Only supported by GPS receivers
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the ::IONO structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_iono( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, IONO *p ) ;

 /**
 * @brief Read a ::UTC parameter structure from a device.
 *
 * The ::UTC parameter structure contains the current UTC/GPS time offset
 * as well as information on an eventually upcoming leap second.
 *
 * @note Only supported by GPS/GNSS and some PZF receivers  //##+++++++ TODO Associated feature flag?
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_utc_parm
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_utc_parm( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, UTC *p ) ;

 /**
 * @brief Write a ::UTC parameter structure to a device.
 *
 * The ::UTC parameter structure contains the current UTC/GPS time offset
 * as well as information on an eventually upcoming leap second.
 *
 * @note Only supported by GPS/GNSS and some PZF receivers  //##+++++++ TODO Associated feature flag?
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_utc_parm
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_utc_parm( MBG_MSG_CTL *pmctl, XBP_ADDR *p_addr, const UTC *p ) ;

 /**
 * @brief Read SCU_STAT_INFO from the device
 *
 * @note This is only supported if ::GPS_MODEL_HAS_SCU_STAT is set in
 * the builtin features of the device
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_scu_stat
 * @see ::mbgextio_set_scu_stat_settings
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_scu_stat_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, SCU_STAT_INFO *p ) ;

 /**
 * @brief Send SCU_STAT_SETTINGS to the device
 *
 * @note This is only supported if ::GPS_MODEL_HAS_SCU_STAT is set in
 * the builtin features of the device
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_scu_stat
 * @see ::mbgextio_get_scu_stat_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_scu_stat_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const SCU_STAT_SETTINGS *p ) ;

 _NO_MBG_API_ATTR int _MBG_API mbgextio_time_mon_get_inst_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_TIME_MON_INST_INFO *p ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_time_mon_send_inst_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_TIME_MON_INST_INFO *p ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_time_mon_send_target_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_TIME_MON_TARGET_SETTINGS *p ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_time_mon_get_target_status_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_TIME_MON_TARGET_STATUS_IDX *p, uint16_t idx  ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_time_mon_get_target_ext_data_set_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_TIME_MON_TARGET_EXT_DATA_SET_IDX *p, uint16_t idx  ) ;
 /**
* @brief Read a ::MBG_GPIO_FREQ parameter structure from a device.
*
* The ::MBG_GPIO_FREQ parameter structure contains the current frequency
*
* @note Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
*
* @param[in,out] pmctl  Pointer to a valid message control structure
* @param[in]     p_addr Pointer to an XBP address specifier, or NULL
* @param[out]    p      Pointer to the data structure to return the received data
*
* @return One of the @ref MBG_RETURN_CODES
*/
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_fdm_freq( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_GPIO_FREQ *p ) ;

 /**
* @brief Read a ::MBG_IMS_FDM_INFO parameter structure from a device.
*
* The ::MBG_IMS_FDM_INFO parameter structure contains the ::MBG_IMS_FDM_SETTINGS, the supported nominal frequencies and flags
*
* @note Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
*
* @param[in,out] pmctl  Pointer to a valid message control structure
* @param[in]     p_addr Pointer to an XBP address specifier, or NULL
* @param[out]    p      Pointer to the data structure to return the received data
*
* @return One of the @ref MBG_RETURN_CODES
*/
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ims_fdm_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IMS_FDM_INFO *p ) ;

 /**
* @brief Read a ::MBG_IMS_FDM_LIMITS parameter structure from a device.
*
* The ::MBG_IMS_FDM_LIMITS parameter structure contains the limits of the configurable parameters and number of outpus
*
* @note Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
*
* @param[in,out] pmctl  Pointer to a valid message control structure
* @param[in]     p_addr Pointer to an XBP address specifier, or NULL
* @param[out]    p      Pointer to the data structure to return the received data
*
* @return One of the @ref MBG_RETURN_CODES
*/
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ims_fdm_limits( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IMS_FDM_LIMITS *p ) ;

 /**
* @brief Read a ::MBG_IMS_FDM_OUTPUT_INFO_IDX parameter structure from a device.
*
* The ::MBG_IMS_FDM_OUTPUT_INFO parameter structure contains the ::MBG_IMS_FDM_OUTPUT_SETTINGS, the supported modes and specific DAC limits
*
* @note Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
*
* @param[in,out] pmctl  Pointer to a valid message control structure
* @param[in]     p_addr Pointer to an XBP address specifier, or NULL
* @param[out]    p      Pointer to the data structure to return the received data
* @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_IMS_FDM_LIMITS::n_outputs-1
*
* @return One of the @ref MBG_RETURN_CODES
*/
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ims_fdm_output_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IMS_FDM_OUTPUT_INFO_IDX *p, uint16_t idx ) ;

 /**
* @brief Read a ::MBG_IMS_FDM_OUTPUT_STATE_IDX parameter structure from a device.
*
* The ::MBG_IMS_FDM_OUTPUT_STATE parameter structure contains the current DAC val and specs and the configured mode
*
* @note Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
*
* @param[in,out] pmctl  Pointer to a valid message control structure
* @param[in]     p_addr Pointer to an XBP address specifier, or NULL
* @param[out]    p      Pointer to the data structure to return the received data
* @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_IMS_FDM_LIMITS::n_outputs-1
*
* @return One of the @ref MBG_RETURN_CODES
*/
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ims_fdm_output_state_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IMS_FDM_OUTPUT_STATE_IDX *p, uint16_t idx ) ;

 /**
* @brief Read a ::MBG_IMS_FDM_STATE parameter structure from a device.
*
* The ::MBG_IMS_FDM_STATE parameter structure contains the current frequency, the reference, powerline and sync time, the configured nominal frequency and flags
*
* @note Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
*
* @param[in,out] pmctl  Pointer to a valid message control structure
* @param[in]     p_addr Pointer to an XBP address specifier, or NULL
* @param[out]    p      Pointer to the data structure to return the received data
*
* @return One of the @ref MBG_RETURN_CODES
*/
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ims_fdm_state( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_IMS_FDM_STATE *p ) ;

 /**
* @brief Write a ::MBG_IMS_FDM_SETTINGS parameter structure to a device.
*
* The ::MBG_IMS_FDM_SETTINGS parameter structure contains the limits for time and frequency deviation and the nominal frequency
*
* @note Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
*
* @param[in,out] pmctl  Pointer to a valid message control structure
* @param[in]     p_addr Pointer to an XBP address specifier, or NULL
* @param[in]     p      Pointer to the data structure to be sent to the device
*
* @return One of the @ref MBG_RETURN_CODES
*/
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ims_fdm_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_IMS_FDM_SETTINGS *p ) ;

 /**
 * @brief Write a ::MBG_IMS_FDM_OUTPUT_SETTINGS parameter structure to a device.
 *
 * The ::MBG_IMS_FDM_SETTINGS parameter structure contains the analog output mode
 *
 * @note Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the array element to be set, 0..::MBG_IMS_FDM_LIMITS::n_outputs-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_ims_fdm_output_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_IMS_FDM_OUTPUT_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Set time deviation of powerline time in relation to the current reference time
 *
 * @note Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags and
 *                         ::MBG_IMS_FDM_FLAG_CAN_SET_TDEV is set in ::MBG_IMS_FDM_INFO::flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_fdm_tdev( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const NANO_TIME_64 *p ) ;

 /**
 * @brief Send a command to let the device save it's current configuration as default
 *
 * Call ::mbgextio_dev_has_cmd_save_cfg to check if this function is supported.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_cmd_save_cfg
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_cmd_save_cfg( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr ) ;

 /**
 * @brief Read a ::MBG_IMS_FDM_STATE parameter structure from a device.
 *  ::TODO ###
 *
 * @note Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::TODO MBG_IMS_STATE::flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_lne_limits( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_LNE_LIMITS *p ) ;

 /**
 * @brief Read a ::MBG_LNE_PORT_INFO_IDX parameter structure from a device.
 *
 * @note ### ::TODO Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_LNE_LIMITS::num_ports-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_lne_port_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_LNE_PORT_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read a ::MBG_LNE_PORT_SETTINGS_IDX parameter structure from a device.
 *
 * @note ### ::TODO Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_LNE_LIMITS::num_ports
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_lne_port_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_LNE_PORT_SETTINGS_IDX *p, uint16_t idx ) ;

 /**
 * @brief Write a ::MBG_LNE_PORT_SETTINGS parameter structure to a device.
 *
 * @note ### ::TODO Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the array element to be set, 0..::MBG_LNE_LIMITS::num_ports - 1
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_lne_port_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_LNE_PORT_SETTINGS *p, uint16_t idx ) ;

 /**
 * @brief Write a ::MBG_PWR_CTL parameter structure to a device.
 *
 * @note Only supported if ::MBG_XFEATURE_PWR_CTL_API is set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_pwr_ctl( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_PWR_CTL *p ) ;

 /**
 * @brief Read a ::MBG_PWR_CTL parameter structure from a device.
 *
 * @note ### ::TODO Only supported if ::MBG_XFEATURE_PWR_CTL_API is set
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_pwr_ctl( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_PWR_CTL *p ) ;

 /**
 * @brief Read the ::MBG_LED_LIMITS to check how many LEDs are provided
 *
 * ::mbgextio_dev_has_led_api should be used to check if this is supported
 *
 * @note Only supported if ::MBG_IMS_STATE_FLAG_BIT_HAS_FDM is set in ::MBG_IMS_STATE::flags
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @ingroup group_led_api
 * @see ::mbgextio_dev_has_led_api
 * @see ::mbgextio_get_led_limits
 * @see ::mbgextio_get_led_info_idx
 * @see ::mbgextio_get_led_settings_idx
 * @see ::mbgextio_set_led_settings_idx
 * @see @ref group_led_api
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_led_limits( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_LED_LIMITS *p ) ;

 /**
 * @brief Read the current settings and features of a particular LED
 *
 * ::mbgextio_dev_has_led_api should be used to check if this is supported
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::MBG_LED_LIMITS::num_leds-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @ingroup group_led_api
 * @see ::mbgextio_dev_has_led_api
 * @see ::mbgextio_get_led_limits
 * @see ::mbgextio_get_led_settings_idx
 * @see ::mbgextio_set_led_settings_idx
 * @see @ref group_led_api
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_led_info_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_LED_INFO_IDX *p, uint16_t idx ) ;

 /**
 * @brief Read a ::MBG_LED_SETTINGS_IDX parameter structure from a device.
 *
 * ::mbgextio_dev_has_led_api should be used to check if this is supported
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p      Pointer to the data structure to return the received data
 * @param[in]     idx    Index of the array element to be retrieved, 0..::num_leds-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @ingroup group_led_api
 * @see ::mbgextio_dev_has_led_api
 * @see ::mbgextio_get_led_limits
 * @see ::mbgextio_get_led_info_idx
 * @see ::mbgextio_set_led_settings_idx
 * @see @ref group_led_api
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_led_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_LED_SETTINGS_IDX *p, uint16_t idx ) ;

 /**
 * @brief Write a ::MBG_LED_SETTINGS parameter structure to a device.
 *
 * ::mbgextio_dev_has_led_api should be used to check if this is supported
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 * @param[in]     idx    Index of the array element to be set, 0..::MBG_LNE_LIMITS::num_ports-1
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @ingroup group_led_api
 * @see ::mbgextio_dev_has_led_api
 * @see ::mbgextio_get_led_limits
 * @see ::mbgextio_get_led_info_idx
 * @see ::mbgextio_get_led_settings_idx
 * @see @ref group_led_api
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_set_led_settings_idx( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_LED_SETTINGS *p, uint16_t idx ) ;

 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_ext_sys_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_EXT_SYS_INFO *p ) ;
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_corr_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, CORR_INFO *p ) ;

/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif

#define _mbgextio_xmt_msg( _pmctl, _addr, _cmd, _s ) \
  mbgextio_xmt_msg( _pmctl, _addr, _cmd, _s, sizeof( *(_s) ) )

/* End of header body */

#undef _ext
#undef _DO_INIT

#endif  /* _MBGEXTIO_H */
