
/**************************************************************************
 *
 *  $Id: mbg_tmo.c 1.2 2009/09/01 10:36:45 martin REL_M $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Functions to implement portable timeout handling.
 *    These functions are normally implemented as inline functions, or
 *    as preprocessor macros, if inline code is not supported.
 *
 *    However, due to their nature the functions below can not be
 *    implemented as macros, so they need to be implemented as normal
 *    functions for targets which do not support inline functions.
 *
 *    This currently applies only to the CVI build environment.
 *
 * -----------------------------------------------------------------------
 *  $Log: mbg_tmo.c $
 *  Revision 1.2  2009/09/01 10:36:45  martin
 *  Implement legacy functions only if __mbg_inline is not defined.
 *  Revision 1.1  2009/08/25 11:28:47  martin
 *  Initial revision.
 *
 **************************************************************************/

#define _MBG_TMO
  #include <mbg_tmo.h>
#undef _MBG_TMO


#if !defined( __mbg_inline )


int mbg_tmo_curr_time_is_after( const MBG_TMO_TIME *tmo )
{
  MBG_TMO_TIME t_now;

  mbg_tmo_get_time( &t_now );

  return mbg_tmo_time_is_after( &t_now, tmo );

}  // mbg_tmo_curr_time_is_after



// The function below can be used to set up a timeout for select().

#if defined( MBG_TGT_CVI )

void mbgserio_msec_to_timeval( ulong msec, struct timeval *tv )
{
  tv->tv_sec = msec / 1000;
  tv->tv_usec = ( msec % 1000 ) * 1000;

}  // mbgserio_msec_to_timeval

#endif  // defined( MBG_TGT_CVI )


#endif  // !defined( __mbg_inline )


