
/**************************************************************************
 *
 *  $Id: gpsserio.h 1.48.1.90 2017/04/11 06:42:42 philipp TEST $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions and prototypes for gpsserio.c.
 *
 *    This file defines structures and codes to be used to access
 *    Meinberg GPS clocks via their serial interface COM0. COM0 should
 *    be set to a high baud rate, default is 19200.
 *
 *    Standard Meinberg GPS serial operation is to send the Meinberg
 *    standard time string automatically once per second, once per
 *    minute, or on request per ASCII '?'.
 *
 *    GPS parameter setup or parameter readout uses blocks of binary
 *    data which have to be isolated from the standard string. A block
 *    of data starts with a SOH code (ASCII Start Of Header, 0x01)
 *    followed by a message header with constant length and a block of
 *    data with variable length.
 *
 *    The first field (cmd) of the message header holds the command
 *    code rsp. the type of data to be transmitted. The next field (len)
 *    gives the number of data bytes that follow the header. This number
 *    ranges from 0 to sizeof( MSG_DATA ). The third field (data_csum)
 *    holds a checksum of all data bytes and the last field of the header
 *    finally holds the checksum of the header itself.
 *
 * -----------------------------------------------------------------------
 *  $Log: gpsserio.h $
 *  Revision 1.48.1.90  2017/04/11 06:42:42  philipp
 *  Renamed MBG_USB_INTR structures to MBG_USB_LOCK
 *  Revision 1.48.1.89  2017/04/11 05:29:57  philipp
 *  Added commands, structures and defines for feature USB interrupt
 *  Revision 1.48.1.88  2017/03/27 10:38:26  thomas-b
 *  Added GPS command to read and write PTPv1 common datasets
 *  Revision 1.48.1.87  2017/03/03 06:43:48  thomas-b
 *  Removed DEBUG restriction for NTP server mode structures, added several new NTP structures
 *  Revision 1.48.1.86  2017/03/02 14:04:56  gregoire
 *  Support of new NTP structures added
 *  Revision 1.48.1.85  2017/03/02 08:34:53  gregoire
 *  New cmds for NTP strucutres added
 *  Revision 1.48.1.84  2017/02/21 15:54:55  thomas-b
 *  Added GPS commands for monitoring events and status and extended MSG_BUF
 *  Revision 1.48.1.83  2017/02/16 13:01:23  thomas-b
 *  Renamed command GPS_PTP_V2_PORT_DS to GPS_PTP_V2_PORT_DS_IDX
 *  Revision 1.48.1.82  2017/02/16 12:10:08  martin
 *  *** empty log message ***
 *  Revision 1.48.1.81  2017/02/16 08:13:22  thomas-b
 *  Added GPS commands to query and send PTPv2 common datasets
 *  Revision 1.48.1.80  2017/02/15 16:15:15  martin
 *  Renamed GNSS_SV_INFO to GNSS_SV_STATUS.
 *  Revision 1.48.1.79  2017/02/10 14:41:36  martin
 *  New extended feature MBG_XFEATURE_GNSS_SV_INFO
 *  and associated structures.
 *  Revision 1.48.1.78  2017/02/08 07:12:41  thomas-b
 *  Removed one more unnecessary GPS command for SNMP
 *  Revision 1.48.1.77  2017/02/08 07:05:37  philipp
 *  Use less GPS command codes for SNMP monitoring
 *  Revision 1.48.1.76  2017/02/06 15:42:29  philipp
 *  Added SNMP monitoring structures to MBG_MSG_CTL
 *  Revision 1.48.1.75  2017/02/06 13:09:53  philipp
 *  Added GPS monitoring commands
 *  Revision 1.48.1.74  2017/01/27 08:17:40  martin
 *  Fixed macro syntax.
 *  Revision 1.48.1.73  2016/11/22 10:33:16  philipp
 *  Implemented I/O ports
 *  Revision 1.48.1.72  2016/11/15 15:43:57  martin
 *  Account for modified mbgserio functions.
 *  Revision 1.48.1.71  2016/10/27 07:59:33  martin
 *  *** empty log message ***
 *  Revision 1.48.1.70  2016/10/25 07:48:28  martin
 *  Doxygen fixes.
 *  Revision 1.48.1.69  2016/10/14 08:18:52  thomas-b
 *  Decreased poll timeout
 *  Revision 1.48.1.68  2016/10/10 10:17:52  thomas-b
 *  Added new commands for MBG_XFEATURE_UCAP_NETWORK
 *  Revision 1.48.1.67  2016/09/30 05:36:43  thomas-b
 *  Decreased socket poll timeout
 *  Revision 1.48.1.66  2016/09/29 07:22:10  thomas-b
 *  Improved comments for new commands
 *  Revision 1.48.1.65  2016/09/28 13:44:08  thomas-b
 *  Added commands and structures for MBG_NET_CFG_API stage 2
 *  Revision 1.48.1.64  2016/08/23 09:18:33  udo
 *  changed Time Mon Inst Info structure for both read/write
 *  Revision 1.48.1.63  2016/08/16 12:48:30  gregoire.diehl
 *  Fixed default build.
 *  Revision 1.48.1.62  2016/08/15 09:30:55  udo
 *  added TIME_MON_TARGET_EXT_DATA_SET
 *  Revision 1.48.1.61  2016/08/11 11:30:43  martin
 *  Conditionally support time monitoring API.
 *  Revision 1.48.1.60  2016/08/11 10:25:37  martin
 *  Started to support time_mon.
 *  Revision 1.48.1.59  2016/08/09 07:10:07  martin
 *  *** empty log message ***
 *  Revision 1.48.1.58  2016/08/04 14:51:25  martin
 *  Moved some compatibility definitions from gpsserio.h to mbg_tgt.h.
 *  Revision 1.48.1.57  2016/07/07 14:22:05  martin
 *  *** empty log message ***
 *  Revision 1.48.1.56  2016/07/07 13:08:44  andre.hartmann
 *  added support for mbg_clock_res_info
 *  Revision 1.48.1.55  2016/06/29 11:59:11Z  philipp
 *  Extended socket API by TCP client
 *  Revision 1.48.1.54  2016/06/13 15:02:13  andre
 *  Revision 1.48.1.53  2016/06/02 10:15:38Z  philipp
 *  Renaming all MBG_EXT_REV_INFO related stuff to MBG_EXT_SYS_INFO.
 *  Revision 1.48.1.52  2016/05/18 07:35:05  andre
 *  added command for XMR_METRICS_IDX
 *  Revision 1.48.1.51  2016/04/25 14:45:21Z  martin
 *  Moved TLV, transaction, and boot stuff from _PRELIMINARY_CODE
 *  to standard section.
 *  Revision 1.48.1.50  2016/04/20 09:26:10  philipp
 *  Moved all HPS-PTP related structures to gpspriv.h and removed related extended feature bit from gpsdefs.h.
 *  Also removed functions from mbgextio and xdevfeat since HPS-PTP handling needs a redesign concerning structures.
 *  Thus, handle everything explicitly for now!
 *  -> Redesing this A.S.A.P.!!!
 *  Revision 1.48.1.49  2016/04/07 13:50:08  martin
 *  New command GPS_EXT_REV_INFO.
 *  Revision 1.48.1.48  2016/03/24 14:08:49  martin
 *  *** empty log message ***
 *  Revision 1.48.1.47  2016/03/24 09:16:19  martin
 *  Reworked device power control definitions.
 *  Revision 1.48.1.46  2016/03/23 13:45:47  thomas-b
 *  Fixed check for buffer overflow and return appropriate rc
 *  Revision 1.48.1.45  2016/03/21 13:27:32  martin
 *  *** empty log message ***
 *  Revision 1.48.1.44  2016/03/16 16:07:03  martin
 *  *** empty log message ***
 *  Revision 1.48.1.43  2016/03/15 14:55:07  martin
 *  Modified LNE and LED API.
 *  Revision 1.48.1.42  2016/03/11 10:16:38  thomas-b
 *  Added function chk_hdr_rcvd
 *  Revision 1.48.1.41  2016/03/01 09:18:57  udo
 *  added LNE_PWR_STATE
 *  Revision 1.48.1.40  2016/02/22 08:51:51  udo
 *  added LNE_INFO_EXT
 *  Revision 1.48.1.39  2016/02/18 11:26:21  udo
 *  added MBG_LNE_LED_STATUS to data types of binary protocol
 *  Revision 1.48.1.38  2016/02/18 08:58:45  udo
 *  added LNE_LED_STATE in GPS_CMD_CODES
 *  Revision 1.48.1.37  2016/02/17 14:35:22  udo
 *  used MBG_TIME_MON_TARGET_STATUS_IDX
 *  Revision 1.48.1.36  2016/02/11 09:57:41  paul
 *  withdraw rename in MSG_DATA
 *  updated comment
 *  Revision 1.48.1.35  2016/02/09 13:21:20Z  paul
 *  renamd GPS_FDM_SET_PLT to GPS_FDM_SET_TD
 *  changed NANO_TIME_64 field to int32_t in MSG_DATA union
 *  Revision 1.48.1.34  2016/02/08 10:59:45Z  martin
 *  *** empty log message ***
 *  Revision 1.48.1.33  2016/02/08 10:43:56  martin
 *  Added command GPS_FDM_SET_PLT.
 *  Revision 1.48.1.32  2016/01/19 14:12:29  udo
 *  improve time monitor structures
 *  Revision 1.48.1.31  2016/01/18 08:42:44  udo
 *  added support for PTP Time Monitoring on TSU/HPS100
 *  Revision 1.48.1.30  2016/01/15 08:54:41  martin
 *  *** empty log message ***
 *  Revision 1.48.1.29  2016/01/14 08:35:48  martin
 *  *** empty log message ***
 *  Revision 1.48.1.28  2016/01/14 08:28:53  martin
 *  Fixed a typo.
 *  Revision 1.48.1.27  2016/01/13 15:09:19  martin
 *  Support XMR_STATS.
 *  Revision 1.48.1.26  2015/12/10 16:30:15  martin
 *  *** empty log message ***
 *  Revision 1.48.1.25  2015/12/10 11:52:10  martin
 *  *** empty log message ***
 *  Revision 1.48.1.24  2015/12/01 11:54:26  martin
 *  Support TLV features.
 *  Revision 1.48.1.23  2015/11/30 16:51:03  martin
 *  New command GPS_SAVE_CFG.
 *  Revision 1.48.1.22  2015/11/26 09:57:32  martin
 *  *** empty log message ***
 *  Revision 1.48.1.21  2015/11/25 16:56:01  martin
 *  Started to implement extended features.
 *  Merged Philipp's changes from the 1.48.1.19.1.x branch.
 *  Revision 1.48.1.20  2015/10/09 11:09:16  martin
 *  *** empty log message ***
 *  Revision 1.48.1.19  2015/10/06 14:11:23  martin
 *  Account for library module chk_tstr renamed to mbg_tstr.
 *  Revision 1.48.1.18  2015/10/01 07:34:34  martin
 *  Fixed a typo.
 *  Revision 1.48.1.17  2015/09/24 13:31:01  philipp
 *  Removed duplicate GPS_GET_DIAG_FILE command
 *  Revision 1.48.1.16  2015/09/24 13:12:54  philipp
 *  Changed naming to be more common
 *  Revision 1.48.1.15  2015/09/23 12:34:07  daniel
 *  Added two new HPS commands for reboot and diag file
 *  Revision 1.48.1.14  2015/09/15 13:25:58  martin
 *  *** empty log message ***
 *  Revision 1.48.1.13  2015/09/14 07:51:40  werner
 *  Revision 1.48.1.12  2015/09/14 07:48:32Z  martin
 *  *** empty log message ***
 *  Revision 1.48.1.11  2015/09/14 07:22:26  martin
 *  *** empty log message ***
 *  Revision 1.48.1.10  2015/09/11 12:04:51  martin
 *  *** empty log message ***
 *  Revision 1.48.1.9  2015/09/10 12:49:11  martin
 *  New code GPS_FDM_FREQ.
 *  Revision 1.48.1.8  2015/09/10 07:42:37  daniel
 *  Added preliminary commands GPS_BEGIN_TRANSACTION, GPS_END_TRANSACTION
 *  Revision 1.48.1.7  2015/09/08 14:22:44  martin
 *  Revision 1.48.1.6  2015/09/08 12:13:46  martin
 *  Revision 1.48.1.5  2015/09/07 08:33:03  philipp
 *  Added GPS commands GPS_GET_DIAG_FILE and GPS_DO_FW_UPDATE to _PRELIMINARY_CODE section
 *  Revision 1.48.1.4  2015/09/04 09:19:49  daniel
 *  Added GPS_REFCLOCK_STATE and GPS_TSU_VERSION to _PREMININARY_CODE
 *  Revision 1.48.1.3  2015/09/02 16:42:20  martin
 *  Preliminary code which is only included if a preprocessor symbol
 *  _PRELIMINARY_CODE is defined in the project Makefile.
 *  Revision 1.48.1.2  2015/08/20 14:50:39  martin
 *  Account for renamed symbol in a different module.
 *  Revision 1.48.1.1  2015/07/24 11:07:39  martin
 *  Revision 1.48  2015/07/06 15:23:51  martin
 *  Updated function prototypes.
 *  Revision 1.47  2015/05/13 13:52:57  martin
 *  Support XBP addressing.
 *  Fixed misspelled MBG_XFER_MODE_ENCRYPTED.
 *  Renamed some GPS cmd codes to more intuitive names.
 *  Added GPS cmd CMD codes for FDM.
 *  New cmd code GPS_XMR_EXT_SRC_INFO_IDX.
 *  Removed trailing whitespace.
 *  Updated doxygen-style comments.
 *  Updated function prototypes.
 *  Revision 1.46  2014/07/17 09:47:21  martin
 *  New command codes GPS_GPIO_STATUS_IDX
 *  and GPS_XMR_HOLDOVER_STATUS.
 *  Updated doxygen comments.
 *  Revision 1.45  2014/05/27 08:58:47  martin
 *  Defined a some new command codes and added
 *  associated fields to MSG_DATA union.
 *  Introduced MBG_SOCK_FD type.
 *  Use new preprocessor symbol MBG_TGT_POSIX.
 *  Support new libusb.
 *  Conditional FTDI serial interface support.
 *  Account for definitions renamed elsewhere.
 *  Simplified declaration of code/name tables.
 *  Conditionally use new CHK_TSTR_FNC type.
 *  Huge rework of comments in doxygen format.
 *  Revision 1.44  2013/04/04 09:03:29Z  martin
 *  Support HaveQuick configuration.
 *  Revision 1.43  2013/01/30 16:07:49  martin
 *  Changed definition of transfer status codes to an enum
 *  with appropriate comments.
 *  Added union TZCODE_UNION.
 *  Fixed some doxygen comments.
 *  Revision 1.42  2013/01/16 11:48:36Z  martin
 *  Support IMS and XMR_HOLDOVER_INTV.
 *  Revision 1.41  2012/10/30 16:25:15  martin
 *  Added GPS_WILDCARD cmd code.
 *  Account for changed chk_tstr_func return code.
 *  Added  completion codes TR_COMPLETE_TSTR and TR_RCVD_NACK.
 *  Revision 1.40  2012/04/11 16:03:29  martin
 *  Fixed some doxygen stuff.
 *  Revision 1.39  2012/03/08 15:34:18Z  martin
 *  Added default setting for _USE_USB_IO.
 *  Revision 1.38  2012/03/06 15:33:43  martin
 *  Added support for SCU and LNO.
 *  Account for modified chk_tstr() parameters.
 *  Revision 1.37  2011/11/25 14:59:17Z  martin
 *  Account for some renamed evt_log library symbols.
 *  Revision 1.36  2011/11/25 10:37:10  martin
 *  Added commands and data structures to support log events.
 *  Revision 1.35  2011/07/29 09:46:54  daniel
 *  Use native alignment only.
 *  Added command code GPS_XMR_INSTANCES.
 *  Support GPIO configuration.
 *  Support for USB.
 *  Revision 1.34  2011/04/15 13:12:02  martin
 *  Added initializer for command name table.
 *  Unified mutex stuff using macros from mbgmutex.h.
 *  Revision 1.33  2010/09/07 07:18:08  daniel
 *  New codes and structures for multi GNSS support.
 *  Defines to support reading raw IRIG data.
 *  Revision 1.32  2009/08/26 09:02:21  daniel
 *  Added new commands GPS_NAV_ENG_SETTINGS and
 *  GPS_GLNS_ALM.
 *  Revision 1.31  2009/08/24 13:32:33Z  martin
 *  Renamed symbol MBGEXTIO_TIMEOUT_SOCKET to MBGEXTIO_RCV_TIMEOUT_SOCKET.
 *  Support new timeout handling distinguishing between character timeout
 *  and message timeout. Timeout values are now expected in milliseconds.
 *  Revision 1.30  2009/07/02 09:19:31  martin
 *  Moved definitions related to LAN interface configuration to gpsdefs.h.
 *  Revision 1.29  2009/03/10 17:00:29  martin
 *  Support configurable time scales.
 *  Don't pack structure MBG_MSG_CTL but use default alignment.
 *  Revision 1.28  2008/09/04 12:47:10Z  martin
 *  Moved generic serial I/O stuff to mbgserio.h.
 *  Preliminarily support chk_tstr.
 *  Revision 1.27  2008/04/07 10:49:13Z  martin
 *  Added cmd GPS_CLR_UCAP_BUFF.
 *  Revision 1.26  2007/02/27 09:51:45  martin
 *  Modified mutex macros for Windows.
 *  Added type TZCODE which is used by the binary protocol but
 *  has a different size than PCPS_TZCODE.
 *  Now _USE_PCPSDEFS by default for non-firmware apps.
 *  Fixed comments on GPS_OPT_SETTINGS and GPS_OPT_INFO.
 *  Revision 1.25  2007/02/06 16:31:04Z  martin
 *  Modified comment for PZF_PCPS_TIME which can now also
 *  be sent to a device.
 *  Added mutex support.
 *  Added SVNO to the buffer union.
 *  Added support for OPT_SETTINGS.
 *  Added XMULTI_REF_... definitions.
 *  Modified some comments.
 *  Revision 1.24  2006/12/21 10:54:14Z  martin
 *  Moved macro _IS_MBG_FIRMWARE to words.h.
 *  Cleaned up definitions of default I/O macros.
 *  Revision 1.23  2006/12/12 15:53:58  martin
 *  Added structure LAN_IF_INFO and associated codes.
 *  Added cmd codes GPS_IRIG_RX_SETTINGS and GPS_IRIG_RX_INFO.
 *  Added new member irig_rx_info to union MSG_DATA.
 *  Added cmd code GPS_REF_OFFS and associated definitions.
 *  Added cmd code GPS_DEBUG_STATUS.
 *  Define MBG_HANDLE for DOS even without v24tools.
 *  Revision 1.22  2006/11/02 08:57:56  martin
 *  Added a typedef to avoid firmware build errors.
 *  Revision 1.21  2006/10/25 12:25:35Z  martin
 *  Support serial I/O under Windows.
 *  Removed obsolete definitions.
 *  Updated function prototypes.
 *  Revision 1.20  2006/08/24 13:00:08Z  martin
 *  Added conditional support for network socket I/O and encrypted packets.
 *  Serial I/O is now also conditional only.
 *  Added/renamed/redefined structures as required.
 *  Revision 1.19  2006/06/15 10:39:49Z  martin
 *  Added some special types to the MSG_DATA union which have
 *  previously been defined as generic uint16_t types.
 *  Removed MBG_OPT_SETTINGS and MBG_OPT_INFO from
 *  the MSG_DATA union since those types are not used with
 *  the binary protocol.
 *  Revision 1.18  2006/05/18 09:43:35Z  martin
 *  New cmd code GPS_IGNORE_LOCK.
 *  Added command codes for PZF receivers.
 *  Renamed IRIG_... symbols to IRIG_TX_... in order to distinguish
 *  from IRIG input configuration which might be available in the future.
 *  Added some fields to the MSG_DATA union.
 *  Renamed MSG_BUFF field "data" to "msg_data" in order to avoid
 *  conflict with reserved word in some environments.
 *  Rewrote inclusion control macros.
 *  Replace control of inclusion of function prototypes by new symbol
 *  _USE_GPSSERIO_FNC which can be fully overridden.
 *  Updated lots of comments.
 *  Revision 1.17  2005/09/08 14:47:05Z  martin
 *  Changed type of MSG_RCV_CTL::flags from int to ulong
 *  to avoid compiler warnings.
 *  Revision 1.16  2005/04/26 10:53:53Z  martin
 *  Updated function prototypes.
 *  Revision 1.15  2004/12/28 11:02:20Z  martin
 *  Redefined interface data types using C99 fixed-size definitions.
 *  Replaced received_header by flags in MSG_RCV_CTL.
 *  Defined flag bits and corresponding bit masks.
 *  Updated function prototypes.
 *  Revision 1.14  2004/07/08 08:28:30  martin
 *  New cmd code GPS_RCV_TIMEOUT which is only supported if
 *  feature mask GPS_HAS_RCV_TIMEOUT is set.
 *  Revision 1.13  2004/06/16 14:13:50  martin
 *  Changed name of symbol which controls inclusion of function prototypes.
 *  Don't include function prototypes by default if compiling firmware.
 *  Conditionally support private data structures, automatically include
 *  those definitions if compiling firmware.
 *  The data portion of MSG_BUFF is now a union whose maximum size
 *  can be overridden by a preprocessor value.
 *  Added MBG_OPT_SETTINGS and MBG_OPT_INFO to the buffer union.
 *  Updated function prototypes.
 *  Revision 1.12  2004/04/16 09:16:00Z  andre
 *  Added command code GPS_MULTI_REF_STATUS.
 *  Revision 1.11  2004/03/26 11:08:28Z  martin
 *  Compile function prototypes conditionally only.
 *  if symbol _INCL_GPSSERIO_FNC is defined.
 *  New structure MSG_RCV_CTL to support binary
 *  protocol on several ports.
 *  Added support for IPv4 LAN interface configuration.
 *  Support MULTI_REF_SETTINGS/MULTI_REF_INFO.
 *  Added command code to query ROM checksum.
 *  Modified some comments.
 *  Updated function prototypes.
 *  Revision 1.10  2002/08/21 07:39:32Z  werner
 *  POUT_PROG -> POUT_INFO
 *  Revision 1.9  2002/01/29 15:29:16Z  MARTIN
 *  Renamed cmd code GPS_IRIG_CFG to GPS_IRIG_SETTINGS.
 *  Added new cmd codes GPS_RECEIVER_INFO...GPS_IRIG_INFO
 *  and updated msg buffer union with corresponding fields.
 *  Removed obsolete types OPT_FEATURES, IRIG_CFG  and
 *  associated definitions.
 *  Modified some comments.
 *  Revision 1.8  2001/04/06 11:51:24  Andre
 *  transfercodes and structures for IRIG parameter and installed
 *  options added
 *  Revision 1.7  2001/03/30 10:47:04Z  MARTIN
 *  New file header.
 *  Control alignment of structures from new file use_pack.h.
 *  Modified syntax and some comments.
 *
 **************************************************************************/

#ifndef _GPSSERIO_H
#define _GPSSERIO_H


/* Other headers to be included */

#include <gpsdefs.h>
#include <use_pack.h>


/*
 * The following macros control parts of the build process.
 * The default values are suitable for most cases but can be
 * overridden by global definitions, if required.
 */

#if !_IS_MBG_FIRMWARE
  #include <xdevfeat.h>
#else
  // This handle type in not used by the firmware.
  // However, we define it to avoid build errors.
  typedef int MBG_HANDLE;
#endif


#ifndef _USE_MUTEX
  #if defined( MBG_TGT_WIN32 )
    #define _USE_MUTEX  1
  #elif defined( MBG_TGT_POSIX )
    #define _USE_MUTEX  1
  #endif
#endif

#ifndef _USE_MUTEX
  #define _USE_MUTEX          0  // not used by default
#endif


/* Control whether network socket communication shall be supported */
#ifndef _USE_SOCKET_IO
  #define _USE_SOCKET_IO      0  // not supported by default
#endif

/* Control whether serial port communication shall be supported */
#ifndef _USE_SERIAL_IO
  #if _IS_MBG_FIRMWARE
    #define _USE_SERIAL_IO    0  // firmware provides its own serial I/O functions
  #else
    #define _USE_SERIAL_IO    1  // supported by default
  #endif
#endif

#ifndef _USE_SERIAL_IO_FTDI
  // FTDI D2xx USB-To-Serial converters accessed via a proprietary DLL
  #define _USE_SERIAL_IO_FTDI 0  // not supported by default
#endif

/* Control whether USB communication shall be supported */
#if defined( MBG_TGT_LINUX )
  #ifndef _USE_USB_IO            // may be overridden by project settings
    #define _USE_USB_IO       0  // not supported by default
  #endif
#else
  // USB I/O requires libusb and is currently only supported under Linux.
  // So for non-Linux targets force _USE_USB_IO to 0.
  #define _USE_USB_IO         0  // not supported by default
#endif

/*
 * Control whether direct USB I/O communication is supported
 * for example via "/dev/mbgims" in case there is an appropriate
 * channel to do so.
 */
#if defined( MBG_TGT_LINUX )
  #ifndef _USE_USB_DIRECT_IO
    #define _USE_USB_DIRECT_IO  0   // Not supported by default
  #endif
#else
  // Not supported by other platforms
  #define _USE_USB_DIRECT_IO    0   // Not supported by default
#endif

/* Control inclusion of secudefs.h */
#if _USE_SOCKET_IO
  // Network socket I/O always requires secudefs, so make sure
  // this is defined correctly.
  #undef _USE_ENCRYPTION
  #define _USE_ENCRYPTION     1
#else
  // If no socket I/O is used then secudefs aren't required, either.
  #ifndef _USE_ENCRYPTION
    #define _USE_ENCRYPTION   0
  #endif
#endif

/* Control inclusion of pcpsdefs.h */
#ifndef _USE_PCPSDEFS
  #if _IS_MBG_FIRMWARE
    // for firmware depend on the target system
    #if defined( _CC51 )
      #define _USE_PCPSDEFS    1
    #else
      #define _USE_PCPSDEFS    0
    #endif
  #else
    // otherwise include it by default
    #define _USE_PCPSDEFS      1
  #endif
#endif

/* Control inclusion of time_mon.h */
#ifndef _USE_TIME_MON
  #define _USE_TIME_MON        0
#endif

/* Control inclusion of non-public declarations */
#ifndef _USE_GPSPRIV
  /* by default do include if building a GPS firmware */
  #define _USE_GPSPRIV  _IS_MBG_FIRMWARE
#endif

/* Control inclusion of function prototypes */
#ifndef _USE_GPSSERIO_FNC
  /* by default don't include if building a firmware */
  #define _USE_GPSSERIO_FNC  ( !_IS_MBG_FIRMWARE )
#endif

#ifndef _USE_RCV_TSTAMP
  #define _USE_RCV_TSTAMP    ( !_IS_MBG_FIRMWARE )
#endif


#if _USE_MUTEX
  #include <mbgmutex.h>
#endif

#if _USE_SERIAL_IO
  #include <mbgserio.h>
#endif

#if _USE_SERIAL_IO_FTDI
  #include <ftd2xx.h>  // interface for ftd2xx.dll
#else
  // just to avoid build errors if FTDI API is not supported
  #define FT_STATUS int
#endif

#if _USE_USB_IO
  #include <mbgusbio.h>
#endif

#if _USE_SOCKET_IO
  #if defined( MBG_TGT_POSIX )
    #include <netdb.h>
  #endif
#endif

#if _USE_ENCRYPTION
  #include <secudefs.h>
  #include <aes128.h>
#endif

#if _USE_PCPSDEFS
  #include <pcpsdefs.h>
#endif

#if _USE_TIME_MON && defined( _PRELIMINARY_CODE )
  #include <time_mon.h>
#else  // dummy declarations to avoid compiler errors with function prototypes
  typedef int MBG_TIME_MON_LIMITS;
  typedef int MBG_TIME_MON_INST_SETTINGS;
  typedef int MBG_TIME_MON_INST_SETTINGS_IDX;
  typedef int MBG_TIME_MON_INST_INFO;
  typedef int MBG_TIME_MON_INST_INFO_IDX;
  typedef int MBG_TIME_MON_TARGET_SETTINGS;
  typedef int MBG_TIME_MON_TARGET_SETTINGS_IDX;
  typedef int MBG_TIME_MON_TARGET_STATUS;
  typedef int MBG_TIME_MON_TARGET_STATUS_IDX;
  typedef int MBG_TIME_MON_TARGET_EXT_DATA_SET_IDX;
#endif

#if _USE_GPSPRIV
  #include <gpspriv.h>
#endif

#if _USE_RCV_TSTAMP || defined( _DEBUG_MSG_TIMING )
  #include <mbg_tmo.h>
#endif


#ifdef _GPSSERIO
 #define _ext
#else
 #define _ext extern
#endif


/* Start of header body */

// We don't use pragma pack() here but native alignment.

#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief Status codes returned by the check_transfer() function.
 */
enum TR_STATUS_CODES
{
  TR_COMPLETE      = 2,   ///< A binary message has been received successfully
  TR_RECEIVING     = 1,   ///< Binary reception in progress, i.e. after START_OF_HEADER received
  TR_WAITING       = 0,   ///< Waiting for a binary message, i.e. no START_OF_HEADER received, yet
  TR_TIMEOUT       = -1,  ///< No data received during the timeout interval
  TR_CSUM_HDR      = -2,  ///< The header checksum of a received message is invalid
  TR_CSUM_DATA     = -3,  ///< The data checksum of a received message is invalid
  TR_DECRYPTION    = -4,  ///< A binary message received over LAN could not be decrypted.
  TR_OPEN_ERR      = -5,  ///< Failed to open connection.
  TR_IO_ERR        = -6,  ///< I/O error for the specified connection
  TR_AUTH_ERR      = -7,  ///< Authentication error for the specified LAN connection
  TR_RCVD_NACK     = -8,  ///< Received Negative Acknowledge from a device (prev. msg not accepted or not supported)
  TR_OVERFLOW      = -9   ///< Received message was too long for the message receive buffer
};



/**
 * @brief The start of header code sent before a binary message header
 */
#define START_OF_HEADER   0x01     ///< ASCII SOH


/**
 * @brief Control codes to be or'ed with a particular command/type code
 */
enum GPS_CMD_CTRL_CODES
{
  GPS_REQACK = 0x8000,   ///< to device: request acknowledge
  GPS_ACK    = 0x4000,   ///< from device: acknowledge a command
  GPS_NACK   = 0x2000,   ///< from device: error evaluating a command
};

#define GPS_CTRL_MSK  0xF000   ///< bit mask of all ::GPS_CMD_CTRL_CODES


/**
 * @brief A wildcard command code
 *
 * This code can be passed to a receive routine to wait for any type
 * of binary packet rather than for a specific packet.
 */
#define GPS_WILDCARD  ( (GPS_CMD) -1 )


/**
 * @brief Command codes for the binary protocol
 *
 * These codes specify commands and associated data types used by Meinberg's
 * binary protocol to exchange data with a device via serial port, direct USB,
 * or socket I/O.
 *
 * Some commands and associated data structures can be read (r) from a device, others
 * can be written (w) to the device, and some can also be sent automatically (a) by
 * a device after a ::GPS_AUTO_ON command has been sent to the device.
 * The individual command codes are marked with (rwa) accordingly, where '-' is used
 * to indicate that a particular mode is not supported.
 *
 * @note Not all command code are supported by all devices.
 * See the hints for a particular command.
 *
 * @note If ::GPS_ALM, ::GPS_EPH or a code named ..._IDX is sent to retrieve
 * some data from a device then an uint16_t parameter must be also supplied
 * in order to specify the index number of the data set to be returned.
 * The valid index range depends on the command code.
 * For ::GPS_ALM and ::GPS_EPH the index is the SV number which may be 0 or
 * ::MIN_SVNO_GPS to ::MAX_SVNO_GPS. If the number is 0 then all ::N_SVNO_GPS
 * almanacs or ephemeris data structures are returned.
 *
 * @see ::GPS_CMD_CODES_TABLE
 */
enum GPS_CMD_CODES
{ /* system data */
  GPS_AUTO_ON = 0x000,          ///< (-w-) no data, enable auto-msgs from device
  GPS_AUTO_OFF,                 ///< (-w-) no data, disable auto-msgs from device
  GPS_SW_REV,                   ///< (r--) deprecated, ::SW_REV, software revision, use only if ::GPS_RECEIVER_INFO not supp.
  GPS_BVAR_STAT,                ///< (r--) ::BVAR_STAT, status of buffered variables, only if ::GPS_MODEL_HAS_BVAR_STAT
  GPS_TIME,                     ///< (-wa) ::TTM, current time or capture, or init board time
  GPS_POS_XYZ,                  ///< (rw-) ::XYZ, current position in ECEF coordinates, only if ::GPS_MODEL_HAS_POS_XYZ
  GPS_POS_LLA,                  ///< (rw-) ::LLA, current position in geographic coordinates, only if ::GPS_MODEL_HAS_POS_LLA
  GPS_TZDL,                     ///< (rw-) ::TZDL, time zone / daylight saving, only if ::GPS_MODEL_HAS_TZDL
  GPS_PORT_PARM,                ///< (rw-) deprecated, ::PORT_PARM, use ::PORT_SETTINGS etc. if ::GPS_RECEIVER_INFO supported
  GPS_SYNTH,                    ///< (rw-) ::SYNTH, synthesizer settings, only if ::GPS_HAS_SYNTH
  GPS_ANT_INFO,                 ///< (r-a) ::ANT_INFO, time diff after antenna disconnect, only if ::GPS_MODEL_HAS_ANT_INFO
  GPS_UCAP,                     ///< (r-a) ::TTM, user capture events, only if ::RECEIVER_INFO::n_ucaps > 0
  GPS_ENABLE_FLAGS,             ///< (rw-) ::ENABLE_FLAGS, when to enable serial, pulses, and synth, only if ::GPS_MODEL_HAS_ENABLE_FLAGS
  GPS_STAT_INFO,                ///< (r--) ::STAT_INFO, satellite info, mode of operation, and DAC info, only if ::GPS_MODEL_HAS_STAT_INFO
  GPS_SWITCH_PARMS,             ///< (rw-) deprecated, use ::GPS_POUT_INFO_IDX/::GPS_POUT_SETTINGS_IDX
  GPS_STRING_PARMS,             ///< (rw-) deprecated, use ::GPS_PORT_INFO_IDX/::GPS_PORT_SETTINGS_IDX
  GPS_ANT_CABLE_LENGTH,         ///< (rw-) ::ANT_CABLE_LEN, length of antenna cable, only if ::GPS_MODEL_HAS_ANT_CABLE_LEN
  GPS_SYNC_OUTAGE_DELAY,        ///< (rw-) (customized firmware only)
  GPS_PULSE_INFO,               ///< (rw-) (customized firmware only)
  GPS_OPT_FEATURES,             ///< (r--) deprecated, use ::GPS_RECEIVER_INFO
  GPS_IRIG_TX_SETTINGS,         ///< (rw-) ::IRIG_SETTINGS, only if ::GPS_HAS_IRIG_TX
  GPS_RECEIVER_INFO,            ///< (r--) ::RECEIVER_INFO, model specific info, not supported by *very* old devices
  GPS_STR_TYPE_INFO_IDX,        ///< (r--) ::STR_TYPE_INFO_IDX, names and capabilities of supp. string types, only if ::RECEIVER_INFO::n_str_type > 0
  GPS_PORT_INFO_IDX,            ///< (r--) ::PORT_INFO_IDX, serial port settings and capabilities, only if ::RECEIVER_INFO::n_com_ports > 0
  GPS_PORT_SETTINGS_IDX,        ///< (rw-) ::PORT_SETTINGS_IDX, settings for specified serial port, only if ::RECEIVER_INFO::n_com_ports > 0
  GPS_POUT_INFO_IDX,            ///< (r--) ::POUT_INFO_IDX, programmable pulse output settings and capabilities, only if ::RECEIVER_INFO::n_prg_out > 0
  GPS_POUT_SETTINGS_IDX,        ///< (rw-) ::POUT_SETTINGS_IDX, programmable pulse output settings, only if ::RECEIVER_INFO::n_prg_out > 0
  GPS_IRIG_TX_INFO,             ///< (r--) ::IRIG_INFO, only if ::GPS_HAS_IRIG_TX
  GPS_MULTI_REF_SETTINGS,       ///< (rw-) ::MULTI_REF_SETTINGS, only if ::GPS_HAS_MULTI_REF
  GPS_MULTI_REF_INFO,           ///< (r--) ::MULTI_REF_INFO, only if ::GPS_HAS_MULTI_REF
  GPS_ROM_CSUM,                 ///< (r--) ::ROM_CSUM, not supported by all devices
  GPS_MULTI_REF_STATUS,         ///< (r--) ::MULTI_REF_STATUS, only if ::GPS_HAS_MULTI_REF
  GPS_RCV_TIMEOUT,              ///< (rw-) ::RCV_TIMEOUT, [min], only if ::GPS_HAS_RCV_TIMEOUT
  GPS_IGNORE_LOCK,              ///< (rw-) ::IGNORE_LOCK, if != 0 always claim to be sync, only if ::GPS_MODEL_HAS_GPS_IGNORE_LOCK
  GPS_IRIG_RX_SETTINGS,         ///< (rw-) ::IRIG_SETTINGS, only if ::GPS_HAS_IRIG_RX
  GPS_IRIG_RX_INFO,             ///< (r--) ::IRIG_INFO, only if ::GPS_HAS_IRIG_RX
  GPS_REF_OFFS,                 ///< (rw-) ::MBG_REF_OFFS, only if ::GPS_HAS_REF_OFFS
  GPS_DEBUG_STATUS,             ///< (r--) ::MBG_DEBUG_STATUS, only if ::GPS_HAS_DEBUG_STATUS
  GPS_XMR_SETTINGS_IDX,         ///< (rw-) ::XMULTI_REF_SETTINGS_IDX, idx 0..::XMULTI_REF_INSTANCES::n_xmr_settings-1, only if ::GPS_HAS_XMULTI_REF
  GPS_XMR_INFO_IDX,             ///< (r--) ::XMULTI_REF_INFO_IDX, idx 0..::XMULTI_REF_INSTANCES::n_xmr_settings-1, only if ::GPS_HAS_XMULTI_REF
  GPS_XMR_STATUS_IDX,           ///< (r--) ::XMULTI_REF_STATUS_IDX, idx 0..::XMULTI_REF_INSTANCES::n_xmr_settings-1, only if ::GPS_HAS_XMULTI_REF
  GPS_OPT_SETTINGS,             ///< (rw-) ::MBG_OPT_SETTINGS, only if ::GPS_HAS_OPT_SETTINGS
  GPS_OPT_INFO,                 ///< (r--) ::MBG_OPT_INFO, only if ::GPS_HAS_OPT_SETTINGS
  GPS_CLR_UCAP_BUFF,            ///< (-w-) no data, only if ::RECEIVER_INFO::n_ucaps > 0
  GPS_TIME_SCALE,               ///< (rw-) ::MBG_TIME_SCALE_SETTINGS/::MBG_TIME_SCALE_INFO, only if ::GPS_HAS_TIME_SCALE
  GPS_NAV_ENG_SETTINGS,         ///< (rw-) ::NAV_ENGINE_SETTINGS, only if ::GPS_HAS_NAV_ENGINE_SETTINGS
  GPS_RAW_IRIG_DATA,            ///< (r--) ::MBG_RAW_IRIG_DATA, only if ::GPS_HAS_RAW_IRIG_DATA
  GPS_GPIO_CFG_LIMITS,          ///< (r--) ::MBG_GPIO_CFG_LIMITS, only if ::GPS_HAS_GPIO
  GPS_GPIO_INFO_IDX,            ///< (r--) ::MBG_GPIO_INFO_IDX, settings and capabilities, only if ::GPS_HAS_GPIO
  GPS_GPIO_SETTINGS_IDX,        ///< (rw-) ::MBG_GPIO_SETTINGS_IDX, settings of a specific port, only if ::GPS_HAS_GPIO
  GPS_XMR_INSTANCES,            ///< (r--) ::XMULTI_REF_INSTANCES, only if ::GPS_HAS_XMRS_MULT_INSTC
  GPS_CLR_EVT_LOG,              ///< (-w-) no data, clear event log command, only if ::GPS_HAS_EVT_LOG
  GPS_NUM_EVT_LOG_ENTRIES,      ///< (r--) ::MBG_NUM_EVT_LOG_ENTRIES, num. of log entries, only if ::GPS_HAS_EVT_LOG
  GPS_FIRST_EVT_LOG_ENTRY,      ///< (r--) first/oldest ::MBG_EVT_LOG_ENTRY, only if ::GPS_HAS_EVT_LOG
  GPS_NEXT_EVT_LOG_ENTRY,       ///< (r--) next ::MBG_EVT_LOG_ENTRY, only if ::GPS_HAS_EVT_LOG
  GPS_LNO_STATUS,               ///< (r--) ::LNO_STATE, only if ::GPS_MODEL_IS_LNO
  GPS_IMS_STATE,                ///< (r--) ::MBG_IMS_STATE, only if ::GPS_HAS_IMS
  GPS_IMS_SENSOR_STATE_IDX,     ///< (r--) ::MBG_IMS_SENSOR_STATE_IDX, only if ::GPS_HAS_IMS
  GPS_XMR_HOLDOVER_INTV,        ///< (rw-) ::XMR_HOLDOVER_INTV, only if ::GPS_MODEL_HAS_XMR_HOLDOVER_INTV, see also ::GPS_XMR_HOLDOVER_STATUS
  GPS_HAVEQUICK_RX_SETTINGS,    ///< (rw-) ::HAVEQUICK_SETTINGS for input, only if ::GPS_HAS_HAVEQUICK
  GPS_HAVEQUICK_RX_INFO,        ///< (r--) ::HAVEQUICK_INFO for input, only if ::GPS_HAS_HAVEQUICK
  GPS_HAVEQUICK_TX_SETTINGS,    ///< (rw-) ::HAVEQUICK_SETTINGS for output, only if ::GPS_HAS_HAVEQUICK
  GPS_HAVEQUICK_TX_INFO,        ///< (r--) ::HAVEQUICK_INFO for output, only if ::GPS_HAS_HAVEQUICK
  GPS_PTP_CFG,                  ///< (rw-) ::PTP_CFG_INFO/::PTP_CFG_SETTINGS, only if ::GPS_HAS_PTP
  GPS_PTP_STATE,                ///< (r--) ::PTP_STATE, current PTP status, only if ::GPS_HAS_PTP
  GPS_PTP_UC_MASTER_CFG_LIMITS, ///< (r--) ::PTP_UC_MASTER_CFG_LIMITS, only if ::PTP_CFG_CAN_BE_UNICAST_SLAVE
  GPS_PTP_UC_MASTER_CFG,        ///< (rw-) ::PTP_UC_MASTER_INFO_IDX/::PTP_UC_MASTER_SETTINGS_IDX, only if ::PTP_CFG_CAN_BE_UNICAST_SLAVE
  GPS_NTP_GLB_CFG,              ///< (rw-) ::NTP_GLB_INFO/::NTP_GLB_SETTINGS, only if ::GPS_HAS_NTP
  GPS_NTP_CLNT_MODE_CFG,        ///< (rw-) ::NTP_CLNT_MODE_INFO/::NTP_CLNT_MODE_SETTINGS, only if ::NTP_MSK_ROLE_CLIENT
  GPS_NTP_SRV_MODE_CFG,         ///< (rw-) ::NTP_SRV_MODE_INFO/::NTP_SRV_MODE_SETTINGS, only if ::NTP_MSK_ROLE_SERVER
  GPS_NTP_PEER_SETTINGS_IDX,    ///< (rw-) ::NTP_PEER_SETTINGS_IDX, only if ???  //### TODO
  GPS_NTP_SYS_STATE,            ///< (r--) ::NTP_SYS_STATE, only if ???  //### TODO
  GPS_NTP_PEER_STATE_IDX,       ///< (r--) ::NTP_PEER_STATE_IDX, only if ???  //### TODO
  GPS_SHS,                      ///< (rw-) ::SHS_INFO/::SHS_SETTINGS, only if ::GPS_HAS_SHS
  GPS_SHS_STATUS,               ///< (r--) ::SHS_STATUS, only if ::GPS_HAS_SHS
  GPS_NET_GLB_CFG,              ///< (rw-) ::MBG_NET_GLB_CFG_INFO/::MBG_NET_GLB_CFG_SETTINGS, only if ::GPS_HAS_NET_CFG
  GPS_NET_DNS_SRVR,             ///< (rw-) ::MBG_IP_ADDR_IDX, DNS cfg., only if ::MBG_NET_GLB_CFG_INFO::n_supp_dns_srvr > 0
  GPS_NET_DNS_SRCH_DOM,         ///< (rw-) ::MBG_NET_NAME_IDX, DNS cfg., only if ::MBG_NET_GLB_CFG_INFO::n_supp_dns_srch_dom > 0
  GPS_NET_STAT_DNS_SRVR,        ///< (r--) ::MBG_IP_ADDR_IDX, DNS status, only if ::MBG_NET_GLB_CFG_INFO::n_supp_dns_srvr > 0
  GPS_NET_STAT_DNS_SRCH_DOM,    ///< (r--) ::MBG_NET_NAME_IDX, DNS status, only if ::MBG_NET_GLB_CFG_INFO::n_supp_dns_srch_dom > 0
  GPS_GNSS_SAT_INFO_IDX,        ///< (r--) ::GNSS_SAT_INFO_IDX, only if ::MBG_GNSS_FLAG_MSK_SAT_INFO_IDX_SUPP_SER, deprecates ::GPS_GNSS_SAT_INFO
  GPS_XMR_HOLDOVER_ELAPSED,     ///< (r--) ::XMR_HOLDOVER_INTV, elapsed time in holdover mode, only if ::GPS_MODEL_HAS_XMR_HOLDOVER_INTV, deprecated by ::GPS_XMR_HOLDOVER_STATUS
  GPS_GPIO_STATUS_IDX,          ///< (r--) ::MBG_GPIO_STATUS_IDX, only if ::MBG_GPIO_CFG_LIMIT_FLAG_MASK_STATUS_SUPP
  GPS_XMR_HOLDOVER_STATUS,      ///< (r--) ::XMR_HOLDOVER_STATUS, only if ::XMRIF_MSK_HOLDOVER_STATUS_SUPP, deprecates ::GPS_XMR_HOLDOVER_ELAPSED and partially ::GPS_XMR_HOLDOVER_INTV
  GPS_XBP_LIMITS,               ///< (r--) ::XBP_LIMITS, only if ::GPS_HAS_XBP
  GPS_XBP_NODE_LIMITS,          ///< (r--) ::XBP_NODE_LIMITS, only if ::XBP_FEAT_MASK_NODES is set in ::XBP_LIMITS::features
  GPS_XBP_NODE_INFO_IDX,        ///< (r--) ::XBP_NODE_INFO_IDX, 0..::XBP_NODE_LIMITS::node_count-1 instances can be retrieved
  GPS_FDM_OUTPUT_STATE_IDX,     ///< (r--) ::MBG_IMS_FDM_OUTPUT_STATE_IDX, only if ::MBG_IMS_STATE_FLAG_MSK_HAS_FDM is set in ::MBG_IMS_STATE::flags
  GPS_FDM_OUTPUT_SETTINGS_IDX,  ///< (rw-) ::MBG_IMS_FDM_OUTPUT_SETTINGS_IDX, only if ::MBG_IMS_STATE_FLAG_MSK_HAS_FDM is set in ::MBG_IMS_STATE::flags
  GPS_FDM_OUTPUT_INFO_IDX,      ///< (r--) ::MBG_IMS_FDM_OUTPUT_INFO, only if ::MBG_IMS_STATE_FLAG_MSK_HAS_FDM is set in ::MBG_IMS_STATE::flags
  GPS_FDM_LIMITS,               ///< (r--) ::MBG_IMS_FDM_LIMITS, only if ::MBG_IMS_STATE_FLAG_MSK_HAS_FDM is set in ::MBG_IMS_STATE::flags
  GPS_FDM_STATE,                ///< (r--) ::MBG_IMS_FDM_STATE, only if ::MBG_IMS_STATE_FLAG_MSK_HAS_FDM is set in ::MBG_IMS_STATE::flags
  GPS_FDM_SETTINGS,             ///< (rw-) ::MBG_IMS_FDM_SETTINGS, only if ::MBG_IMS_STATE_FLAG_MSK_HAS_FDM is set in ::MBG_IMS_STATE::flags
  GPS_FDM_INFO,                 ///< (r--) ::MBG_IMS_FDM_INFO, only if ::MBG_IMS_STATE_FLAG_MSK_HAS_FDM is set in ::MBG_IMS_STATE::flags
  GPS_XMR_EXT_SRC_INFO_IDX,     ///< (r--) ::XMR_EXT_SRC_INFO_IDX, only if ::XMRIF_MSK_EXT_SRC_INFO_SUPP
  GPS_FDM_FREQ,                 ///< (r--) ::MBG_GPIO_FREQ, only if ::MBG_IMS_STATE_FLAG_MSK_HAS_FDM is set in ::MBG_IMS_STATE::flags
  GPS_XFEATURES,                ///< (r--) ::MBG_XFEATURE_BUFFER, only if ::GPS_HAS_XFEATURE
  GPS_SAVE_CFG,                 ///< (-w-) no data, save current config as default, only if ::MBG_XFEATURE_SAVE_CFG
  GPS_XMR_STATS_IDX,            ///< (r--) ::XMR_STATS_IDX, only if ::XMR_EXT_SRC_FEAT_FLAG_MSK_STATS
  GPS_FDM_SET_TD,               ///< (-w-) ::NANO_TIME_64, set time deviation, only if ::MBG_IMS_FDM_FLAG_MASK_CAN_SET_TDEV
  GPS_LNE_LIMITS,               ///< (r--) ::MBG_LNE_LIMITS, LNE API capabilities, only if ::MBG_XFEATURE_LNE_API
  GPS_LNE_PORT_INFO_IDX,        ///< (r--) ::MBG_LNE_PORT_INFO_IDX, settings and capabilities of an LED, only if ::MBG_XFEATURE_LNE_API
  GPS_LNE_PORT_SETTINGS_IDX,    ///< (rw-) ::MBG_LNE_PORT_SETTINGS_IDX, settings of a specific LED, only if ::MBG_XFEATURE_LNE_API
  GPS_PWR_CTL,                  ///< (rw-) ::MBG_PWR_CTL, set or retrieve device power state, only if ::MBG_XFEATURE_PWR_CTL_API
  GPS_LED_LIMITS,               ///< (r--) ::MBG_LED_LIMITS, LED API capabilities, only if ::MBG_XFEATURE_LED_API
  GPS_LED_INFO_IDX,             ///< (r--) ::MBG_LED_INFO_IDX, settings and capabilities of an LED, only if ::MBG_XFEATURE_LED_API
  GPS_LED_SETTINGS_IDX,         ///< (rw-) ::MBG_LED_SETTINGS_IDX, settings of a specific LED, only if ::MBG_XFEATURE_LED_API
  GPS_EXT_SYS_INFO,             ///< (r--) ::MBG_EXT_SYS_INFO, extended revision information, only if ::MBG_XFEATURE_EXT_SYS_INFO
  GPS_TLV_INFO,                 ///< (r--) ::MBG_TLV_INFO, query information on which TLV stuff is supported, only if ::MBG_XFEATURE_TLV_API
  GPS_TLV_ANNOUNCE,             ///< (-w-) ::MBG_TLV_ANNOUNCE, send and announcement for a subsequent TLV, only if ::MBG_XFEATURE_TLV_API
  GPS_TLV_DATA,                 ///< (rw-) a binary data bufer to be sent/received, according to the previous announce msg, only if ::MBG_XFEATURE_TLV_API
  GPS_BEGIN_TRANSACTION,        ///< (-w-) no data, begin transaction and apply changes after ::GPS_END_TRANSACTION, only supp. if ::MBG_XFEATURE_TRANSACTIONS
  GPS_END_TRANSACTION,          ///< (-w-) no data, end transaction and apply changes, only supp. if ::MBG_XFEATURE_TRANSACTIONS
  GPS_REBOOT,                   ///< (-w-) no data, let the device reboot itself, only supp. if ::MBG_XFEATURE_REBOOT
  GPS_XMR_METRICS_IDX,          ///< (r--) ::GPS_XMR_METRICS_IDX, only if ::XMR_EXT_SRC_FEAT_FLAG_MSK_METRICS
  GPS_XMR_QL_INFO_IDX,          ///< (r--) ::XMR_QL_INFO, only if ::XMR_EXT_SRC_FEAT_FLAG_MSK_METRICS
  GPS_XMR_QL_SETTINGS_IDX,      ///< (-w-) ::XMR_QL_SETTINGS, only if ::XMR_EXT_SRC_FEAT_FLAG_MSK_METRICS
  GPS_CLK_RES_INFO,             ///< (r--) ::MBG_CLK_RES_INFO, only if ::MBG_XFEATURE_CLK_RES_INFO
  GPS_NET_INTF_LINK_IDX,        ///< (rw-) ::MBG_NET_INTF_LINK_INFO_IDX/::MBG_NET_INTF_LINK_SETTINGS_IDX, only if ::MBG_NET_GLB_SUPP_STAGE_2_MASK is set in ::MBG_NET_GLB_CFG_INFO::feat_flags
  GPS_NET_INTF_ADDR_IDX,        ///< (rw-) ::MBG_NET_INTF_ADDR_INFO_IDX/::MBG_NET_INTF_ADDR_SETTINGS_IDX, only if ::MBG_NET_GLB_SUPP_STAGE_2_MASK is set in ::MBG_NET_GLB_CFG_INFO::feat_flags
  GPS_NET_INTF_ROUTE_IDX,       ///< (rw-) ::MBG_NET_INTF_ROUTE_INFO_IDX/::MBG_NET_INTF_ROUTE_SETTINGS_IDX, only if ::MBG_NET_GLB_SUPP_STAGE_2_MASK is set in ::MBG_NET_GLB_CFG_INFO::feat_flags
  GPS_NET_STAT_GLB_CFG,         ///< (r--) ::MBG_NET_GLB_CFG_INFO, network status, only if ::MBG_NET_GLB_SUPP_STAGE_2_MASK is set in ::MBG_NET_GLB_CFG_INFO::feat_flags
  GPS_NET_STAT_INTF_LINK_IDX,   ///< (r--) ::MBG_NET_INTF_LINK_INFO_IDX, link status, only if ::MBG_NET_GLB_SUPP_STAGE_2_MASK is set in ::MBG_NET_GLB_CFG_INFO::feat_flags
  GPS_NET_STAT_INTF_ADDR_IDX,   ///< (r--) ::MBG_NET_INTF_ADDR_INFO_IDX, addr status, only if ::MBG_NET_GLB_SUPP_STAGE_2_MASK is set in ::MBG_NET_GLB_CFG_INFO::feat_flags
  GPS_NET_STAT_INTF_ROUTE_IDX,  ///< (r--) ::MBG_NET_INTF_ROUTE_INFO_IDX, route status, only if ::MBG_NET_GLB_SUPP_STAGE_2_MASK is set in ::MBG_NET_GLB_CFG_INFO::feat_flags
  GPS_UCAP_NET_GLB_INFO,        ///< (rw-) ::MBG_UCAP_NET_GLB_INFO/::MBG_UCAP_NET_GLB_SETTINGS, only supp. if ::MBG_XFEATURE_UCAP_NET is set in extended features
  GPS_UCAP_NET_RECV_INFO_IDX,   ///< (rw-) ::MBG_UCAP_NET_RECV_INFO_IDX/::MBG_UCAP_NET_RECV_SETTINGS_IDX, only supp. if ::MBG_XFEATURE_UCAP_NET is set in extended features
  GPS_IO_PORT_LIMITS,           ///< (r--) ::MBG_IO_PORT_LIMITS, only supp. if ::MBG_XFEATURE_IO_PORTS is set in extended features
  GPS_IO_PORT_SETTINGS_IDX,     ///< (-w-) ::MBG_IO_PORT_SETTINGS_IDX, only supp. if ::MBG_XFEATURE_IO_PORTS is set in extended features
  GPS_IO_PORT_INFO_IDX,         ///< (r--) ::MBG_IO_PORT_INFO_IDX, only supp. if ::MBG_XFEATURE_IO_PORTS is set in extended features and from 0..MBG_IO_PORT_LIMITS::num_ports - 1
  GPS_IO_PORT_TYPE_INFO_IDX,    ///< (r--) ::MBG_IO_PORT_TYPE_INFO_IDX, only supp. if ::MBG_XFEATURE_IO_PORTS is set in extended features and from 0..MMBG_IO_PORT_INFO::num_types - 1
  GPS_IO_PORT_STATUS_IDX,       ///< (r--) ::MBG_IO_PORT_STATUS_IDX, only supp. if ::MBG_XFEATURE_IO_PORTS is set in extended features and from 0..MBG_IO_PORT_LIMITS::num_ports - 1
  GPS_MONITORING_LIMITS,        ///< (r--) ::MBG_MONITORING_LIMITS, only supp. if ::MBG_XFEATURE_MONITORING is set in extended features
  GPS_SNMP_GLB,                 ///< (rw-) ::MBG_SNMP_GLB_INFO / ::MBG_SNMP_GLB_SETTINGS, only supp. if ::MBG_MONITORING_TYPE_MSK_SNMP is set in ::MBG_MONITORING_LIMITS::supp_types
  GPS_SNMP_V12_IDX,             ///< (rw-) ::MBG_SNMP_V12_INFO_IDX / ::MBG_SNMP_V12_SETTINGS_IDX, only supp. if ::MBG_SNMP_VERSION_MSK_V1 or :: MBG_SNMP_VERSION_MSK_V2 is set
                                ///<       in ::MBG_SNMP_GLB_INFO::supp_versions and from 0..::MBG_SNMP_GLB_INFO::num_v12_settings - 1
  GPS_SNMP_V12_TRAP_IDX,        ///< (rw-) ::MBG_SNMP_V12_TRAP_INFO_IDX / ::MBG_SNMP_V12_TRAP_SETTINGS_IDX, only supp. if ::MBG_SNMP_VERSION_MSK_V1 or :: MBG_SNMP_VERSION_MSK_V2c is set
                                ///<       in ::MBG_SNMP_GLB_INFO::supp_versions and from 0..::MBG_SNMP_GLB_INFO::num_v12_trap_receivers - 1
  GPS_SNMP_V3_IDX,              ///< (rw-) ::MBG_SNMP_V3_INFO_IDX / ::MBG_SNMP_V3_SETTINGS_IDX, only supp. if ::MBG_SNMP_VERSION_MSK_V3 is set in ::MBG_SNMP_GLB_INFO::supp_versions and from
                                ///<       0..::MBG_SNMP_GLB_INFO::num_v3_settings - 1
  GPS_SNMP_V3_TRAP_IDX,         ///< (rw-) ::MBG_SNMP_V3_TRAP_INFO_IDX / ::MBG_SNMP_V3_TRAP_SETTINGS_IDX, only supp. if ::MBG_SNMP_VERSION_MSK_V3 in ::MBG_SNMP_GLB_INFO::supp_versions and from
                                ///<       0..::MBG_SNMP_GLB_INFO::num_v3_trap_receivers - 1
  GPS_GNSS_SV_STATUS_IDX,       ///< (r--) ::GNSS_SV_STATUS_IDX, only supp. if ::MBG_GNSS_FLAG_MSK_HAS_SV_STATUS is set
  GPS_PTP_V2_DEFAULT_DS,        ///< (rw-) ::MBG_PTP_V2_DEFAULT_DATASET, only supp. if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
  GPS_PTP_V2_CURRENT_DS,        ///< (rw-) ::MBG_PTP_V2_CURRENT_DATASET, only supp. if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
  GPS_PTP_V2_PARENT_DS,         ///< (rw-) ::MBG_PTP_V2_PARENT_DATASET, only supp. if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
  GPS_PTP_V2_TIME_PROP_DS,      ///< (rw-) ::MBG_PTP_V2_TIME_PROPERTIES_DATASET, only supp. if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
  GPS_PTP_V2_PORT_DS_IDX,       ///< (rw-) ::MBG_PTP_V2_PORT_DATASET_IDX, only supp. if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
  GPS_MONITORING_STATUS,        ///< (r--) ::MBG_MONITORING_STATUS, only supp. if ::MBG_MONITORING_TYPE_MSK_SNMP is set in ::MBG_MONITORING_LIMITS::supp_types
  GPS_EVENT_IDX,                ///< (rw-) ::MBG_EVENT_INFO_IDX / ::MBG_EVENT_SETTINGS_IDX, only supp. if ::MBG_XFEATURE_MONITORING is set in extended features
  GPS_EVENT_STAT_IDX,           ///< (r--) ::MBG_EVENT_STATUS_IDX, only supp. if ::MBG_XFEATURE_MONITORING is set in extended features
  GPS_NTP_REFCLK_CFG,           ///< (rw-) ::MBG_NTP_REFCLK_CFG_INFO_IDX only if NTP_SRV_MODE_SETTINGS::num_refclks > 0
  GPS_NTP_MISC_LIMITS,          ///< (r--) ::MBG_NTP_MISC_LIMITS ONLY if NTP_MSK_MISCELLANEOUS IS SET IN GPS_NTP_GLB_CFG::supp_flags
  GPS_NTP_MISC_ORPHAN_MODE,     ///< (rw-) ::MBG_NTP_MISC_ORPHAN_MODE_SETTINGS only if NTP_MISC_MSK_ORPHAN_MODE is set in GPS_NTP_MISC_LIMITS::supp_flags
  GPS_NTP_SYMM_KEY_LIMITS,      ///< (r--) ::MBG_GPS_NTP_SYMM_KEY_LIMITS only if NTP_MSK_SYMM_KEY is set in ::NTP_SRV_MODE_SETTINGS::supp_flags
  GPS_NTP_SYMM_KEY_CFG,         ///< (rw-) ::MBG_GPS_NTP_SYMM_KEY_CFG only if NTP_MSK_SYMM_KEY is set in ::NTP_SRV_MODE_SETTINGS::supp_flags
  GPS_NTP_TRUSTED_KEY_CFG,      ///< (rw-) ::MBG_GPS_NTP_TRUSTED_KEY_CFG only if GPS_NTP_GLB_CFG::max_trusted_keys > 0
  GPS_PTP_V1_DEFAULT_DS,        ///< (rw-) ::MBG_PTP_V1_DEFAULT_DATASET, only supp. if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
  GPS_PTP_V1_CURRENT_DS,        ///< (rw-) ::GPS_PTP_V1_CURRENT_DS, only supp. if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
  GPS_PTP_V1_PARENT_DS,         ///< (rw-) ::GPS_PTP_V1_PARENT_DS, only supp. if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
  GPS_PTP_V1_TIME_PROP_DS,      ///< (rw-) ::GPS_PTP_V1_TIME_PROP_DS, only supp. if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
  GPS_PTP_V1_PORT_DS_IDX,       ///< (rw-) ::GPS_PTP_V1_PORT_DS_IDX, only supp. if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
  GPS_USB_LOCK_INFO,            ///< (rw-) ::MBG_USB_LOCK_INFO / ::MBG_USB_LOCK_SETTINGS, only supp. if ::MBG_XFEATURE_USB_LOCK is set in ::MBG_XFEATURE_BUFFER
  GPS_USB_LOCK_STATUS,          ///< (r--) ::MBG_USB_LOCK_STATUS, only supp. if ::MBG_XFEATURE_USB_LOCK is set in ::MBG_XFEATURE_BUFFER

  /* GPS data */
  GPS_CFGH = 0x100,             ///< (rw-) ::CFGH, SVs' configuration and health codes
  GPS_ALM,                      ///< (rw-) req: uint16_t SV num, ::SV_ALM, one SV's almanac
  GPS_EPH,                      ///< (rw-) req: uint16_t SV num, ::SV_EPH, one SV's ephemeris
  GPS_UTC,                      ///< (rw-) ::UTC, GPS %UTC correction parameters
  GPS_IONO,                     ///< (rw-) ::IONO, GPS ionospheric correction parameters
  GPS_ASCII_MSG,                ///< (r--) ::ASCII_MSG, the GPS ASCII message

  /* Glonass data */
  GPS_GLNS_ALM = 0x200,         ///< (rw-) ** preliminary **  //##++
  GPS_GNSS_SAT_INFO,            ///< (r--) ::GNSS_SAT_INFO, GLONASS-only satellite info (deprecated by ::GPS_GNSS_SAT_INFO_IDX)
  GPS_GNSS_MODE,                ///< (rw-) ::MBG_GNSS_MODE_INFO/::MBG_GNSS_MODE_SETTINGS, GNSS operation mode
  // Warning:
  // The next numbers in range 0x200 are reserved

  /* Misc data */
  GPS_IP4_SETTINGS = 0x800,     ///< (rw-) ::IP4_SETTINGS, only if ::GPS_HAS_LAN_IP4
  GPS_LAN_IF_INFO,              ///< (r--) ::LAN_IF_INFO, only if ::GPS_HAS_LAN_IP4
  GPS_IP4_STATE,                ///< (r--) ::IP4_SETTINGS, only if ::GPS_HAS_LAN_IP4


  /* misc data (SCU) */
  GPS_SCU_STAT = 0x820,         ///< (rwa) ::SCU_STAT_SETTINGS/::SCU_STAT_INFO, SCU board control, only if ::GPS_MODEL_IS_SCU

  GPS_CRYPTED_PACKET = 0x880,   ///< (rwa) encrypted binary packet
  GPS_CRYPTED_RAW_PACKET,       ///< (rwa) encrypted binary raw packet
  GPS_XBP_PACKET,               ///< (rwa) eXtended Binary Packet, only if ::GPS_HAS_XBP, see @ref group_xbp

  GPS_SECU_INFO = 0x900,        ///< (r--) encryption method for LAN interface
  GPS_SECU_SETTINGS,            ///< (rw-) reserved for public key LAN interface
  GPS_SECU_PUBLIC_KEY,          ///< (---) settings and password for LAN interface

  /* PZF data */
  PZF_PCPS_TIME = 0xA00,        ///< (rw-) ::PCPS_TIME, date/time/status, only if ::GPS_MODEL_IS_DCF_PZF
  PZF_TR_DISTANCE,              ///< (rw-) ::TR_DISTANCE, dist. from transmitter [km], only if ::GPS_MODEL_IS_DCF_PZF
  PZF_TZCODE,                   ///< (rw-) ::TZCODE, time zone code, only if ::GPS_MODEL_IS_DCF_PZF
  PZF_CORR_INFO,                ///< (r--) ::CORR_INFO, correlation info, only if ::GPS_MODEL_IS_DCF_PZF

#if defined( _PRELIMINARY_CODE )
  // Temp. test codes, not for release!!!
  // Code still need to be added to GPS_CMD_CODES_TABLE
  // *Don't* make these codes #if _USE_TIME_MON only!!
  GPS_TIME_MON_INST_INFO,               ///< (rw-) ::MBG_TIME_MON_INST_INFO
  GPS_TIME_MON_TARGET_SETTINGS,         ///< (-w-) ::MBG_TIME_MON_TARGET_SETTINGS
  GPS_TIME_MON_TARGET_STATUS_IDX,       ///< (r--) ::MBG_TIME_MON_TARGET_STATUS_IDX
  GPS_TIME_MON_TARGET_EXT_DATA_SET_IDX, ///< (r--) ::MBG_TIME_MON_TARGET_EXT_DATA_SET_IDX
#endif  // defined( _PRELIMINARY_CODE )


};


#if !defined( MBG_TGT_DOS )

/**
 * @brief An initializer for a table of code/name entries of ::GPS_CMD_CODES
 *
 * This can e.g. be assigned to an array of ::MBG_CODE_NAME_TABLE_ENTRY elements
 * and may be helpful when debugging.
 *
 * @see ::GPS_CMD_CODES
 */
#define GPS_CMD_CODES_TABLE                            \
{                                                      \
  _mbg_cn_table_entry( GPS_WILDCARD ),                 \
  _mbg_cn_table_entry( GPS_AUTO_ON ),                  \
  _mbg_cn_table_entry( GPS_AUTO_OFF ),                 \
  _mbg_cn_table_entry( GPS_SW_REV ),                   \
  _mbg_cn_table_entry( GPS_BVAR_STAT ),                \
  _mbg_cn_table_entry( GPS_TIME ),                     \
  _mbg_cn_table_entry( GPS_POS_XYZ ),                  \
  _mbg_cn_table_entry( GPS_POS_LLA ),                  \
  _mbg_cn_table_entry( GPS_TZDL ),                     \
  _mbg_cn_table_entry( GPS_PORT_PARM ),                \
  _mbg_cn_table_entry( GPS_SYNTH ),                    \
  _mbg_cn_table_entry( GPS_ANT_INFO ),                 \
  _mbg_cn_table_entry( GPS_UCAP ),                     \
  _mbg_cn_table_entry( GPS_ENABLE_FLAGS ),             \
  _mbg_cn_table_entry( GPS_STAT_INFO ),                \
  _mbg_cn_table_entry( GPS_SWITCH_PARMS ),             \
  _mbg_cn_table_entry( GPS_STRING_PARMS ),             \
  _mbg_cn_table_entry( GPS_ANT_CABLE_LENGTH ),         \
  _mbg_cn_table_entry( GPS_SYNC_OUTAGE_DELAY ),        \
  _mbg_cn_table_entry( GPS_PULSE_INFO ),               \
  _mbg_cn_table_entry( GPS_OPT_FEATURES ),             \
  _mbg_cn_table_entry( GPS_IRIG_TX_SETTINGS ),         \
  _mbg_cn_table_entry( GPS_RECEIVER_INFO ),            \
  _mbg_cn_table_entry( GPS_STR_TYPE_INFO_IDX ),        \
  _mbg_cn_table_entry( GPS_PORT_INFO_IDX ),            \
  _mbg_cn_table_entry( GPS_PORT_SETTINGS_IDX ),        \
  _mbg_cn_table_entry( GPS_POUT_INFO_IDX ),            \
  _mbg_cn_table_entry( GPS_POUT_SETTINGS_IDX ),        \
  _mbg_cn_table_entry( GPS_IRIG_TX_INFO ),             \
  _mbg_cn_table_entry( GPS_MULTI_REF_SETTINGS ),       \
  _mbg_cn_table_entry( GPS_MULTI_REF_INFO ),           \
  _mbg_cn_table_entry( GPS_ROM_CSUM ),                 \
  _mbg_cn_table_entry( GPS_MULTI_REF_STATUS ),         \
  _mbg_cn_table_entry( GPS_RCV_TIMEOUT ),              \
  _mbg_cn_table_entry( GPS_IGNORE_LOCK ),              \
  _mbg_cn_table_entry( GPS_IRIG_RX_SETTINGS ),         \
  _mbg_cn_table_entry( GPS_IRIG_RX_INFO ),             \
  _mbg_cn_table_entry( GPS_REF_OFFS ),                 \
  _mbg_cn_table_entry( GPS_DEBUG_STATUS ),             \
  _mbg_cn_table_entry( GPS_XMR_SETTINGS_IDX ),         \
  _mbg_cn_table_entry( GPS_XMR_INFO_IDX ),             \
  _mbg_cn_table_entry( GPS_XMR_STATUS_IDX ),           \
  _mbg_cn_table_entry( GPS_OPT_SETTINGS ),             \
  _mbg_cn_table_entry( GPS_OPT_INFO ),                 \
  _mbg_cn_table_entry( GPS_CLR_UCAP_BUFF ),            \
  _mbg_cn_table_entry( GPS_TIME_SCALE ),               \
  _mbg_cn_table_entry( GPS_NAV_ENG_SETTINGS ),         \
  _mbg_cn_table_entry( GPS_RAW_IRIG_DATA ),            \
  _mbg_cn_table_entry( GPS_GPIO_CFG_LIMITS ),          \
  _mbg_cn_table_entry( GPS_GPIO_INFO_IDX ),            \
  _mbg_cn_table_entry( GPS_GPIO_SETTINGS_IDX ),        \
  _mbg_cn_table_entry( GPS_XMR_INSTANCES ),            \
  _mbg_cn_table_entry( GPS_CLR_EVT_LOG ),              \
  _mbg_cn_table_entry( GPS_NUM_EVT_LOG_ENTRIES ),      \
  _mbg_cn_table_entry( GPS_FIRST_EVT_LOG_ENTRY ),      \
  _mbg_cn_table_entry( GPS_NEXT_EVT_LOG_ENTRY ),       \
  _mbg_cn_table_entry( GPS_LNO_STATUS ),               \
  _mbg_cn_table_entry( GPS_IMS_STATE ),                \
  _mbg_cn_table_entry( GPS_IMS_SENSOR_STATE_IDX ),     \
  _mbg_cn_table_entry( GPS_XMR_HOLDOVER_INTV ),        \
  _mbg_cn_table_entry( GPS_HAVEQUICK_RX_SETTINGS ),    \
  _mbg_cn_table_entry( GPS_HAVEQUICK_RX_INFO ),        \
  _mbg_cn_table_entry( GPS_HAVEQUICK_TX_SETTINGS ),    \
  _mbg_cn_table_entry( GPS_HAVEQUICK_TX_INFO ),        \
  _mbg_cn_table_entry( GPS_PTP_CFG ),                  \
  _mbg_cn_table_entry( GPS_PTP_STATE ),                \
  _mbg_cn_table_entry( GPS_PTP_UC_MASTER_CFG_LIMITS ), \
  _mbg_cn_table_entry( GPS_PTP_UC_MASTER_CFG ),        \
  _mbg_cn_table_entry( GPS_NTP_GLB_CFG ),              \
  _mbg_cn_table_entry( GPS_NTP_CLNT_MODE_CFG ),        \
  _mbg_cn_table_entry( GPS_NTP_SRV_MODE_CFG ),         \
  _mbg_cn_table_entry( GPS_NTP_PEER_SETTINGS_IDX ),    \
  _mbg_cn_table_entry( GPS_NTP_SYS_STATE ),            \
  _mbg_cn_table_entry( GPS_NTP_PEER_STATE_IDX ),       \
  _mbg_cn_table_entry( GPS_SHS ),                      \
  _mbg_cn_table_entry( GPS_SHS_STATUS ),               \
  _mbg_cn_table_entry( GPS_NET_GLB_CFG ),              \
  _mbg_cn_table_entry( GPS_NET_DNS_SRVR ),             \
  _mbg_cn_table_entry( GPS_NET_DNS_SRCH_DOM ),         \
  _mbg_cn_table_entry( GPS_NET_STAT_DNS_SRVR ),        \
  _mbg_cn_table_entry( GPS_NET_STAT_DNS_SRCH_DOM ),    \
  _mbg_cn_table_entry( GPS_GNSS_SAT_INFO_IDX ),        \
  _mbg_cn_table_entry( GPS_XMR_HOLDOVER_ELAPSED ),     \
  _mbg_cn_table_entry( GPS_GPIO_STATUS_IDX ),          \
  _mbg_cn_table_entry( GPS_XMR_HOLDOVER_STATUS ),      \
  _mbg_cn_table_entry( GPS_XBP_LIMITS ),               \
  _mbg_cn_table_entry( GPS_XBP_NODE_LIMITS ),          \
  _mbg_cn_table_entry( GPS_XBP_NODE_INFO_IDX ),        \
  _mbg_cn_table_entry( GPS_FDM_OUTPUT_STATE_IDX ),     \
  _mbg_cn_table_entry( GPS_FDM_OUTPUT_SETTINGS_IDX ),  \
  _mbg_cn_table_entry( GPS_FDM_OUTPUT_INFO_IDX ),      \
  _mbg_cn_table_entry( GPS_FDM_LIMITS ),               \
  _mbg_cn_table_entry( GPS_FDM_STATE ),                \
  _mbg_cn_table_entry( GPS_FDM_SETTINGS ),             \
  _mbg_cn_table_entry( GPS_FDM_INFO ),                 \
  _mbg_cn_table_entry( GPS_XMR_EXT_SRC_INFO_IDX ),     \
  _mbg_cn_table_entry( GPS_FDM_FREQ ),                 \
  _mbg_cn_table_entry( GPS_XFEATURES ),                \
  _mbg_cn_table_entry( GPS_SAVE_CFG ),                 \
  _mbg_cn_table_entry( GPS_XMR_STATS_IDX ),            \
  _mbg_cn_table_entry( GPS_FDM_SET_TD ),               \
  _mbg_cn_table_entry( GPS_LNE_LIMITS ),               \
  _mbg_cn_table_entry( GPS_LNE_PORT_INFO_IDX ),        \
  _mbg_cn_table_entry( GPS_LNE_PORT_SETTINGS_IDX ),    \
  _mbg_cn_table_entry( GPS_PWR_CTL ),                  \
  _mbg_cn_table_entry( GPS_LED_LIMITS ),               \
  _mbg_cn_table_entry( GPS_LED_INFO_IDX ),             \
  _mbg_cn_table_entry( GPS_LED_SETTINGS_IDX ),         \
  _mbg_cn_table_entry( GPS_EXT_SYS_INFO ),             \
  _mbg_cn_table_entry( GPS_TLV_INFO ),                 \
  _mbg_cn_table_entry( GPS_TLV_ANNOUNCE ),             \
  _mbg_cn_table_entry( GPS_TLV_DATA ),                 \
  _mbg_cn_table_entry( GPS_BEGIN_TRANSACTION ),        \
  _mbg_cn_table_entry( GPS_END_TRANSACTION ),          \
  _mbg_cn_table_entry( GPS_REBOOT ),                   \
  _mbg_cn_table_entry( GPS_XMR_METRICS_IDX ),          \
  _mbg_cn_table_entry( GPS_XMR_QL_INFO_IDX ),          \
  _mbg_cn_table_entry( GPS_XMR_QL_SETTINGS_IDX ),      \
  _mbg_cn_table_entry( GPS_CLK_RES_INFO ),             \
  _mbg_cn_table_entry( GPS_NET_INTF_LINK_IDX ),        \
  _mbg_cn_table_entry( GPS_NET_INTF_ADDR_IDX ),        \
  _mbg_cn_table_entry( GPS_NET_INTF_ROUTE_IDX),        \
  _mbg_cn_table_entry( GPS_NET_STAT_GLB_CFG ),         \
  _mbg_cn_table_entry( GPS_NET_STAT_INTF_LINK_IDX ),   \
  _mbg_cn_table_entry( GPS_NET_STAT_INTF_ADDR_IDX),    \
  _mbg_cn_table_entry( GPS_NET_STAT_INTF_ROUTE_IDX),   \
  _mbg_cn_table_entry( GPS_UCAP_NET_GLB_INFO ),        \
  _mbg_cn_table_entry( GPS_UCAP_NET_RECV_INFO_IDX ),   \
  _mbg_cn_table_entry( GPS_IO_PORT_LIMITS ),           \
  _mbg_cn_table_entry( GPS_IO_PORT_SETTINGS_IDX ),     \
  _mbg_cn_table_entry( GPS_IO_PORT_INFO_IDX ),         \
  _mbg_cn_table_entry( GPS_IO_PORT_TYPE_INFO_IDX ),    \
  _mbg_cn_table_entry( GPS_IO_PORT_STATUS_IDX ),       \
  _mbg_cn_table_entry( GPS_MONITORING_LIMITS ),        \
  _mbg_cn_table_entry( GPS_SNMP_GLB ),                 \
  _mbg_cn_table_entry( GPS_SNMP_V12_IDX ),             \
  _mbg_cn_table_entry( GPS_SNMP_V12_TRAP_IDX ),        \
  _mbg_cn_table_entry( GPS_SNMP_V3_IDX ),              \
  _mbg_cn_table_entry( GPS_SNMP_V3_TRAP_IDX ),         \
  _mbg_cn_table_entry( GPS_GNSS_SV_STATUS_IDX ),       \
  _mbg_cn_table_entry( GPS_PTP_V2_DEFAULT_DS ),        \
  _mbg_cn_table_entry( GPS_PTP_V2_CURRENT_DS ),        \
  _mbg_cn_table_entry( GPS_PTP_V2_PARENT_DS ),         \
  _mbg_cn_table_entry( GPS_PTP_V2_TIME_PROP_DS ),      \
  _mbg_cn_table_entry( GPS_PTP_V2_PORT_DS_IDX ),       \
  _mbg_cn_table_entry( GPS_MONITORING_STATUS ),        \
  _mbg_cn_table_entry( GPS_EVENT_IDX ),                \
  _mbg_cn_table_entry( GPS_EVENT_STAT_IDX ),           \
  _mbg_cn_table_entry( GPS_NTP_REFCLK_CFG ),           \
  _mbg_cn_table_entry( GPS_NTP_MISC_LIMITS ),          \
  _mbg_cn_table_entry( GPS_NTP_MISC_ORPHAN_MODE ),     \
  _mbg_cn_table_entry( GPS_NTP_SYMM_KEY_LIMITS ),      \
  _mbg_cn_table_entry( GPS_NTP_SYMM_KEY_CFG ),         \
  _mbg_cn_table_entry( GPS_NTP_TRUSTED_KEY_CFG ),      \
  _mbg_cn_table_entry( GPS_PTP_V1_DEFAULT_DS ),        \
  _mbg_cn_table_entry( GPS_PTP_V1_CURRENT_DS ),        \
  _mbg_cn_table_entry( GPS_PTP_V1_PARENT_DS ),         \
  _mbg_cn_table_entry( GPS_PTP_V1_TIME_PROP_DS ),      \
  _mbg_cn_table_entry( GPS_PTP_V1_PORT_DS_IDX ),       \
  _mbg_cn_table_entry( GPS_USB_LOCK_INFO ),            \
  _mbg_cn_table_entry( GPS_USB_LOCK_STATUS ),          \
                                                       \
  /* GPS data */                                       \
  _mbg_cn_table_entry( GPS_CFGH ),                     \
  _mbg_cn_table_entry( GPS_ALM ),                      \
  _mbg_cn_table_entry( GPS_EPH ),                      \
  _mbg_cn_table_entry( GPS_UTC ),                      \
  _mbg_cn_table_entry( GPS_IONO ),                     \
  _mbg_cn_table_entry( GPS_ASCII_MSG ),                \
                                                       \
  /* Glonass data */                                   \
  _mbg_cn_table_entry( GPS_GLNS_ALM ),                 \
  _mbg_cn_table_entry( GPS_GNSS_SAT_INFO ),            \
  _mbg_cn_table_entry( GPS_GNSS_MODE ),                \
                                                       \
  /* Misc data */                                      \
  _mbg_cn_table_entry( GPS_IP4_SETTINGS ),             \
  _mbg_cn_table_entry( GPS_LAN_IF_INFO ),              \
  _mbg_cn_table_entry( GPS_IP4_STATE ),                \
                                                       \
  /* misc data (SCU) */                                \
  _mbg_cn_table_entry( GPS_SCU_STAT ),                 \
                                                       \
  _mbg_cn_table_entry( GPS_CRYPTED_PACKET ),           \
  _mbg_cn_table_entry( GPS_CRYPTED_RAW_PACKET ),       \
  _mbg_cn_table_entry( GPS_XBP_PACKET ),               \
                                                       \
  _mbg_cn_table_entry( GPS_SECU_INFO ),                \
  _mbg_cn_table_entry( GPS_SECU_SETTINGS ),            \
  _mbg_cn_table_entry( GPS_SECU_PUBLIC_KEY ),          \
                                                       \
  /* PZF data */                                       \
  _mbg_cn_table_entry( PZF_PCPS_TIME ),                \
  _mbg_cn_table_entry( PZF_TR_DISTANCE ),              \
  _mbg_cn_table_entry( PZF_TZCODE ),                   \
  _mbg_cn_table_entry( PZF_CORR_INFO ),                \
                                                       \
  _mbg_cn_table_end()                                  \
}

#endif  // !defined( MBG_TGT_DOS )


/**
 * @brief An SV number plus the SV's almanac data
 */
typedef struct
{
  SVNO svno;
  ALM alm;
} SV_ALM;


/**
 * @brief An SV number plus the SV's ephemeris data
 */
typedef struct
{
  SVNO svno;
  EPH eph;
} SV_EPH;



#if _USE_PCPSDEFS

/**
 * @brief Type of variable to hold a TZ code
 *
 * This is used with the binary protocol but differs from ::PCPS_TZCODE
 * which is used with the PCI interface.
 *
 * @see ::PCPS_TZCODE
 * @see ::TZCODE_UNION
 */
typedef uint16_t TZCODE;

#define _mbg_swab_tzcode( _p ) \
  _mbg_swab16( _p )


/**
 * @brief A union holding different types of a TZ code
 *
 * This is used with the binary protocol but differs from ::PCPS_TZCODE
 * which is used with the PCI interface.
 *
 * @see ::TZCODE
 * @see ::PCPS_TZCODE
 */
typedef union
{
  TZCODE ser;         ///< code retrieved via serial binary protocol
  PCPS_TZCODE pci;    ///< code retrieved via PCI bus

} TZCODE_UNION;

#endif



/**
 * @brief The header of a binary message.
 */
typedef struct
{
  GPS_CMD cmd;      ///< see ::GPS_CMD_CODES and ::GPS_CMD_CTRL_CODES
  uint16_t len;     ///< length of the data portion appended after the header
  CSUM data_csum;   ///< checksum of the data portion appended after the header
  CSUM hdr_csum;    ///< checksum of the preceding header bytes

} MSG_HDR;



/**
 * @brief A union of all data types used with the binary protocol.
 */
typedef union
{
  uint16_t u16;
  int16_t i16;
  uint16_t us;
  double d;
  SVNO svno;
  SW_REV sw_rev;
  BVAR_STAT bvar_stat;
  TTM ttm;
  XYZ xyz;
  LLA lla;
  TZDL tzdl;
  PORT_PARM port_parm;
  SYNTH synth;
  ANT_INFO ant_info;
  TTM ucap;
  ENABLE_FLAGS enable_flags;
  STAT_INFO stat_info;
  ANT_CABLE_LEN ant_cable_len;
  IRIG_SETTINGS irig_tx_settings;
  RECEIVER_INFO receiver_info;
  STR_TYPE_INFO_IDX str_type_info_idx;
  PORT_INFO_IDX port_info_idx;
  PORT_SETTINGS_IDX port_settings_idx;
  POUT_INFO_IDX pout_info_idx;
  POUT_SETTINGS_IDX pout_settings_idx;
  IRIG_INFO irig_tx_info;
  MULTI_REF_SETTINGS multi_ref_settings;
  MULTI_REF_INFO multi_ref_info;
  ROM_CSUM rom_csum;
  MULTI_REF_STATUS multi_ref_status;
  RCV_TIMEOUT rcv_timeout;
  IGNORE_LOCK ignore_lock;
  IRIG_SETTINGS irig_rx_settings;
  IRIG_INFO irig_rx_info;
  MBG_REF_OFFS ref_offs;
  MBG_DEBUG_STATUS debug_status;
  XMULTI_REF_SETTINGS_IDX xmulti_ref_settings_idx;
  XMULTI_REF_INFO_IDX xmulti_ref_info_idx;
  XMULTI_REF_STATUS_IDX xmulti_ref_status_idx;
  MBG_OPT_SETTINGS opt_settings;
  MBG_OPT_INFO opt_info;
  MBG_TIME_SCALE_INFO time_scale_info;
  MBG_TIME_SCALE_SETTINGS time_scale_settings;
  NAV_ENGINE_SETTINGS nav_engine_settings;
  MBG_RAW_IRIG_DATA raw_irig_data;
  GNSS_SAT_INFO gnss_sat_info;                    //##++++++
  MBG_GNSS_MODE_INFO gnss_mode_info;              //##++++++
  MBG_GNSS_MODE_SETTINGS gnss_mode_settings;      //##++++++
  MBG_GPIO_CFG_LIMITS gpio_cfg_limits;
  MBG_GPIO_INFO_IDX gpio_info_idx;
  MBG_GPIO_SETTINGS_IDX gpio_settings_idx;
  XMULTI_REF_INSTANCES xmulti_ref_instances;
  MBG_NUM_EVT_LOG_ENTRIES num_evt_log_entries;
  MBG_EVT_LOG_ENTRY evt_log_entry;
  LNO_STATE lno_state;
  MBG_IMS_STATE ims_state;
  MBG_IMS_SENSOR_STATE_IDX ims_sensor_state_idx;
  XMR_HOLDOVER_INTV xmr_holdover_intv;
  HAVEQUICK_SETTINGS havequick_settings;
  HAVEQUICK_INFO havequick_info;
  PTP_CFG_INFO ptp_cfg_info;
  PTP_CFG_SETTINGS ptp_cfg_settings;
  PTP_STATE ptp_state;
  PTP_UC_MASTER_CFG_LIMITS ptp_uc_master_cfg_limits;
  PTP_UC_MASTER_INFO_IDX ptp_uc_master_info_idx;
  PTP_UC_MASTER_SETTINGS_IDX ptp_uc_master_settings_idx;
  NTP_GLB_INFO ntp_glb_info;
  NTP_GLB_SETTINGS ntp_glb_settings;
  NTP_CLNT_MODE_INFO ntp_clnt_mode_info;
  NTP_CLNT_MODE_SETTINGS ntp_clnt_mode_settings;
  NTP_SRV_MODE_INFO ntp_srv_mode_info;
  NTP_SRV_MODE_SETTINGS ntp_srv_mode_settings;
  NTP_PEER_SETTINGS_IDX ntp_peer_settings_idx;
  NTP_SYS_STATE ntp_sys_state;
  NTP_PEER_STATE_IDX ntp_peer_state_idx;
  SHS_INFO shs_info;
  SHS_SETTINGS shs_settings;
  SHS_STATUS shs_status;
  MBG_NET_GLB_CFG_INFO net_glb_cfg_info;
  MBG_NET_GLB_CFG_SETTINGS net_glb_cfg_settings;
  MBG_IP_ADDR_IDX ip_addr_idx;
  MBG_NET_NAME_IDX net_name_idx;
  MBG_NET_INTF_LINK_INFO_IDX net_intf_link_info_idx;
  MBG_NET_INTF_LINK_SETTINGS_IDX net_intf_link_settings_idx;
  MBG_NET_INTF_ADDR_INFO_IDX net_intf_addr_info_idx;
  MBG_NET_INTF_ADDR_SETTINGS_IDX net_intf_addr_settings_idx;
  MBG_NET_INTF_ROUTE_INFO_IDX net_intf_route_info_idx;
  MBG_NET_INTF_ROUTE_SETTINGS_IDX net_intf_route_settings_idx;
  GNSS_SAT_INFO_IDX gnss_sat_info_idx;
  MBG_GPIO_STATUS_IDX gpio_status_idx;
  XMR_HOLDOVER_STATUS xmr_holdover_status;
  XBP_LIMITS xbp_limits;
  XBP_NODE_LIMITS xbp_node_limits;
  XBP_NODE_INFO_IDX xbp_node_info_idx;
  MBG_IMS_FDM_OUTPUT_STATE_IDX fdm_output_state_idx;
  MBG_IMS_FDM_OUTPUT_SETTINGS_IDX fdm_output_settings_idx;
  MBG_IMS_FDM_OUTPUT_INFO_IDX fdm_output_info_idx;
  MBG_IMS_FDM_LIMITS fdm_limits;
  MBG_IMS_FDM_STATE fdm_state;
  MBG_IMS_FDM_SETTINGS fdm_settings;
  MBG_IMS_FDM_INFO fdm_info;
  XMR_EXT_SRC_INFO_IDX xmr_ext_src_info_idx;
  MBG_GPIO_FREQ fdm_freq;
  MBG_XFEATURE_BUFFER xfeature_buffer;
  XMR_STATS_IDX xmr_stats_idx;
  NANO_TIME_64 nano_time_64;
  MBG_LNE_LIMITS lne_limits;
  MBG_LNE_PORT_INFO_IDX lne_port_info_idx;
  MBG_LNE_PORT_SETTINGS_IDX lne_port_settings_idx;
  MBG_PWR_CTL pwr_ctl;
  MBG_LED_LIMITS led_limits;
  MBG_LED_INFO_IDX led_info_idx;
  MBG_LED_SETTINGS_IDX led_settings_idx;
  MBG_EXT_SYS_INFO ext_sys_info;
  MBG_TLV_INFO tlv_info;
  MBG_TLV_ANNOUNCE tlv_announce;
  MBG_TLV tlv;

  XMR_METRICS_IDX xmr_metrics_idx;
  XMR_QL_INFO_IDX xmr_ql_info_idx;
  XMR_QL_SETTINGS_IDX xmr_ql_settings_idx;

  MBG_CLK_RES_INFO mbg_clk_res_info;

  MBG_UCAP_NET_GLB_INFO ucap_net_glb_info;
  MBG_UCAP_NET_GLB_SETTINGS ucap_net_glb_settings;
  MBG_UCAP_NET_RECV_INFO_IDX ucap_net_recv_info_idx;
  MBG_UCAP_NET_RECV_SETTINGS_IDX ucap_net_recv_settings_idx;

  MBG_IO_PORT_LIMITS iop_limits;
  MBG_IO_PORT_SETTINGS_IDX iop_settings_idx;
  MBG_IO_PORT_INFO_IDX iop_info_idx;
  MBG_IO_PORT_TYPE_INFO_IDX iop_type_info_idx;
  MBG_IO_PORT_STATUS_IDX iop_status_idx;

  MBG_MONITORING_LIMITS monitoring_limits;
  MBG_SNMP_GLB_SETTINGS snmp_glb_settings;
  MBG_SNMP_GLB_INFO snmp_glb_info;
  MBG_SNMP_V12_SETTINGS_IDX snmp_v12_settings_idx;
  MBG_SNMP_V12_INFO_IDX snmp_v12_info_idx;
  MBG_SNMP_V12_TRAP_SETTINGS_IDX snmp_v12_trap_settings_idx;
  MBG_SNMP_V12_TRAP_INFO_IDX snmp_v12_trap_info_idx;
  MBG_SNMP_V3_SETTINGS_IDX snmp_v3_settings_idx;
  MBG_SNMP_V3_INFO_IDX snmp_v3_info_idx;
  MBG_SNMP_V3_TRAP_SETTINGS_IDX snmp_v3_trap_settings_idx;
  MBG_SNMP_V3_TRAP_INFO_IDX snmp_v3_trap_info_idx;

  GNSS_SV_STATUS_IDX gnss_sv_status_idx;

  MBG_PTP_V2_DEFAULT_DATASET ptp_v2_default_dataset;
  MBG_PTP_V2_CURRENT_DATASET ptp_v2_current_dataset;
  MBG_PTP_V2_PARENT_DATASET ptp_v2_parent_dataset;
  MBG_PTP_V2_TIME_PROPERTIES_DATASET ptp_v2_time_properties_dataset;
  MBG_PTP_V2_PORT_DATASET_IDX ptp_v2_port_dataset_idx;

  MBG_MONITORING_STATUS monitoring_status;
  MBG_EVENT_INFO_IDX event_info_idx;
  MBG_EVENT_SETTINGS_IDX event_settings_idx;
  MBG_EVENT_STATUS_IDX event_status_idx;

  NTP_SYMM_KEY_LIMITS ntp_symm_key_limits;
  NTP_SYMM_KEY_INFO_IDX ntp_symm_key_info_idx;
  NTP_SYMM_KEY_SETTINGS_IDX ntp_symm_key_settings_idx;
  NTP_TRUSTED_KEY_INFO_IDX ntp_trusted_key_info_idx;
  NTP_TRUSTED_KEY_SETTINGS_IDX ntp_trusted_key_settings_idx;
  NTP_REFCLK_CFG_INFO_IDX ntp_refclk_cfg_info_idx;
  NTP_REFCLK_CFG_SETTINGS_IDX ntp_refclk_cfg_settings_idx;
  NTP_MISC_LIMITS ntp_misc_limits;
  NTP_MISC_ORPHAN_MODE_INFO ntp_misc_orphan_mode_info;
  NTP_MISC_ORPHAN_MODE_SETTINGS ntp_misc_orphan_mode_settings;

  MBG_PTP_V1_DEFAULT_DATASET ptp_v1_default_dataset;
  MBG_PTP_V1_CURRENT_DATASET ptp_v1_current_dataset;
  MBG_PTP_V1_PARENT_DATASET ptp_v1_parent_dataset;
  MBG_PTP_V1_TIME_PROPERTIES_DATASET ptp_v1_time_properties_dataset;
  MBG_PTP_V1_PORT_DATASET_IDX ptp_v1_port_dataset_idx;

  MBG_USB_LOCK_INFO usb_lock_info;
  MBG_USB_LOCK_SETTINGS usb_lock_settings;
  MBG_USB_LOCK_STATUS usb_lock_status;

  //##++  PTP_POWER_PROFILE_CFG ptp_power_profile_cfg;  // no cmd code, yet.

  CFGH cfgh;
  SV_ALM sv_alm;
  SV_EPH sv_eph;
  UTC utc;
  IONO iono;
  ASCII_MSG ascii_msg;

  IP4_SETTINGS ip4_settings;
  LAN_IF_INFO lan_if_info;

  SCU_STAT_INFO scu_stat_info;
  SCU_STAT_SETTINGS scu_stat_settings;

#if _USE_PCPSDEFS
  PCPS_TIME pcps_time;
  TR_DISTANCE tr_distance;
  TZCODE tzcode;
  CORR_INFO corr_info;
#endif

#if _USE_ENCRYPTION
  SECU_SETTINGS secu_settings;
#endif

#if _USE_TIME_MON && defined( _PRELIMINARY_CODE )
  MBG_TIME_MON_INST_INFO time_mon_inst_info;
  MBG_TIME_MON_TARGET_SETTINGS time_mon_target_settings;
  MBG_TIME_MON_TARGET_STATUS_IDX time_mon_target_status_idx;
  MBG_TIME_MON_TARGET_EXT_DATA_SET_IDX time_mon_target_ext_data_set_idx;
#endif

#if _USE_GPSPRIV
  _mbg_gps_types_priv
#endif

} MSG_DATA;

/// The maximum number of bytes required for a ::MSG_DATA buffer
#ifndef MAX_MSG_DATA_SIZE
  #ifndef ADD_MSG_DATA_SIZE
    #if _USE_ENCRYPTION
      #define ADD_MSG_DATA_SIZE  AES_BLOCK_SIZE    // round up to full paragraphs
    #else
      #define ADD_MSG_DATA_SIZE  0
    #endif
  #endif

  #define MAX_MSG_DATA_SIZE   ( sizeof( MSG_DATA ) + ADD_MSG_DATA_SIZE )
#endif


/**
 * @brief A union of all data types used with the binary protocol, or array of bytes.
 *
 * This union can be used to implement a buffer which can hold either a known data structure
 * or an array of bytes which can be read from or written to a device.
 */
typedef union
{
  MSG_DATA msg_data;                  ///< union of known structures
  uint8_t bytes[MAX_MSG_DATA_SIZE];

} STD_MSG_DATA_BUFF;



/**
 * @brief The format of a standard binary message.
 */
typedef struct
{
  MSG_HDR hdr;                 ///< Message header containing the command code and length of the data portion
  STD_MSG_DATA_BUFF data_buf;  ///< Data portion using the number of bytes specified in the header

} MBG_STD_MSG;



/**
 * @brief The data portion of an XBP message.
 */
typedef struct
{
  XBP_ADDR xbp_addr;      ///< XBP address of the transmitter or receiver
  MBG_STD_MSG std_msg;    ///< Encapsulated standard binary message

} XBP_MSG_DATA;



/**
 * @brief A message header for the eXtended Binary Protocol (XBP)
 *
 * The data portion of such message is a standard binary message.
 * The ::MSG_HDR::len field in ::XBP_MSG_HDR::xbp_hdr must contain
 * the number of bytes following the xbp_hdr field, i.e. the length
 * of the whole encapsulated binary message plus the size of the
 * xbp_addr field.
 */
typedef struct
{
  MSG_HDR xbp_hdr;
  XBP_ADDR xpb_addr;

} XBP_MSG_HDR;



/**
 * @brief A message prefix used for encrypted messages
 */
typedef struct
{
  MSG_HDR hdr;

  #if _USE_ENCRYPTION
    uint8_t aes_initvect[AES_BLOCK_SIZE];
  #else
    // In this case this structure is just a dummy to avoid
    // a compiler error with the function prototypes.
  #endif

} CRYPT_MSG_PREFIX;



#if _USE_ENCRYPTION

/**
 * @brief A message data block used for encrypted messages
 */
typedef struct
{
  uint8_t aes_initvect[AES_BLOCK_SIZE];
  MBG_STD_MSG std_msg;

} CRYPT_MSG_DATA;

#endif



/**
 * @brief A buffer for a message header plus data part
 *
 * The data part has to be interpreted depending on the command code
 * in the message header field, hdr.
 */
typedef struct
{
  MSG_HDR hdr;   ///< The message header

  union
  {
    uint8_t bytes[MAX_MSG_DATA_SIZE];  ///< Data part as a number of bytes
    MSG_DATA msg_data;                 ///< Standard message data structures
    MBG_STD_MSG std_msg;               ///< Encapsulated standard message
    XBP_MSG_DATA xbp_msg_data;         ///< XBP address field plus encapsulated standard message

    #if _USE_ENCRYPTION
      CRYPT_MSG_DATA crypt_msg_data;   ///< Encryption data plus encrypted standard message
    #endif

  } u;

} MBG_MSG_BUFF;



/**
 * @brief A structure used to control the reception of binary messages
 */
typedef struct
{
  MBG_MSG_BUFF *pmb;      ///< points to unencrypted message buffer
  int buf_size;           ///< size of buffer, including header

  struct rcv_state
  {
    uint8_t *cur;           ///< points to current pos inside receive buffer
    int cnt;                ///< the number of bytes to be received
    ulong flags;            ///< flags if header already completed, etc., see ::MBG_MSG_RCV_CTL_MASKS
    #if _USE_RCV_TSTAMP
      MBG_TMO_TIME tstamp;  ///< time when the first byte of the packet was received
    #endif
  } rcv_state;

  #if _USE_MBG_TSTR
    MBG_TSTR_RCV_FNC *tstr_rcv_fnc;  ///< optional handler for normal, non-protocol data
    MBG_TSTR_RCV_ARG *tstr_rcv_arg;  ///< arguments for the non-protocol data handler
  #endif

} MBG_MSG_RCV_CTL;



/**
 * @brief Receive control bits used to define ::MBG_MSG_RCV_CTL_MASKS
 *
 * @see ::MBG_MSG_RCV_CTL_MASKS
 */
enum MBG_MSG_RCV_CTL_BITS
{
  MBG_MSG_RCV_CTL_BIT_RCVD_HDR,
  MBG_MSG_RCV_CTL_BIT_MSG_TOO_LONG,
  MBG_MSG_RCV_CTL_BIT_OVERFLOW,
  MBG_MSG_RCV_CTL_BIT_DECRYPT_ERR,
  MBG_MSG_RCV_CTL_BIT_DECRYPTED,
  N_MBG_MSG_RCV_CTL_BIT
};

/**
 * @brief Receive control bit masks
 *
 * Used with ::MBG_MSG_RCV_CTL::rcv_state::flags
 *
 * @see ::MBG_MSG_RCV_CTL_BITS
 */
enum MBG_MSG_RCV_CTL_MASKS
{
  MBG_MSG_RCV_CTL_RCVD_HDR     = ( 1UL << MBG_MSG_RCV_CTL_BIT_RCVD_HDR ),        ///< see ::MBG_MSG_RCV_CTL_BIT_RCVD_HDR
  MBG_MSG_RCV_CTL_MSG_TOO_LONG = ( 1UL << MBG_MSG_RCV_CTL_BIT_MSG_TOO_LONG ),    ///< see ::MBG_MSG_RCV_CTL_BIT_MSG_TOO_LONG
  MBG_MSG_RCV_CTL_OVERFLOW     = ( 1UL << MBG_MSG_RCV_CTL_BIT_OVERFLOW ),        ///< see ::MBG_MSG_RCV_CTL_BIT_OVERFLOW
  MBG_MSG_RCV_CTL_DECRYPT_ERR  = ( 1UL << MBG_MSG_RCV_CTL_BIT_DECRYPT_ERR ),     ///< see ::MBG_MSG_RCV_CTL_BIT_DECRYPT_ERR
  MBG_MSG_RCV_CTL_DECRYPTED    = ( 1UL << MBG_MSG_RCV_CTL_BIT_DECRYPTED )        ///< see ::MBG_MSG_RCV_CTL_BIT_DECRYPTED
};



/**
 * @brief A structure used to control the transmission of binary messages
 */
typedef struct
{
  MBG_MSG_BUFF *pmb;      ///< points to unencrypted message buffer
  int buf_size;           ///< size of buffer, including header
  int xfer_mode;          ///< transfer mode, see ::MBG_XFER_MODES

} MBG_MSG_XMT_CTL;



/**
 * @brief Binary message transfer modes
 *
 * Used with ::MBG_MSG_XMT_CTL::xfer_mode
 */
enum MBG_XFER_MODES
{
  MBG_XFER_MODE_NORMAL,     ///< normal, unencrypted transmission
  MBG_XFER_MODE_ENCRYPTED,  ///< encrypted transmission, usually over network
  N_MBG_XFER_MODE
};



#if _USE_SOCKET_IO

#if !defined( MBGEXTIO_MSG_TIMEOUT_SOCKET )
  #define MBGEXTIO_MSG_TIMEOUT_SOCKET    1000   // [ms]
#endif

#if !defined( MBGEXTIO_POLL_TIMEOUT_SOCKET )
  #define MBGEXTIO_POLL_TIMEOUT_SOCKET   200    // [ms]
#endif

#define LAN_XPT_PORT 10001



typedef struct
{
  MBG_SOCK_FD sockfd;
  struct sockaddr_in _addr;
  struct sockaddr_in *p_addr;
  socklen_t addrlen;
  ulong poll_timeout;

} SOCKET_IO_STATUS;

#endif  // _USE_SOCKET_IO


#if _USE_SERIAL_IO_FTDI

typedef struct
{
  FT_HANDLE port_handle;
  ulong poll_timeout;

} FTDI_DEV;

#endif  // _USE_SERIAL_IO_FTDI



#if _USE_USB_DIRECT_IO

typedef int MBG_USB_DIRECT_IO_FD;

#if !defined(MBG_USB_DIRECT_IO_INVALID_FD)
  #define MBG_USB_DIRECT_IO_INVALID_FD          -1
#endif

#if !defined( MBGEXTIO_POLL_TIMEOUT_USB_DIRECT_IO )
  #define MBGEXTIO_POLL_TIMEOUT_USB_DIRECT_IO    1000   // [ms]
#endif

#if !defined( MBGEXTIO_MSG_TIMEOUT_USB_DIRECT_IO )
  #define MBGEXTIO_MSG_TIMEOUT_USB_DIRECT_IO    1000   // [ms]
#endif

typedef struct
{
  MBG_USB_DIRECT_IO_FD usbdiofd;
  ulong poll_timeout;

} USB_DIRECT_IO_STATUS;

#endif // _USE_USB_DIRECT_IO



#if !_IS_MBG_FIRMWARE

struct MBG_MSG_CTL_s;

/**
 * @brief Message handler callback function pointer
 */
typedef int _MBG_API MBG_MSG_HANDLER( struct MBG_MSG_CTL_s *pmctl );

#endif  // !_IS_MBG_FIRMWARE



/**
 * @brief A generic message send and receive control structure
 */
typedef struct MBG_MSG_CTL_s
{
  MBG_MSG_RCV_CTL rcv;
  MBG_MSG_XMT_CTL xmt;

  ///< An optional error code received from a device with a NACK message
  ///< Use ::mbgextio_get_last_nack_err_code to retrieve the code
  ///< @todo This is probably not thread-safe.
  int nack_err_code;

  #if _USE_MUTEX
    MBG_MUTEX dev_mutex;    ///< Mutex to serialize device access
  #endif

  int conn_type;            ///< One of the ::MBG_CONN_TYPES
  uint32_t device_flags;                ///< See ::MSG_CTL_DEVICE_FLAG_MSKS
  ulong msg_rcv_timeout;    ///< Binary message receive timeout [ms]

  #if !_IS_MBG_FIRMWARE
    MBG_XDEV_FEATURES xdev_features;    ///< Receiver info plus extended device features
    MBG_MSG_HANDLER *msg_handler_fnc;   ///< See ::mbgextio_register_msg_callback

    /// While TLV messages are handled, this structure is used temporarily
    /// by some API functions to track the state of the TLV messages.
    MBG_TLV_RCV_STATE tlv_rcv_state;
  #endif

  #if _USE_ENCRYPTION
    uint8_t aes_initvect[AES_BLOCK_SIZE];
    uint8_t aes_keyvect[AES_BLOCK_SIZE];
  #endif

  #if _USE_SOCKET_IO
    SECU_SETTINGS secu_settings;
  #endif

  #if _USE_SERIAL_IO      || \
      _USE_SERIAL_IO_FTDI || \
      _USE_SOCKET_IO      || \
      _USE_USB_IO         || \
      _USE_USB_DIRECT_IO
    union st
    {
      #if _USE_SOCKET_IO
        SOCKET_IO_STATUS sockio;
      #endif

      #if _USE_SERIAL_IO
        MBGSERIO_DEV *p_serio;
      #endif

      #if _USE_SERIAL_IO_FTDI
        FTDI_DEV ftdi;
      #endif

      #if _USE_USB_IO
        MBGUSBIO_DEV usbio;
      #endif

      #if _USE_USB_DIRECT_IO
        USB_DIRECT_IO_STATUS usbdio;
      #endif
    } st;
  #endif

  #if defined( _DEBUG_MSG_TIMING )
    MBG_MSG_TIMES mt;
  #endif

} MBG_MSG_CTL;



/**
 * @brief Binary message connection types
 *
 * Used with ::MBG_MSG_CTL::conn_type
 */
enum MBG_CONN_TYPES
{
  MBG_CONN_TYPE_SERIAL,         ///< connection via serial port
  MBG_CONN_TYPE_SOCKET,         ///< connection via network socket
  MBG_CONN_TYPE_USB,            ///< connection via direct USB
  MBG_CONN_TYPE_SERIAL_FTDI,    ///< connection via FTDI D2xx USB-To-Serial converter
  MBG_CONN_TYPE_USB_DIRECT_IO,  ///< connection via direct USB I/O operation
  N_MBG_CONN_TYPE
};



/* function prototypes: */

#if _USE_GPSSERIO_FNC

/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 /**
 * @brief Translate a FTDI API status code to one of the @ref MBG_ERROR_CODES
 *
 * @param[in] status  A status code defined by the FTDI API interface
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 int mbg_ftdi_ft_status_to_mbg( FT_STATUS status ) ;

 /**
 * @brief Compute a simple binary checksum
 *
 * Compute a checksum about a number of bytes starting
 * with a given initial value.
 *
 * @param[in] csum  the initial value
 * @param[in] p     pointer to a buffer of data bytes
 * @param[in] n     the number of bytes in the buffer
 *
 * @return the computed checksum
 */
 CSUM msg_csum_update( CSUM csum, const uint8_t *p, int n ) ;

 /**
 * @brief Compute a checksum for a binary message
 *
 * @note This function differs from the checksum() function
 * used to compute the checksum of battery-buffered variables.
 *
 * @param[in] p  pointer to a buffer of data bytes
 * @param[in] n  the number of bytes in the buffer
 *
 * @return the computed checksum
 */
 CSUM msg_csum( const uint8_t *p, int n ) ;

 /**
 * @brief Compute the checksum of a binary message header
 *
 * @param[in] pmh  pointer to a binary message header
 *
 * @return the computed checksum
 */
 CSUM msg_hdr_csum( const MSG_HDR *pmh ) ;

 /**
 * @brief Check if the header checksum of a binary message is valid
 *
 * @param[in] pmh  pointer to a binary message header
 *
 * @return ::MBG_SUCCESS or ::MBG_ERR_HDR_CSUM
 */
 int chk_hdr_csum( const MSG_HDR *pmh ) ;

 /**
 * @brief Check if the data checksum of a binary message is valid
 *
 * @param[in] pmb  pointer to a binary message buffer
 *
 * @return ::MBG_SUCCESS or ::MBG_ERR_DATA_CSUM
 */
 int chk_data_csum( const MBG_MSG_BUFF *pmb ) ;

 /**
 * @brief Checks if a binary message header has been completely received
 *
 * @param[in]   prctl   ::MBG_MSG_RCV_CTL that shall be checked
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 int chk_hdr_rcvd( const MBG_MSG_RCV_CTL *prctl ) ;

 /**
 * @brief Encrypt a binary message
 *
 * In encryption mode the original packet is encrypted and put
 * as data portion into an envelope package.
 *
 * @param[in,out] pmctl Pointer to a valid message control structure
 * @param[in,out] pcmp  Pointer to encryption settings
 * @param[in,out] pmb   Pointer to a binary message buffer
 *
 * @return the number of bytes of the encrypted message, or one of the @ref MBG_ERROR_CODES
 */
 int encrypt_message( MBG_MSG_CTL *pmctl, CRYPT_MSG_PREFIX *pcmp, MBG_MSG_BUFF *pmb ) ;

 /**
 * @brief Decrypt an encrypted binary message
 *
 * @param[in,out] pmctl Pointer to a valid message control structure
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 int decrypt_message( MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Set communication channel to specified encryption mode
 *
 * @param[in,out] pmctl Pointer to a valid message control structure
 * @param[in]     mode  Encryption mode, usually ::MBG_XFER_MODE_ENCRYPTED
 * @param[in]     key   The crypto key (password) to be used
 */
 void set_encryption_mode( MBG_MSG_CTL *pmctl, int mode, const char *key ) ;

 /**
 * @brief Complete message header and transmit message
 *
 * Compute checksums and complete the message header, then
 * transmit both header and data. The caller must have copied
 * the data to be sent to the data field of the transmit buffer
 * and have set up the cmd and len fields of the message header.
 *
 * This function doesn't protect access to the device by a mutex,
 * so the calling function has to take care of the mutex handling.
 *
 * @param[in,out] pmctl   Pointer to a valid message control structure
 * @param[in]     p_addr  Pointer to XBP address specifier
 *
 * @return one of the @ref MBG_RETURN_CODES
 */
 int xmt_tbuff( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr ) ;

 /**
 * @brief Send a binary command message without parameters
 *
 * This function doesn't protect access to the device by a mutex,
 * so the calling function has to take care of the mutex handling,
 * or ::mbgextio_xmt_cmd which does so should be called preferably
 * from applications.
 *
 * @param[in,out] pmctl   Pointer to a valid message control structure
 * @param[in]     p_addr  Pointer to XBP address specifier
 * @param[in]     cmd     One of the command codes enumerated in ::GPS_CMD_CODES
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_xmt_cmd
 * @see ::mbgextio_xmt_cmd_us
 * @see ::xmt_cmd_us
 */
 int xmt_cmd( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd ) ;

 /**
 * @brief Send a binary command message with ushort (16 bit) parameter
 *
 * This function doesn't protect access to the device by a mutex,
 * so the calling function has to take care of the mutex handling,
 * or ::mbgextio_xmt_cmd_us which does so should be called preferably
 * from applications.
 *
 * @param[in,out] pmctl   Pointer to a valid message control structure
 * @param[in]     p_addr  Pointer to XBP address specifier
 * @param[in]     cmd     One of the command codes enumerated in ::GPS_CMD_CODES
 * @param[in]     us      The 16 bit message parameter (data)
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_xmt_cmd_us
 * @see ::mbgextio_xmt_cmd
 * @see ::xmt_cmd
 */
 int xmt_cmd_us( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd, uint16_t us ) ;

 /**
 * @brief Init reception of a binary message
 *
 * @param[in,out] prctl  Pointer to a valid receive control structure
 *
 * @see ::check_transfer
 */
 void init_transfer( MBG_MSG_RCV_CTL *prctl ) ;

 /**
 * @brief Check an incoming data stream for a binary message
 *
 * Check the sequence of incoming characters for blocks of
 * binary message data. Binary messages are saved in a buffer
 * which is part of the ::MBG_MSG_RCV_CTL structure and the
 * caller checks the return value to get the receive status.
 *
 * This function doesn't protect access to the device by a mutex,
 * so the calling function has to take care of the mutex handling.
 *
 * @param[in,out] prctl  Pointer to a valid receive control structure
 * @param[in]     c      A byte from the incoming data stream
 *
 * @return One of the ::TR_STATUS_CODES
 */
 int check_transfer( MBG_MSG_RCV_CTL *prctl, uint8_t c ) ;


/* ----- function prototypes end ----- */

#endif // _USE_GPSSERIO_FNC

/* End of header body */


#undef _ext

#ifdef __cplusplus
}
#endif


#endif  /* _GPSSERIO_H */

