
/**************************************************************************
 *
 *  $Id: xtiocomm.h 1.2 2016/12/01 13:47:49Z philipp TEST $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions and prototypes for xtiocomm.c.
 *
 * -----------------------------------------------------------------------
 *  $Log: xtiocomm.h $
 *  Revision 1.2  2016/12/01 13:47:49Z  philipp
 *  Moved helper function check_byte_array_bit from xdevfeat.c to xtiocomm.c and make it public
 *  Revision 1.1  2016/03/16 14:32:52  martin
 *  Initial revision.
 *
 **************************************************************************/

#ifndef _XTIOCOMM_H
#define _XTIOCOMM_H


/* Other headers to be included */

#include <mbg_tgt.h>
#include <gpsserio.h>


#ifdef _XTIOCOMM
 #define _ext
 #define _DO_INIT
#else
 #define _ext extern
#endif

/* Start of header body */

#ifdef __cplusplus
extern "C" {
#endif




/* function prototypes: */

/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 /**
 * @brief Deallocate a message control structure
 *
 * Free the memory allocated for a message control structure
 * and set the pointer to NULL.
 *
 * @param[in,out] ppmctl  Address of a pointer to a message control structure
 *
 * @see ::alloc_msg_ctl
 */
 void dealloc_msg_ctl( MBG_MSG_CTL **ppmctl ) ;

 /**
 * @brief Allocate a message control structure
 *
 * Allocate memory for a message control structure and associated
 * message receive and transmit buffers.
 *
 * @param[out] ppmctl  Address of a pointer to a message control structure to be allocated, set to NULL on error
 *
 * @return ::MBG_SUCCESS or one of the @ref MBG_ERROR_CODES
 *
 * @see ::dealloc_msg_ctl
 */
 int alloc_msg_ctl( MBG_MSG_CTL **ppmctl ) ;

 const char *xtiocomm_get_cmd_name( GPS_CMD cmd_code ) ;
 //### TODO
int dev_open_finish( int rc, MBG_MSG_CTL *pmctl, MBG_MSG_CTL **caller_ppmctl ) ;

 //### TODO
int dev_open_fail_free( int rc, MBG_MSG_CTL **ppmctl, MBG_MSG_CTL **caller_ppmctl ) ;

 //### TODO
int dev_open_fail_close( int rc, MBG_MSG_CTL **ppmctl, MBG_MSG_CTL **caller_ppmctl ) ;

 //### TODO
void dev_open_init( MBG_MSG_CTL *pmctl, int conn_type, int msg_timeout_ms, int poll_timeout_ms ) ;

 /**
 * @brief Check if a specific bit is set in a byte array
 *
 * This API call checks if a specific bit is set in an array of bytes.
 * Bits are counted starting from the least significant bit of the least
 * significant byte.
 *
 * @param[in] bit_num    Number of the bit to be tested, 0..(8*(max_bytes-1))
 * @param[in] p          Pointer to a buffer with an array of bytes
 * @param[in] max_bytes  The number of bytes in the buffer p
 *
 * @return ::MBG_SUCCESS if the bit is set, ::MBG_ERR_NOT_SUPP_BY_DEV if not,
 *         or ::MBG_ERR_RANGE if the bit number is out of the range of the array
 */
 int check_byte_array_bit( int bit_num, const uint8_t *p, int max_bytes ) ;

 /**
 * @brief Close a socket and make the socket descriptor invalid
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure containing the socket descriptor
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 int socket_close( MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Close a binary communication channel and release resources
 *
 * Closes a binary communication channel which has been opened by one
 * of the mbgextio_open_...() functions and releases the buffers which
 * have been allocated when the channel was opened.
 *
 * The pointer to the message control structure passed by address is set
 * to NULL after the channel has been closed and the resources have
 * been released.
 *
 * @param[in,out] ppmctl Address of a pointer to a message control structure
 *                       created when the communication channel was opened
 *                       by one of the mbgextio_open_...() calls.
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_open_socket
 * @see ::mbgextio_open_serial
 * @see ::mbgextio_open_serial_ftdi
 * @see ::mbgextio_open_usb
 * @see ::mbgextio_open_usb_direct_io
 */
 _NO_MBG_API_ATTR int _MBG_API xtiocomm_close_connection( MBG_MSG_CTL **ppmctl ) ;

 /**
 * @brief Set device poll timeout
 *
 * @param[in,out] pmctl        Pointer to a valid message control structure
 * @param[in]     new_timeout  New poll timeout value [ms]
 *
 * @return Previous poll timeout value [ms]
 *
 * @see ::mbgextio_get_dev_poll_timeout
 * @see ::mbgextio_set_msg_rcv_timeout
 * @see ::mbgextio_get_msg_rcv_timeout
 */
 _NO_MBG_API_ATTR ulong _MBG_API xtiocomm_set_dev_poll_timeout( MBG_MSG_CTL *pmctl, ulong new_timeout ) ;

 /**
 * @brief Get device poll timeout
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return Current poll timeout value [ms]
 *
 * @see ::mbgextio_set_dev_poll_timeout
 * @see ::mbgextio_set_msg_rcv_timeout
 * @see ::mbgextio_get_msg_rcv_timeout
 */
 _NO_MBG_API_ATTR ulong _MBG_API xtiocomm_get_dev_poll_timeout( const MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Set message receive timeout value
 *
 * @param[in,out] pmctl        Pointer to a valid message control structure
 * @param[in]     new_timeout  New timeout value [ms]
 *
 * @see ::mbgextio_set_dev_poll_timeout
 * @see ::mbgextio_get_dev_poll_timeout
 * @see ::mbgextio_get_msg_rcv_timeout
 */
 _NO_MBG_API_ATTR void _MBG_API xtiocomm_set_msg_rcv_timeout( MBG_MSG_CTL *pmctl, ulong new_timeout ) ;

 /**
 * @brief Get message receive timeout value
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return Current timeout value [ms]
 *
 * @see ::mbgextio_set_dev_poll_timeout
 * @see ::mbgextio_get_dev_poll_timeout
 * @see ::mbgextio_set_msg_rcv_timeout
 */
 _NO_MBG_API_ATTR ulong _MBG_API xtiocomm_get_msg_rcv_timeout( const MBG_MSG_CTL *pmctl ) ;


/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif

/* End of header body */

#undef _ext
#undef _DO_INIT

#endif  /* _XTIOCOMM_H */
