
/**************************************************************************
 *
 *  $Id: xdevfeat.h 1.1.1.28.1.12 2017/03/07 13:45:34Z thomas-b TEST thomas-b $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions and prototypes for xdevfeat.c.
 *
 * -----------------------------------------------------------------------
 *  $Log: xdevfeat.h $
 *  Revision 1.1.1.28.1.12  2017/03/07 13:45:34Z  thomas-b
 *  Check receiver info feature instead of builtin feature for ignore lock
 *  Revision 1.1.1.28.1.11  2017/02/22 11:32:52  martin
 *  Fixed warnings due to preliminary, unfinished code.
 *  Revision 1.1.1.28.1.10  2017/02/07 14:24:09  thomas-b
 *  Added function xdevfeat_has_monitoring, which checks if the extended feature MBG_XFEATURE_MONITORING is set
 *  Revision 1.1.1.28.1.9  2017/02/07 14:10:48  daniel
 *  Updated function prototypes
 *  Revision 1.1.1.28.1.8  2016/12/06 10:43:37  thomas-b
 *  Added function xdevfeat_has_sv_info
 *  Revision 1.1.1.28.1.7  2016/11/30 16:12:27  thomas-b
 *  Added function xdevfeat_has_scu_stat
 *  Revision 1.1.1.28.1.6  2016/11/22 10:33:16  philipp
 *  Implemented I/O ports
 *  Revision 1.1.1.28.1.5  2016/11/07 11:31:49  thomas-b
 *  Fixed typedef for XDEVFEAT_CHK_SUPP_FNC
 *  Revision 1.1.1.28.1.4  2016/11/02 12:16:19  thomas-b
 *  Fixed documentation
 *  Revision 1.1.1.28.1.3  2016/11/02 12:08:22  thomas-b
 *  Added function to check for new MBG_XFEATURE_REQ_TTM
 *  Revision 1.1.1.28.1.2  2016/11/01 09:39:32  martin
 *  Doxygen changes
 *  Revision 1.1.1.28.1.1  2016/10/25 08:08:37  martin
 *  Updated function prototypes with preliminary changes.
 *  Revision 1.1.1.28  2016/10/20 14:46:05  thomas-b
 *  Added function to check if XBP is supported
 *  Revision 1.1.1.27  2016/10/20 10:43:36  thomas-b
 *  Added function to check if a device is a bus level device
 *  Revision 1.1.1.26  2016/10/14 11:09:41  thomas-b
 *  Added function to check MBG_XFEATURE_UCAP_NET
 *  Revision 1.1.1.25  2016/09/29 14:35:35  thomas-b
 *  Added function to check reboot feature
 *  Revision 1.1.1.24  2016/09/29 12:19:59  thomas-b
 *  Added function to check transactions feature
 *  Revision 1.1.1.23  2016/07/07 15:03:33  martin
 *  Updated function prototypes.
 *  Revision 1.1.1.22  2016/06/15 10:15:52  thomas-b
 *  Added functions which check if the user capture feature is supported by a device
 *  Revision 1.1.1.21  2016/06/14 10:33:23  thomas-b
 *  Added functions which check if the event log feature is supported by a device
 *  Revision 1.1.1.20  2016/06/07 07:43:09  philipp
 *  New function to check for Irig Rx feature
 *  Revision 1.1.1.19  2016/06/02 11:44:37  philipp
 *  Fixed prototype
 *  Revision 1.1.1.18  2016/05/30 08:10:47  thomas-b
 *  Added functions to check several builtin features
 *  Revision 1.1.1.17  2016/05/20 09:41:39  thomas-b
 *  Removed functions which check for a specific IMS card
 *  Revision 1.1.1.16  2016/05/20 08:50:47  thomas-b
 *  Added functions xdevfeat_has_time_scale and xdevfeat_has_tzcode
 *  Revision 1.1.1.15  2016/05/17 06:33:13  philipp
 *  New function to check whether a device has serial outputs
 *  Revision 1.1.1.14  2016/05/12 10:41:41  philipp
 *  New functions to check bpe card and IRIG Tx feature
 *  Revision 1.1.1.13  2016/05/10 06:15:32  philipp
 *  New function to check whether a device has programmable pulses
 *  Revision 1.1.1.12  2016/04/26 06:52:46  thomas-b
 *  Added functions to check if NET_CFG and LAN_IP4 APIs are supported
 *  Revision 1.1.1.11  2016/04/22 10:54:01  philipp
 *  New function to check whether device is LIU
 *  Revision 1.1.1.10  2016/04/20 13:12:58  thomas-b
 *  Added function to check if a device supports NTP
 *  Revision 1.1.1.9  2016/04/20 09:26:04  philipp
 *  Moved all HPS-PTP related structures to gpspriv.h and removed related extended feature bit from gpsdefs.h.
 *  Also removed functions from mbgextio and xdevfeat since HPS-PTP handling needs a redesign concerning structures.
 *  Thus, handle everything explicitly for now!
 *  -> Redesing this A.S.A.P.!!!
 *  Revision 1.1.1.8  2016/04/15 08:17:27  philipp
 *  New feature MBG_XFEATURE_EXT_PTP
 *  Revision 1.1.1.7  2016/04/13 07:01:22  philipp
 *  New function to check whether device is HPS
 *  Revision 1.1.1.6  2016/04/12 13:27:42  philipp
 *  Several new functions to check for device models and device features
 *  Revision 1.1.1.5  2016/04/11 13:57:17  thomas-b
 *  Added function xdevfeat_has_xmulti_ref
 *  Revision 1.1.1.4  2016/04/07 12:36:57  martin
 *  Updated function prototypes.
 *  Revision 1.1.1.3  2016/04/04 15:31:25  martin
 *  New function xdevfeat_is_vsg().
 *  Revision 1.1.1.2  2016/03/24 14:08:52  martin
 *  *** empty log message ***
 *  Revision 1.1.1.1  2016/03/18 10:48:19  martin
 *  *** empty log message ***
 *  Revision 1.1  2016/03/16 14:32:52  martin
 *  Initial revision.
 *
 **************************************************************************/

#ifndef _XDEVFEAT_H
#define _XDEVFEAT_H


/* Other headers to be included */

#include <gpsdefs.h>

#ifdef _XDEVFEAT
 #define _ext
 #define _DO_INIT
#else
 #define _ext extern
#endif

/* Start of header body */

/**
 * @defgroup chk_supp_fncs Groups of functions used to check if a particular feature is supported
 *
 * Each of these functions can be used to check if a device supports a particular
 * feature. ::MBG_SUCCESS is returned if the requested feature is supported,
 * otherwise one of the @ref MBG_ERROR_CODES is returned, as appropriate.
 *
 * Some features are supported by a device if an associated bit is set in the
 * ::RECEIVER_INFO::features field, but since the number of bits in this field
 * is limited, newer feature bits are defined in a ::MBG_XFEATURE_BUFFER.
 * Finally there are some builtin features which may be implicitly supported
 * by a particular device model, or not.
 *
 * These functions provide a unified API for all feature types to make
 * application code more straightforward.
 *
 * If the mbgextio API is used then a ::MBG_XDEV_FEATURES structure embedded in
 * the ::MBG_MSG_CTL structure is set up automatically when the device is opened,
 * and there are mbgextio_... wrapper functions available which just expect the
 * MBG_MSG_CTL * associated with the device to check if a feature is supported.
 * See @ref mbgextio_chk_supp_fncs.
 *
 * Other implementations which retrieve the ::MBG_XDEV_FEATURES structure of
 * a device in a different way can use some lower level functions.
 * See @ref xdevfeat_chk_supp_fncs.
 */


/**
 * @defgroup xdevfeat_chk_supp_fncs Low level functions used to check if a particular feature is supported
 * @ingroup chk_supp_fncs
 *
 * @note Applications using the mbgextio API should use the mbgextio_ wrapper
 * functions preferably. See @ref mbgextio_chk_supp_fncs.
 */


#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief A structure combining all device feature information
 */
typedef struct
{
  uint32_t reserved;                    ///< Currently reserved, unused, always 0
  RECEIVER_INFO receiver_info;          ///< Receiver info provided by the device
  MBG_XFEATURE_BUFFER xfeature_buffer;  ///< Extended features provided by the device
  MBG_TLV_INFO tlv_info;                ///< TLV info provided by a device

} MBG_XDEV_FEATURES;



/**
 * @brief Type of functions to check if a feature is supported
 */
typedef int _NO_MBG_API XDEVFEAT_CHK_SUPP_FNC( const MBG_XDEV_FEATURES *p_xdf );



/* function prototypes: */

/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 /**
 * @brief Check if a device can receive the GPS satellite system
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_dev_is_gps
 * @see ::mbg_chk_dev_is_gps
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_is_gps( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the GNSS API
 *
 * This is usually supported by devices which can receive signals
 * from different satellite systems, e.g. GPS, GLONASS, ...
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_dev_is_gnss
 * @see ::mbg_chk_dev_is_gnss
 * @see ::MBG_GNSS_TYPES
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_is_gnss( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device is a time code receiver (IRIG or similar)
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_dev_is_tcr  //### TODO
 * @see ::mbg_chk_dev_is_tcr   //### TODO
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_is_tcr( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device is a DCF77 AM receiver
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_dev_is_dcf  //### TODO
 * @see ::mbg_chk_dev_is_dcf
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_is_dcf( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device can receive DCF77 PZF
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_dev_has_pzf  //### TODO
 * @see ::mbg_chk_dev_has_pzf
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_pzf( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device is an MSF receiver
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_is_msf( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device is a JJY receiver
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_is_jjy( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device is a WWVB receiver
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_is_wwvb( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device is a bus level device
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_is_bus_lvl_dev( const MBG_XDEV_FEATURES *p_xdf ) ;

 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_ims( const MBG_XDEV_FEATURES *p_xdf ) ;
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_gpio( const MBG_XDEV_FEATURES *p_xdf ) ;
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_synth( const MBG_XDEV_FEATURES *p_xdf ) ;
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_prog_pulses( const MBG_XDEV_FEATURES *p_xdf ) ;
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_irig_tx( const MBG_XDEV_FEATURES *p_xdf ) ;
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_irig_rx( const MBG_XDEV_FEATURES *p_xdf ) ;
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_serouts( const MBG_XDEV_FEATURES *p_xdf ) ;
 /**
 * @brief Check if a device supports the ::BVAR_STAT structure and API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_bvar_stat( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports reading the position as ::XYZ array
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_pos_xyz( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports reading the position as ::LLA array
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_pos_lla( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if the device supports the builtin feature TIME
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_time_ttm( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the ::MBG_TIME_SCALE_INFO structure and API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_get_time_scale_info
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_time_scale( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the ::TZDL structure and API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_tzdl( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the ::TZCODE API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_tzcode( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the ::ANT_INFO structure and API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_ant_info( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the ::ENABLE_FLAGS structure and API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_enable_flags( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the ::STAT_INFO structure and API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_gps_stat_info( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the ::ANT_CABLE_LEN structure and API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_ant_cable_length( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the ::IGNORE_LOCK structure and API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_gps_ignore_lock( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if the device supports the SCU_STAT structures
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 * @see @ref group_scu
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_scu_stat( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if the device supports the SV_INFO structures
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else ::MBG_ERR_NOT_SUPP_BY_DEV
 *         or ::MBG_ERR_DEV_NOT_SUPP (see @ref xdevfeat_chk_supp_fncs)
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_sv_info( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a timecode receiver provides ::MBG_RAW_IRIG_DATA
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_get_raw_irig_data
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_raw_irig_data( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the old LAN_IP4 API
 *
 * The LAN_IP4 API provides structures and functions to configure
 * parts of the networking of a device and is superseded by the
 * NET_CFG API. Some devices combine NET_CFG and LAN_IP4.
 * Therefore, ::mbgextio_get_all_net_cfg_info should be used
 * preferably to read the network configuration.
 * It will translate the old structures into the new ones.
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_get_all_net_cfg_info
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_lan_ip4( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the new NET_CFG API
 *
 * The NET_CFG API provides structures and functions to configure
 * the complete networking part of a device and supersedes the
 * LAN_IP4 API. Not all devices support the whole feature set
 * of the NET_CFG API or combine NET_CFG and LAN_IP4.
 * Therefore, ::mbgextio_get_all_net_cfg_info should be used
 * preferably to read the network configuration.
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_get_all_net_cfg_info
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_net_cfg( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the PTP API
 *
 * The PTP API consists of different calls and associated structures
 * which * have evolved over time. Not all devices support every call,
 * so ::mbgextio_get_all_ptp_cfg_info takes care to check which parts are
 * supported and thus should be used preferably to read PTP information.
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_get_all_ptp_cfg_info
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_ptp( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the NTP API
 *
 * The NTP API consists of different calls and associated structures
 * which have evolved over time. Not all devices support every call,
 * so ::mbgextio_get_all_ntp_cfg_info takes care to check which parts are
 * supported and thus should be used preferably to read NTP information.
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_get_all_ntp_cfg_info
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_ntp( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the event log API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_evt_log( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the user capture API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_ucap( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the user capture via network feature
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref group_ucap_net
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_ucap_net( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the TLV API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref group_tlv_api
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_tlv_api( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports a firmware update via TLV
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_xmt_fw_update
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_supp_tlv_fw_update( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports creating / sending a diagnostics file via TLV
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::TODO  //refer to get diag function
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_supp_tlv_diag_file( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports PTPv2 license infos
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_supp_tlv_ptpv2_license( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports NTP license infos via TLV
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_supp_tlv_ntp_license( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports PTPv1 License Infos via TLV
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_supp_tlv_ptpv1_license( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports Time Monitor License infos via TLV
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_tlv_feat_supp
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_supp_tlv_time_monitor_license( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the ::GPS_SAVE_CFG command
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_cmd_save_cfg
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_cmd_save_cfg( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the extended feature monitoring
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_monitoring( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the LED API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::TODO ###
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_led_api( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the LNE API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::TODO ###
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_lne_api( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the power control API
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::TODO ###
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_pwr_ctl_api( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the ::MBG_EXT_SYS_INFO command
 *
 * @param[in,out] p_xdf  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::TODO ###
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_ext_sys_info( const MBG_XDEV_FEATURES *p_xdf ) ;

 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_io_ports( const MBG_XDEV_FEATURES *p_xdf ) ;
 /**
 * @brief Check if a device has ::MBG_XFEATURE_TRANSACTIONS
 *
 * @param[in,out] p_xdf  Pointer to a valid message control structure
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::TODO ###
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_transactions( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device has ::MBG_XFEATURE_REBOOT
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_reboot( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device has ::MBG_XFEATURE_REQ_TTM
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_xfeature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 * @see mbgextio_get_time
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_req_ttm( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the extended multi ref features including multi instances
 *
 * The different multi ref feature and its appropriate flags have evolved over time.
 * This function only checks the currently up-to-date GPS_HAS_XMRS_MULT_INSTC flag.
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see ::mbgextio_get_all_xmulti_ref_info
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_xmulti_ref( const MBG_XDEV_FEATURES *p_xdf ) ;

 /**
 * @brief Check if a device supports the extended binary protocol (XBP) feature
 *
 * @param[in,out] p_xdf  Pointer to a ::MBG_XDEV_FEATURES buffer associated with the device
 *
 * @return ::MBG_SUCCESS if supported, else error code from ::check_ri_feature
 *
 * @ingroup xdevfeat_chk_supp_fncs
 * @see @ref xdevfeat_chk_supp_fncs
 */
 _NO_MBG_API_ATTR int _NO_MBG_API xdevfeat_has_xbp( const MBG_XDEV_FEATURES *p_xdf ) ;


/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif

/* End of header body */

#undef _ext
#undef _DO_INIT

#endif  /* _XDEVFEAT_H */
