
/**************************************************************************
 *
 *  $Id: timeutil.h 1.2.1.3 2017/04/10 13:30:04Z martin TEST $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions and prototypes for timeutil.c
 *
 * -----------------------------------------------------------------------
 *  $Log: timeutil.h $
 *  Revision 1.2.1.3  2017/04/10 13:30:04Z  martin
 *  Fixed some compiler warnings.
 *  Revision 1.2.1.2  2017/02/06 11:14:13Z  martin
 *  Fixed build under windows.
 *  Updated function prototypes.
 *  Revision 1.2.1.1  2016/08/11 15:09:51Z  martin
 *  *** empty log message ***
 *  Revision 1.2  2016/08/11 13:44:00  martin
 *  Include stddef.h.
 *  Revision 1.1  2016/07/15 14:14:20Z  martin
 *  Initial revision
 *
 **************************************************************************/

#ifndef _TIMEUTIL_H
#define _TIMEUTIL_H

/* Other headers to be included */

#include <words.h>  // implicitly includes mbg_tgt.h for non-firmware projects
#include <mbgerror.h>

#include <time.h>
#include <stddef.h>


#ifdef _TIMEUTIL
 #define _ext
 #define _DO_INIT
#else
 #define _ext extern
#endif


/* Start of header body */

#ifdef __cplusplus
extern "C" {
#endif


#if defined( MBG_TGT_WIN32 ) || defined( MBG_TGT_DOS )

typedef int clockid_t;
#define clockid_t clockid_t

#define CLOCK_REALTIME  ( (clockid_t) 0 )

#endif



#if defined( MBG_TGT_WIN32 )

#define __const__ const

/**
 * @brief A pointer to a function returning the system time as FILETIME
 *
 * This can be e.g. the standard Windows API call GetSystemTimeAsFileTime()
 * or the GetSystemTimeAsPreciseFileTime() API call introduced with Windows 8.
 */
typedef VOID (WINAPI *GSTAFT_FNC)(LPFILETIME lpSystemTimeAsFileTime);

_ext GSTAFT_FNC gstaft_fnc
#ifdef _DO_INIT
 = GetSystemTimeAsFileTime
#endif
;

#endif


/* function prototypes: */

static __mbg_inline
time_t cvt_to_time_t( time_t t )
{
  // Eventually we can do some epoch check here.
  return (time_t) t;

}  // cvt_to_time_t



static __mbg_inline
int mbg_gmtime( struct tm *p_tm, const time_t *p_time )
{
  struct tm *p_tm_tmp = gmtime( p_time );

  if ( p_tm_tmp == NULL )  // conversion failed
    return mbg_get_last_error( NULL );

  *p_tm = *p_tm_tmp;

  return MBG_SUCCESS;

}  // mbg_gmtime



/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 size_t snprint_gmtime_error( char *s, size_t max_len, int mbg_errno, time_t t, const char *calling_fnc ) ;
 int mbg_clock_gettime( clockid_t clock_id, struct timespec *tp ) ;
 int mbg_clock_settime( clockid_t clock_id, const struct timespec *tp ) ;
 void check_precise_time_api( void ) ;

/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif


/* End of header body */

#undef _ext
#undef _DO_INIT

#endif  /* _TIMEUTIL_H */
