
/**************************************************************************
 *
 *  $Id: extiohlp.h 1.3.1.5.1.70 2017/03/27 10:37:41Z thomas-b TEST $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions and prototypes for extiohlp.c.
 *
 * -----------------------------------------------------------------------
 *  $Log: extiohlp.h $
 *  Revision 1.3.1.5.1.70  2017/03/27 10:37:41Z  thomas-b
 *  Added function mbgextio_get_all_ptp_v1_common_datasets
 *  Revision 1.3.1.5.1.69  2017/03/22 09:46:16  thomas-b
 *  Added function mbgextio_save_all_io_port_info
 *  Revision 1.3.1.5.1.68  2017/03/20 10:10:02  martin
 *  Fixed build without _PRELIMINARY_CODE.
 *  Revision 1.3.1.5.1.67  2017/03/08 12:37:51  thomas-b
 *  Added set bit for transaction type in mbgextio_begin_transaction
 *  Revision 1.3.1.5.1.66  2017/02/22 08:32:20  thomas-b
 *  Extended get and set of ALL_MONITORING_INFO by event structures
 *  Added get function for ALL_MONITORING_STATUS
 *  Revision 1.3.1.5.1.65  2017/02/16 12:59:52  thomas-b
 *  Renamed mbgextio_get_ptp_v2_common_datasets to mbgextio_get_all_ptp_v2_common_datasets
 *  Use ALL_PTP_V2_COMMON_DATASETS structure instead of MBG_PTP_V2_COMMON_DATASETS
 *  Revision 1.3.1.5.1.64  2017/02/16 09:32:33  thomas-b
 *  Added function mbgextio_get_ptp_v2_common_datasets
 *  Revision 1.3.1.5.1.63  2017/02/15 14:00:07  martin
 *  Fixed function prototypes.
 *  Revision 1.3.1.5.1.62  2017/02/08 13:15:44  thomas-b
 *  Added functions to get and save all monitoring, especially SNMP, configuration
 *  Revision 1.3.1.5.1.61  2016/12/08 14:46:26  martin
 *  Updated function prototypes.
 *  Revision 1.3.1.5.1.60  2016/11/22 12:40:47Z  philipp
 *  Added I/O port helper functions
 *  Revision 1.3.1.5.1.59  2016/10/27 08:01:37  martin
 *  Doxygen fixes.
 *  Updated function prototypes.
 *  Revision 1.3.1.5.1.58  2016/10/25 07:48:28  martin
 *  Doxygen fixes.
 *  Revision 1.3.1.5.1.57  2016/10/21 09:39:43  thomas-b
 *  Added function mbgextio_get_all_xbp_info
 *  Revision 1.3.1.5.1.56  2016/10/19 14:33:07  thomas-b
 *  Added functions mbgextio_get_all_ucap_net_info and mbgextio_save_all_ucap_net_info
 *  Revision 1.3.1.5.1.55  2016/09/29 14:35:11  thomas-b
 *  Moved new get and set functions for NET_CFG_API stage 2 to mbgextio
 *  Revision 1.3.1.5.1.54  2016/09/29 12:16:37  thomas-b
 *  Added set functions for NET_CFG_API stage 2
 *  Revision 1.3.1.5.1.53  2016/09/29 09:09:03  thomas-b
 *  Added more functions for NET_CFG_API stage 2, especially status
 *  Revision 1.3.1.5.1.52  2016/09/29 06:13:06  philipp
 *  Added support for beginning / ending typed transactions
 *  Revision 1.3.1.5.1.51  2016/09/29 05:56:59  thomas-b
 *  Added first functions for NET_CFG_API stage 2
 *  Revision 1.3.1.5.1.50  2016/09/27 09:27:53  udo
 *  added new function mbgextio_req_generic_file()
 *  Revision 1.3.1.5.1.49  2016/06/28 13:39:21  philipp
 *  Added missing include files if _USE_SERIAL_IO is 0
 *  Revision 1.3.1.5.1.48  2016/06/21 12:06:46  thomas-b
 *  Moved mbgextio_calloc_ucap_entry to cfg_hlp so it can be used in deviohlp as well
 *  Revision 1.3.1.5.1.47  2016/06/21 08:41:30  thomas-b
 *  Removed old mbgextio_get_all_ucap_info function and static flag from mbgextio_calloc_ucap_entry
 *  Revision 1.3.1.5.1.46  2016/06/15 14:03:56  thomas-b
 *  Added function mbgextio_get_all_ucap_info
 *  Revision 1.3.1.5.1.45  2016/05/30 14:25:41  daniel
 *  Added missing code for HPS firmware rollback
 *  Revision 1.3.1.5.1.44  2016/05/30 13:57:59  daniel
 *  Support firmware rollback
 *  Revision 1.3.1.5.1.43  2016/05/26 10:59:27  thomas-b
 *  Added parameter ALL_NTP_CFG_INFO to mbgextio_get_all_ntp_status
 *  Moved check functions of specific features to cfg_hlp
 *  Revision 1.3.1.5.1.42  2016/05/25 08:43:37  philipp
 *  Redesign of ALL_[xxx]_[XXX] structures and (helper) functions
 *  Revision 1.3.1.5.1.41  2016/05/23 08:58:17  philipp
 *  New function mbgextio_get_all_gpio_state
 *  Revision 1.3.1.5.1.40  2016/05/23 08:24:17  philipp
 *  New function mbgextio_get_all_ims_state
 *  Revision 1.3.1.5.1.39  2016/05/11 13:21:36  thomas-b
 *  Implemented mbgextio_get_all_net_status_info
 *  Revision 1.3.1.5.1.38  2016/05/04 13:07:50  thomas-b
 *  Added function mbgextio_save_all_net_cfg_info
 *  Revision 1.3.1.5.1.37  2016/04/27 07:12:03  thomas-b
 *  Improved comments for mbgextio_get_all_net_cfg_info
 *  Revision 1.3.1.5.1.36  2016/04/26 14:42:57  thomas-b
 *  Added function mbgextio_get_all_net_cfg_info
 *  Revision 1.3.1.5.1.35  2016/04/25 14:47:43  martin
 *  *** empty log message ***
 *  Revision 1.3.1.5.1.34  2016/04/22 07:11:51  philipp
 *  Use pointer to pointer in get_all_* functions
 *  Revision 1.3.1.5.1.33  2016/04/22 05:01:49  thomas-b
 *  Added function mbgextio_save_all_ntp_cfg_info
 *  Revision 1.3.1.5.1.32  2016/04/20 14:54:33  thomas-b
 *  Added functions mbgextio_get_all_ntp_cfg_info and mbgextio_get_all_ntp_status
 *  Revision 1.3.1.5.1.31  2016/04/20 12:37:56  thomas-b
 *  Moved free functions for ALL_XMULTI_REF_INFO and ALL_XMULTI_REF_STATUS to cfg_hlp
 *  Revision 1.3.1.5.1.30  2016/04/18 14:07:04  thomas-b
 *  Changed comment
 *  Revision 1.3.1.5.1.29  2016/04/18 12:57:45  thomas-b
 *  Renamed mbgextio_set_all_xmulti_ref_settings to mbgextio_save_all_xmulti_ref_info
 *  Revision 1.3.1.5.1.28  2016/04/15 11:12:26  thomas-b
 *  Changed xmulti ref functions to alloc/free the whole struct
 *  Revision 1.3.1.5.1.27  2016/04/13 07:16:48  thomas-b
 *  Added function mbgextio_set_all_xmulti_ref_settings
 *  Revision 1.3.1.5.1.26  2016/04/12 13:28:40  philipp
 *  New helper functions to get all feature related structures at once
 *  Revision 1.3.1.5.1.25  2016/04/12 08:26:10  thomas-b
 *  Added mbgextio_get_all_xmulti_ref_info and mbgextio_get_all_xmulti_ref_status and appropriate free functions
 *  Revision 1.3.1.5.1.24  2016/04/11 11:14:39  daniel
 *  Support incremental update
 *  Revision 1.3.1.5.1.23  2016/03/22 11:51:42  thomas-b
 *  Moved new xport functions and structure definitions to mbgextio
 *  Revision 1.3.1.5.1.22  2016/03/18 07:10:18Z  thomas-b
 *  Renamed new xport functions and structures
 *  Revision 1.3.1.5.1.21  2016/03/17 07:11:36  thomas-b
 *  Added functions mbgextio_setup_xport_list and mbgextio_free_xport_list
 *  Will have to be extended for use under Windows
 *  Revision 1.3.1.5.1.20  2016/03/16 13:47:15  martin
 *  *** empty log message ***
 *  Revision 1.3.1.5.1.19  2016/03/14 09:46:35  marvin
 *  Added function to set all ptp settings.
 *  Revision 1.3.1.5.1.18  2016/02/18 15:52:32Z  daniel
 *  Account for diag file and license upgrade
 *  Revision 1.3.1.5.1.17  2016/02/15 12:13:23  daniel
 *  Updated function prototypes
 *  Revision 1.3.1.5.1.16  2015/12/01 11:34:06  martin
 *  *** empty log message ***
 *  Revision 1.3.1.5.1.15  2015/11/30 07:06:36  philipp
 *  Access function for control message's opaque / internal USB device info structure
 *  Revision 1.3.1.5.1.14  2015/11/26 16:19:26  martin
 *  Reworked check feature API causing some other API calls to be
 *  simplified/changed since receiver info is now stored inside
 *  the message control block.
 *  Revision 1.3.1.5.1.13  2015/11/25 10:59:52  philipp
 *  Extended TLV xmt functions by uid parameter
 *  Revision 1.3.1.5.1.12  2015/11/24 13:13:07  philipp
 *  Added / redesigned TLV functions
 *  Revision 1.3.1.5.1.11  2015/11/23 15:08:41  daniel
 *  More work on TLV stuff
 *  Revision 1.3.1.5.1.10  2015/11/23 14:17:02  philipp
 *  Moved TLV related sending / receiving functions to here
 *  Revision 1.3.1.5.1.9  2015/10/19 16:42:16  martin
 *  *** empty log message ***
 *  Revision 1.3.1.5.1.8  2015/10/19 09:35:10  martin
 *  *** empty log message ***
 *  Revision 1.3.1.5.1.7  2015/10/09 11:09:13  martin
 *  *** empty log message ***
 *  Revision 1.3.1.5.1.6  2015/10/07 16:03:21  martin
 *  *** empty log message ***
 *  Revision 1.3.1.5.1.5  2015/10/07 09:59:01  martin
 *  More common GNSS support.
 *  Revision 1.3.1.5.1.4  2015/10/06 14:12:27  martin
 *  Account for library module chk_tstr renamed to mbg_tstr.
 *  Revision 1.3.1.5.1.3  2015/09/07 13:24:10  martin
 *  Revision 1.3.1.5.1.2  2015/01/21 13:24:47  marvin
 *  Added XBP Adress specifier to mbgextio functions.
 *  Revision 1.3.1.5.1.1  2014/10/31 12:03:34Z  martin
 *  Started to support XBP addressing.
 *  Revision 1.3.1.5  2014/03/18 11:17:00  gregoire
 *  Revision 1.3.1.4  2014/03/17 14:51:50Z  martin
 *  Revision 1.3.1.3  2013/12/19 09:20:12Z  martin
 *  Revision 1.3.1.2  2013/12/17 14:57:49Z  martin
 *  Revision 1.3.1.1  2013/09/25 11:10:56Z  marvin
 *  Added function for all_ptp_cfg_info.
 *  Revision 1.3  2013/02/01 15:52:16Z  martin
 *  Updated function prototypes.
 *  Revision 1.2  2012/03/09 08:35:51Z  martin
 *  Updated function prototypes.
 *  Revision 1.1  2011/09/21 15:59:59  martin
 *  Initial revision.
 *
 **************************************************************************/

#ifndef _EXTIOHLP_H
#define _EXTIOHLP_H


/* Other headers to be included */

#include <mbgextio.h>
#include <cfg_hlp.h>
#include <mbgerror.h>
#include <stdio.h>
#include <mbgserio.h>

#ifdef _EXTIOHLP
 #define _ext
 #define _DO_INIT
#else
 #define _ext extern
#endif

/* Start of header body */

#ifdef __cplusplus
extern "C" {
#endif

/* function prototypes: */

/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 /**
 * @brief Set a callback function and argument used to decode a time string
 *
 * Some devices send a serial time string interleaved with some binary messages.
 * If a callback function has been specified then the binary message receiver
 * function invokes that callback function whenever some characters are received
 * which don't belong to a binary message. A callback function like ::mbg_tstr_receive
 * can then try to decode a serial time string from such spurious characters.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     fnc    Address of a ::MBG_TSTR_RCV_FNC-style callback function
 * @param[in]     arg    A prepared ::MBG_TSTR_RCV_ARG structure passed to the callback
 *                       function whenever it is invoked.
 *
 * @see ::MBG_TSTR_RCV_FNC
 * @see ::MBG_TSTR_RCV_ARG
 * @see ::mbg_tstr_set_rcv_callback
 */
 void mbgextio_set_chk_tstr( MBG_MSG_CTL *pmctl, MBG_TSTR_RCV_FNC *fnc, MBG_TSTR_RCV_ARG *arg ) ;

 /**
 * @brief Read all serial port settings and supported configuration parameters
 *
 * ::mbgextio_setup_receiver_info should have been called before to set up
 * a ::RECEIVER_INFO structure to be passed to this function, so this
 * function can determine how many serial ports and associated structures
 * are supported by this device.
 *
 * The complementary function ::mbgextio_save_serial_settings should
 * be used to write a modified port configuration back to the device.
 *
 * @param[in,out] pmctl    Pointer to a valid message control structure
 * @param[in]     p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]    p_rpcfg  Pointer to a ::RECEIVER_PORT_CFG structure to be set up
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_save_serial_settings
 * @see ::mbgextio_get_receiver_info
 */
 int mbgextio_get_serial_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, RECEIVER_PORT_CFG *p_rpcfg ) ;

 /**
 * @brief Send the configuration settings for a single serial port to a device
 *
 * The function ::mbgextio_get_serial_settings must have been called before
 * to read the current settings and configuration options and fill up a
 * ::RECEIVER_PORT_CFG structure.
 *
 * After the settings for a port have been changed according to the supported
 * features this function can be used to write the new settings for a specific
 * port addressed by the port_idx parameter to the device.
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[in]     p_rpcfg   Pointer to a ::RECEIVER_PORT_CFG structure containg valid data
 * @param[in]     port_idx  Index of the serial port for which to save the settings
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_serial_settings
 */
 int mbgextio_save_serial_settings( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const RECEIVER_PORT_CFG *p_rpcfg, uint16_t port_idx ) ;

 /**
 * @brief Read all XBP information from a device into a newly or re-allocated ::ALL_XBP_INFO structure
 *
 * @note ::mbgextio_dev_has_xbp should be called to check if this API is supported.
 *
 * The allocated ::ALL_XBP_INFO needs to be freed ::free_all_ntp_cfg_info,
 * as soon as it is not needed any longer.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a pointer to ::ALL_XBP_INFO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_xbp
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_xbp_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_XBP_INFO **p ) ;

 /**
 * @brief Read all network configuration into an ::ALL_NET_CFG_INFO structure
 *
 * Reads the complete network configuration of a device. Depending on the
 * supported API (NET_CFG or LAN_IP4), the appropriate settings are requested and,
 * if neccessary, translated into the NET_CFG structures. The filled structures
 * can then be used as if the NET_CFG API was completely supported
 *
 * If NET_CFG or parts of it are not supported, the appropriate n_supp... members
 * of ::ALL_NET_CFG_INFO::glb_cfg_info are set to 0, whereas the num... members of
 * ::ALL_NET_CFG_INFO::glb_cfg_info::glb_settings may be 1 or bigger.
 *
 * A ::ALL_NET_CFG_INFO and the appropriate number of ::MBG_NET_INTF_LINK_INFO_IDX,
 * ::MBG_NET_INTF_ADDR_INFO_IDX, ::MBG_IP_ADDR_IDX, ::MBG_NET_NAME_IDX and
 * ::MBG_NET_INTF_ROUTE_INFO_IDX will be allocated and need to be freed later
 * by calling ::free_all_net_cfg_info
 *
 * @note ::mbgextio_dev_has_net_cfg and mbgextio_dev_has_lan_ip4 are used in the function
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a pointer to ::ALL_NET_CFG_INFO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_net_cfg
 * @see ::mbgextio_get_net_glb_cfg_info
 * @see ::mbgextio_get_net_dns_srvr_idx
 * @see ::mbgextio_get_net_dns_srch_dom_idx
 * @see ::mbgextio_dev_has_lan_ip4
 * @see ::mbgextio_get_lan_if_info
 * @see ::mbgextio_get_ip4_settings
 * @see ::free_all_net_cfg_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_net_cfg_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_NET_CFG_INFO **p ) ;

 /**
 * @brief Write all network settings to a device
 *
 * The complementary function ::mbgextio_get_all_net_cfg_info should
 * have been used to read the original network settings and supported
 * configuration parameters.
 *
 * Depending on the supported API (NET_CFG or LAN_IP4 or both partly),
 * the appropriate settings are, if neccessary, translated into LAN_IP4 structures
 * and send to the device using the appropriate API functions.
 *
 * @param[in,out]  pmctl   Pointer to a valid message control structure
 * @param[in]      p_addr  Pointer to an XBP address specifier, or NULL
 * @param[in]      p       Pointer to the ::ALL_NET_CFG_INFO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_save_all_net_cfg_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_NET_CFG_INFO *p ) ;

 /**
 * @brief Read current network status into an ::ALL_NET_STATUS_INFO structure
 *
 * Depending on the supported API (NET_CFG or LAN_IP4), the appropriate status
 * is requested and, if neccessary, translated into the NET_CFG structures.
 * The filled structures can then be used as if the NET_CFG API was completely supported.
 *
 * A ::ALL_NET_STATUS_INFO and the appropriate number of ::MBG_NET_INTF_LINK_INFO_IDX,
 * ::MBG_NET_INTF_ADDR_INFO_IDX, ::MBG_IP_ADDR_IDX, ::MBG_NET_NAME_IDX and
 * ::MBG_NET_INTF_ROUTE_INFO_IDX will be allocated and need to be freed later
 * by calling ::free_all_net_status_info
 *
 * @note ::mbgextio_dev_has_net_cfg and mbgextio_dev_has_lan_ip4 are used in the function
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a pointer to ::ALL_NET_STATUS_INFO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_net_cfg
 * @see ::mbgextio_get_net_glb_cfg_info
 * @see ::mbgextio_get_net_stat_dns_srvr_idx
 * @see ::mbgextio_get_net_stat_dns_srch_dom_stat_idx
 * @see ::mbgextio_dev_has_lan_ip4
 * @see ::mbgextio_get_lan_if_info
 * @see ::mbgextio_get_ip4_state
 * @see ::free_all_net_status_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_net_status_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_NET_STATUS_INFO **p ) ;

 /**
 * @brief Read all monitoring configuration into an ::ALL_MONITORING_INFO structure
 *
 * A ::ALL_MONITORING_INFO will be allocated and needs
 * to be freed later by calling ::free_all_monitoring_info.
 * A ::ALL_SNMP_INFO may be allocated, if SNMP is supported.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a pointer to ::ALL_MONITORING_INFO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_all_snmp_info
 * @see ::free_all_monitoring_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_monitoring_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_MONITORING_INFO **p ) ;

 /**
 * @brief Write all monitoring configuration to a device
 *
 * The complementary function ::mbgextio_get_all_monitoring_info should have been used
 * to read the original monitoring settings and supported configuration parameters.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[in]       p        Pointer to a ::ALL_MONITORING_INFO structure with all monitoring parameters
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_all_monitoring_info
 * @see ::mbgextio_save_all_snmp_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_save_all_monitoring_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_MONITORING_INFO *p ) ;

 /**
 * @brief Read all monitoring status into an ::ALL_MONITORING_STATUS structure
 *
 * A ::ALL_MONITORING_STATUS will be allocated and needs
 * to be freed later by calling ::free_all_monitoring_status.
 * The ::ALL_MONITORING_INFO::limits is used to check which events are supported
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[in]       info     Pointer to a ::ALL_MONITORING_INFO structure which has been read before
 * @param[out]      p        Pointer to a pointer to ::ALL_MONITORING_STATUS
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::free_all_monitoring_status
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_monitoring_status( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_MONITORING_INFO *info, ALL_MONITORING_STATUS **p ) ;

 /**
 * @brief Read all SNMP configuration into an ::ALL_SNMP_INFO structure
 *
 * A ::ALL_SNMP_INFO and the appropriate number of ::MBG_SNMP_V12_INFO_IDX,
 * ::MBG_SNMP_V12_TRAP_INFO_IDX, ::MBG_SNMP_V3_INFO_IDX, and ::MBG_SNMP_V3_TRAP_INFO_IDX
 * will be allocated and need to be freed later by calling ::free_all_snmp_info
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a pointer to ::ALL_SNMP_INFO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_monitoring
 * @see ::mbgextio_get_snmp_glb_info
 * @see ::mbgextio_get_snmp_v12_info_idx
 * @see ::mbgextio_get_snmp_v12_trap_info_idx
 * @see ::mbgextio_get_snmp_v3_info_idx
 * @see ::mbgextio_get_snmp_v3_trap_info_idx
 * @see ::free_all_snmp_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_snmp_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_SNMP_INFO **p ) ;

 /**
 * @brief Write all SNMP settings to a device
 *
 * The complementary function ::mbgextio_get_all_snmp_info should have been used
 * to read the original SNMP settings and supported configuration parameters.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[in]       p        Pointer to a ::ALL_SNMP_INFO structure with all SNMP parameters
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_snmp_info
 * @see ::mbgextio_set_snmp_glb_settings
 * @see ::mbgextio_set_snmp_v12_settings_idx
 * @see ::mbgextio_set_snmp_v12_trap_settings_idx
 * @see ::mbgextio_set_snmp_v3_settings_idx
 * @see ::mbgextio_set_snmp_v3_trap_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_save_all_snmp_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_SNMP_INFO *p ) ;

 /**
 * @brief Read all PTP configuration into an ::ALL_PTP_CFG_INFO structure
 *
 * @note ::mbgextio_dev_has_ptp should be called to check if this API is supported.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a ::ALL_PTP_CFG_INFO structure to be filled up
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_ptp
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_ptp_cfg_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_PTP_CFG_INFO *p ) ;

 /**
 * @brief Write all PTP settings to a device
 *
 * The complementary function ::mbgextio_get_all_ptp_cfg_info should
 * have been used to read the original PTP settings and supported
 * configuration parameters.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[in]       p        Pointer to a ::ALL_PTP_CFG_INFO structure with all ptp parameters
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_ptp_cfg_settings
 * @see ::mbgextio_set_ptp_uc_master_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_save_all_ptp_cfg_info(MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const ALL_PTP_CFG_INFO *p ) ;

 /**
 * @brief Read all PTPv1 common datasets into a newly or re-allocated ::ALL_PTP_V1_COMMON_DATASETS structure
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V1_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 * A number of ::MBG_PTP_V1_DEFAULT_DATASET::number_ports port datasets will be allocated.
 * To free the allocated ::ALL_PTP_V1_COMMON_DATASETS, ::free_all_ptp_v1_common_datasets should be called.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a pointer of ::ALL_PTP_V1_COMMON_DATASETS structure to be allocated and filled
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v1_default_dataset
 * @see ::mbgextio_get_ptp_v1_current_dataset
 * @see ::mbgextio_get_ptp_v1_parent_dataset
 * @see ::mbgextio_get_ptp_v1_time_properties_dataset
 * @see ::mbgextio_get_ptp_v1_port_dataset_idx
 * @see ::free_all_ptp_v1_common_datasets
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_ptp_v1_common_datasets( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_PTP_V1_COMMON_DATASETS **p ) ;

 /**
 * @brief Read all PTPv2 common datasets into a newly or re-allocated ::ALL_PTP_V2_COMMON_DATASETS structure
 *
 * @note This is only supported if ::PTP_CFG_MSK_HAS_V2_COMMON_DATASETS is set in ::PTP_CFG_INFO::supp_flags
 * A number of ::MBG_PTP_V2_DEFAULT_DATASET::number_ports port datasets will be allocated.
 * To free the allocated ::ALL_PTP_V2_COMMON_DATASETS, ::free_all_ptp_v2_common_datasets should be called.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a pointer of ::ALL_PTP_V2_COMMON_DATASETS structure to be allocated and filled
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_ptp_cfg_info
 * @see ::mbgextio_get_ptp_v2_default_dataset
 * @see ::mbgextio_get_ptp_v2_current_dataset
 * @see ::mbgextio_get_ptp_v2_parent_dataset
 * @see ::mbgextio_get_ptp_v2_time_properties_dataset
 * @see ::mbgextio_get_ptp_v2_port_dataset_idx
 * @see ::free_all_ptp_v2_common_datasets
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_ptp_v2_common_datasets( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_PTP_V2_COMMON_DATASETS **p ) ;

 /**
 * @brief Read all NTP configuration into a newly or re-allocated ::ALL_NTP_CFG_INFO structure
 *
 * @note ::mbgextio_dev_has_ntp should be called to check if this API is supported.
 *
 * A ::ALL_NTP_CFG_INFO and ::NTP_SRV_MODE_INFO, ::NTP_CLNT_MODE_INFO and a number of
 * ::NTP_CLNT_MODE_INFO::settings::num_peers of ::NTP_PEER_SETTINGS_IDX will be allocated and
 * needs to be freed by calling ::free_all_ntp_cfg_info
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a pointer to ::ALL_NTP_CFG_INFO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_ntp
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_ntp_cfg_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_NTP_CFG_INFO **p ) ;

 /**
 * @brief Write all NTP settings to a device
 *
 * The complementary function ::mbgextio_get_all_ntp_cfg_info should
 * have been used to read the original NTP settings and supported
 * configuration parameters.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[in]       p        Pointer to a ::ALL_NTP_CFG_INFO structure with all ntp parameters
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_ptp_cfg_settings
 * @see ::mbgextio_set_ptp_uc_master_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_save_all_ntp_cfg_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_NTP_CFG_INFO *p ) ;

 /**
 * @brief Read all NTP status info into a newly or re-allocated ::ALL_NTP_STATUS structure
 *
 * @note ::mbgextio_dev_has_ntp should be called to check if this API is supported.
 *
 * A ::ALL_NTP_STATUS and ::NTP_SRV_MODE_INFO, ::NTP_CLNT_MODE_INFO and a number of
 * ::NTP_CLNT_MODE_INFO::settings::num_peers of ::NTP_PEER_STATE_IDX will be allocated and
 * needs to be freed by calling ::free_all_ntp_status
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[in]       info     Pointer to the appropriate info structure
 * @param[out]      p        Pointer to a pointer to ::ALL_NTP_STATUS
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_ntp
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_ntp_status( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const ALL_NTP_CFG_INFO *info, ALL_NTP_STATUS **p ) ;

 /**
 * @brief Read all XMR info into a newly or re-allocated ::ALL_XMULTI_REF_INFO
 *
 * @note ::mbgextio_dev_has_xmulti_ref should be called before using this function
 *
 * A ::ALL_XMULTI_REF_INFO and a number of ::XMULTI_REF_INSTANCES::n_xmr_settings
 * of ::XMULTI_REF_INFO_IDX and ::XMR_EXT_SRC_INFO_IDX will be allocated and needs
 * to be freed by calling ::free_all_xmulti_ref_info
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a pointer of ::ALL_XMULTI_REF_INFO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::free_all_xmulti_ref_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_xmulti_ref_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_XMULTI_REF_INFO **p ) ;

 /**
 * @brief Set all extended multi ref settings to a device
 *
 * The complementary function ::mbgextio_get_all_xmulti_ref_info should
 * have been used to read the original extended multi ref settings.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[in]       p        Pointer to a ::ALL_XMULTI_REF_INFO structure with all settings
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_set_xmr_settings_idx
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_save_all_xmulti_ref_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_XMULTI_REF_INFO *p ) ;

 /**
 * @brief Read all XMR status info into a newly or re-allocated ::ALL_XMULTI_REF_STATUS
 *
 * @note ::mbgextio_dev_has_xmulti_ref should be called before using this function
 *
 * A ::ALL_XMULTI_REF_STATUS and a number of ::XMULTI_REF_INSTANCES::n_xmr_settings
 * of ::XMULTI_REF_STATUS_IDX will be allocated and needs to be freed by calling
 * ::free_all_xmulti_ref_status
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[in]       info     Pointer to an ::ALL_XMULTI_REF_INFO list which has been read before
 * @param[out]      p        Pointer to a pointer of ::ALL_XMULTI_REF_STATUS
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::free_all_xmulti_ref_status
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_xmulti_ref_status( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const ALL_XMULTI_REF_INFO* info, ALL_XMULTI_REF_STATUS **p ) ;

 /**
 * @brief Read all IMS related information / configuration into an ::ALL_IMS_INFO structure
 *
 * @note ::mbgextio_dev_has_ims should be called before using this function
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in,out] pp     Pointer to a pointer of ::ALL_IMS_INFO structure which will be malloced
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_ims
 * @see ::mbgextio_dev_ims_has_fdm
 * @see ::free_all_ims_info
 * @see ::mbgextio_get_all_ims_state
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_ims_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_IMS_INFO **pp ) ;

 /**
 * @brief Read all IMS related states into an ::ALL_IMS_STATE structure
 *
 * @note ::mbgextio_dev_has_ims should be called before using this function
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     info   Pointer to a ::ALL_GPIO_INFO structure which has been read before
 * @param[in,out] pp     Pointer to a pointer of ::ALL_IMS_STATE structure which will be malloced
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_ims
 * @see ::chk_dev_ims_has_fdm
 * @see ::free_all_ims_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_ims_state( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const ALL_IMS_INFO *info, ALL_IMS_STATE **pp ) ;

 /**
 * @brief Read all GPIO related information / configuration into an ::ALL_GPIO_INFO structure
 *
 * @note ::mbgextio_dev_has_gpio should be called before using this function
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in,out] pp     Pointer to a pointer of ::ALL_GPIO_INFO structure which will be malloced
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_gpio
 * @see ::chk_dev_gpio_has_status
 * @see ::free_all_gpio_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_gpio_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_GPIO_INFO **pp ) ;

 /**
 * @brief Read all GPIO related state information to an ::ALL_GPIO_STATE structure
 *
 * @note ::mbgextio_dev_has_gpio should be called before using this function
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     info   Pointer to a ::ALL_GPIO_INFO structure which has been read before
 * @param[in,out] pp     Pointer to a pointer of ::ALL_GPIO_STATE structure which will be malloced
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_gpio
 * @see ::chk_dev_gpio_has_status
 * @see ::free_all_gpio_info
 * @see ::free_all_gpio_state
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_gpio_state( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const ALL_GPIO_INFO *info, ALL_GPIO_STATE **pp ) ;

 /**
 * @brief Read all I/O port related information to an ::ALL_IO_PORT_INFO structure

 *
 * @note ::mbgextio_dev_has_io_ports should be called before using this function
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in,out] pp     Pointer to a pointer of ::ALL_IO_PORT_INFO structure which will be malloced
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_io_ports
 * @see ::free_all_io_port_info
 * @see ::free_all_io_port_state
 * @see ::mbgextio_get_all_io_port_status
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_io_port_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_IO_PORT_INFO **pp ) ;

 /**
 * @brief Write all I/O port related configuration to a device
 *
 * The complementary function ::mbgextio_get_all_io_port_info should
 * have been used to read the original I/O port settings and supported
 * configuration parameters.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[in]       p        Pointer to a ::ALL_IO_PORT_INFO structure with all I/O port settings
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_all_io_port_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_save_all_io_port_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_IO_PORT_INFO *p ) ;

 /**
 * @brief Read all I/O port related status information to an ::ALL_IO_PORT_STATUS structure
 *
 * @note ::mbgextio_dev_has_io_ports should be called before using this function
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     info   Pointer to ::ALL_IO_PORT_INFO
 * @param[in,out] pp     Pointer to a pointer of ::ALL_IO_PORT_STATUS structure which will be malloced
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_io_ports
 * @see ::free_all_io_port_info
 * @see ::free_all_io_port_state
 * @see ::mbgextio_get_all_io_port_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_io_port_status( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const ALL_IO_PORT_INFO *info, ALL_IO_PORT_STATUS **pp ) ;

 /**
 * @brief Read all user capture information and store it into a newly allocated or reused ::ALL_UCAP_INFO
 *
 * @note ::mbgextio_dev_has_ucap should be called to check if this API is supported.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a pointer to ::ALL_UCAP_INFO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_ucap
 * @see ::free_all_ucap_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_ucap_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_UCAP_INFO **p ) ;

 /**
 * @brief Read all user capture network info and store it into a newly allocated or reused ::ALL_UCAP_NET_INFO
 *
 * @note ::mbgextio_dev_has_ucap_net should be called to check if this API is supported.
 *
 * @param[in,out]   pmctl    Pointer to a valid message control structure
 * @param[in]       p_addr   Pointer to an XBP address specifier, or NULL
 * @param[out]      p        Pointer to a pointer to ::ALL_UCAP_NET_INFO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_dev_has_ucap_net
 * @see ::free_all_ucap_net_info
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_get_all_ucap_net_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_UCAP_NET_INFO **p ) ;

 /**
 * @brief Write all user capture network settings to a device
 *
 * The complementary function ::mbgextio_get_all_ucap_net_info should
 * have been used to read the original user capture settings and supported
 * configuration parameters.
 *
 * @param[in,out]  pmctl   Pointer to a valid message control structure
 * @param[in]      p_addr  Pointer to an XBP address specifier, or NULL
 * @param[in]      p       Pointer to the ::ALL_UCAP_NET_INFO
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_save_all_ucap_net_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_UCAP_NET_INFO *p ) ;

 /**
 * @brief Read or setup all GNSS status information
 *
 * This function should be called preferably to get a GNSS status summary
 * from GNSS receivers (GPS, GLONASS, ...).
 *
 * The function ::mbgextio_setup_receiver_info must have been called before, and
 * the returned ::RECEIVER_INFO structure has to be passed to this function.
 *
 * If the device supports this then the low level GNSS API functions
 * are called directly to collect the status information. If the device
 * doesn't support the GNSS API but is a pure GPS receiver then the GPS
 * API functions are called and the GNSS data structures are filled up
 * accordingly, so the calling application can always evaluate the
 * GNSS data structures in ::ALL_GNSS_INFO.
 *
 * If neither GPS nor another GNSS system is supported then this function
 * returns the ::MBG_ERR_NOT_SUPP_BY_DEV error.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[out]    p_agi  Pointer to a ::ALL_GNSS_INFO to be filled
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_get_gps_stat_info
 * @see ::mbgextio_get_gnss_mode_info
 * @see ::mbgextio_get_all_gnss_sat_info
 */
 int mbgextio_chk_get_all_gnss_info( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, ALL_GNSS_INFO *p_agi ) ;

 /**
 * @brief Convert a mathematical angle [rad] to a geographic angle [degree, minute, second]
 *
 * @note This has been copied from mbggeo.c, so mbggeo.h should
 * provide the same prototype.
 */
 void rad_to_dms( const double *rad, DMS *dms, const char prefix ) ;

 /**
 * @brief Convert mathematic coords to to geographic coords
 *
 * Mathematic coords are (longitude, latitude in [rad]), geographic coords
 * are (longitude, latitude in [degree, minute, second])
 *
 * @note This has been copied from mbggeo.c, so mbggeo.h should
 * provide the same prototype.
 */
 void lla_to_dms( POS *pos ) ;

 /**
 * @brief Transmit an ACK response to the sender.
 *
 * A device should call this function if it has accepted a parameter set,
 * and an acknowledgement has been requested by the sender by or'ing
 * the ::GPS_CMD code with ::GPS_REQACK. If a parameter set has not been
 * accepted then ::mbgextio_xmt_nack should be called instead.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     cmd    One of the command codes enumerated in ::GPS_CMD_CODES
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_xmt_nack
 * @see ::mbgextio_xmt_cmd
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_ack( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd ) ;

 /**
 * @brief Transmit a NACK response to the sender.
 *
 * A device should call this function if a request has been received
 * which is not supported, or if a data set has been received which
 * contains invalid/unsupported data and thus is ignored. Otherwise
 * ::mbgextio_xmt_ack should be called to return an acknowledge code
 * to the sender, if requested.
 *
 * @param[in,out] pmctl   Pointer to a valid message control structure
 * @param[in]     p_addr  Pointer to an XBP address specifier, or NULL
 * @param[in]     cmd     One of the command codes enumerated in ::GPS_CMD_CODES, including the ::GPS_CMD_CTRL_CODES flags
 * @param[in]     error   One of the @ref MBG_ERROR_CODES to be returned to the caller
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_xmt_ack
 * @see ::mbgextio_xmt_cmd
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_nack( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, GPS_CMD cmd, int error ) ;

 /**
 * @brief Begin a transaction
 *
 * @param[in,out] pmctl   Pointer to a valid message control structure
 * @param[in]     p_addr  Pointer to an XBP address specifier, or NULL
 * @param[in]     type    One of ::MBG_TRANSACTION_TYPES
 * @param[in]     set     Indicates, that this is a set transaction
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_end_transaction
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_begin_transaction( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, uint16_t type, uint8_t set ) ;

 /**
 * @brief End a transaction
 *
 * @param[in,out] pmctl   Pointer to a valid message control structure
 * @param[in]     p_addr  Pointer to an XBP address specifier, or NULL
 * @param[in]     type    One of ::MBG_TRANSACTION_TYPES
 *
 * @return One of the @ref MBG_RETURN_CODES
 *
 * @see ::mbgextio_begin_transaction
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_end_transaction( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, uint16_t type ) ;

 /**
 * @brief Get control message's internal TLV state
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return Pointer to internal ::MBG_TLV_RCV_STATE structure
 */
 _NO_MBG_API_ATTR MBG_TLV_RCV_STATE* _MBG_API mbgextio_get_tlv_rcv_state( MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Get control message's internal USB device info structure
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 *
 * @return Pointer to internal ::MBG_USB_DEV_INFO structure
 */
 _NO_MBG_API_ATTR MBG_USB_DEV_INFO * _MBG_API mbgextio_get_usb_dev_info( MBG_MSG_CTL *pmctl ) ;

 /**
 * @brief Send a ::MBG_TLV_ANNOUNCE structure to a host.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     p      Pointer to the data structure to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_tlv_announce( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const MBG_TLV_ANNOUNCE *p ) ;

 /**
 * @brief Send a buffer with variable length to a host.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     buf    Pointer to data to be sent to the device
 * @param[in]     buflen Length / size of data
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_tlv_chunk( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, void *buf, size_t buflen ) ;

 /**
 * @brief Send a file to a host.
 *
 * @param[in,out] pmctl  Pointer to a valid message control structure
 * @param[in]     p_addr Pointer to an XBP address specifier, or NULL
 * @param[in]     f      Pointer to an opened file to be sent to the device
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_do_xmt_file( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, FILE *f ) ;

 /**
 * @brief Send a file with a specific command to a host.
 *
 * @param[in,out] pmctl          Pointer to a valid message control structure
 * @param[in]     p_addr         Pointer to an XBP address specifier, or NULL
 * @param[in]     file           Name of file to be sent
 * @param[in]     rev            Name of software revision
 * @param[in]     dest_path      Name of destination path on target
 * @param[in]     tlv_feat_type  One of the ::MBG_TLV_FEAT_TYPES
 * @param[in]     uid            If uid == 0 create random uid, otherwise use the specified one
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_file( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const char *file, const char *rev, const char *dest_path, MBG_TLV_TYPE tlv_feat_type, MBG_TLV_UID uid ) ;

 /**
 * @brief Send a cmd line to a host.
 *
 * @param[in,out] pmctl     Pointer to a valid message control structure
 * @param[in]     p_addr    Pointer to an XBP address specifier, or NULL
 * @param[in]     cmd_line  Full command line to be executed as system call on target
 * @param[in]     uid       If uid == 0, create random uid. Otherwise use given one
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_cmd_line( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const char *cmd_line, MBG_TLV_UID uid ) ;

 /**
 * @brief Request a generic file of a target.
 *
 * @param[in,out] pmctl          Pointer to a valid message control structure
 * @param[in]     p_addr         Pointer to an XBP address specifier, or NULL
 * @param[in]     filename       Name of the source file
 * @param[in]     dest_path      Name of destination path and filename on target
 * @param[in]     tlv_feat_type  One of the ::MBG_TLV_FEAT_TYPES
 * @param[in]     uid            If uid == 0, create random uid. Otherwise use given one
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_req_generic_file( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const char *filename, const char *dest_path, MBG_TLV_TYPE tlv_feat_type, MBG_TLV_UID uid ) ;

 /**
 * @brief Request a file with a specific command from a host.
 *
 * @param[in,out] pmctl          Pointer to a valid message control structure
 * @param[in]     p_addr         Pointer to an XBP address specifier, or NULL
 * @param[in]     file           Name of file to be sent
 * @param[in]     dest_path      Name of destination path on target
 * @param[in]     tlv_feat_type  One of the ::MBG_TLV_FEAT_TYPES
 * @param[in]     uid            If uid == 0, create random uid. Otherwise use given one
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_req_file_with_cmd( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const char *file, const char *dest_path, MBG_TLV_TYPE tlv_feat_type, MBG_TLV_UID uid ) ;

 /**
 * @brief Send a tlv cmd to a host.
 *
 * @param[in,out] pmctl          Pointer to a valid message control structure
 * @param[in]     p_addr         Pointer to an XBP address specifier, or NULL
 * @param[in]     tlv_feat_type  One of the ::MBG_TLV_FEAT_TYPES
 * @param[in]     uid            If uid == 0, create random uid. Otherwise use given one
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_tlv_cmd( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_TLV_TYPE tlv_feat_type, MBG_TLV_UID uid ) ;

 /**
 * @brief Wrapper function for ::mbgextio_xmt_file ::TODO
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_fw_update( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const char *file, const char *rev, const char *dest_path, MBG_TLV_UID uid ) ;

 /**
 * @brief Wrapper function for ::mbgextio_xmt_tlv_cmd
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_fw_rollback( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, MBG_TLV_UID uid ) ;

 /**
 * @brief Wrapper function for ::mbgextio_xmt_file ::TODO
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_binary_file( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const char *file, const char *dest_path, MBG_TLV_UID uid ) ;

 /**
 * @brief Wrapper function for ::mbgextio_xmt_file ::TODO
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_apply_license_file( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const char *file, MBG_TLV_UID uid ) ;

 /**
 * @brief Wrapper function for ::mbgextio_xmt_file ::TODO move to firmware-specific module
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_xmt_diag_file( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const char *file, MBG_TLV_UID uid ) ;

 /**
 * @brief Wrapper function
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_req_diag_file( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const char *dest_path, MBG_TLV_UID uid ) ;

 /**
 * @brief Read TLV data into a single structure
 *
 * @param[in,out]  pmctl   Pointer to a valid message control structure
 * @param[in]      p_addr  Pointer to an XBP address specifier, or NULL
 * @param[out]     buf     Pointer to a buffer / data structure to be filled
 * @param[in]      buflen  Size of buffer
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_tlv_to_struct( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, void *buf, size_t buflen ) ;

 /**
 * @brief Read TLV into memory
 *
 * If this function succeeds then an array of memory has been allocated
 * using a malloc() call, and the pointer returned via the buf parameter
 * has to be freed afterwards by the caller.
 *
 * @param[in,out]  pmctl   Pointer to a valid message control structure
 * @param[in]      p_addr  Pointer to an XBP address specifier, or NULL
 * @param[out]     buf     Address of a pointer to a buffer to be allocated and filled
 *
 * @return One of the @ref MBG_RETURN_CODES
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_tlv_to_mem( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, void **buf ) ;

 /**
 * @brief Read TLV into a single file. See ::mbgextio_tlv_to_mem ::TODO
 */
 _NO_MBG_API_ATTR int _MBG_API mbgextio_tlv_to_file( MBG_MSG_CTL *pmctl, const XBP_ADDR *p_addr, const char *file ) ;


/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif


/* End of header body */

#undef _ext
#undef _DO_INIT

#endif  /* _EXTIOHLP_H */
