
/**************************************************************************
 *
 *  $Id: aes128.h 1.3.1.1 2009/12/22 12:23:09Z martin TEST $
 *
 *  Copyright (c) Meinberg Funkuhren, Bad Pyrmont, Germany
 *
 *  Description:
 *    Definitions and prototypes for aes128.c.
 *
 * -----------------------------------------------------------------------
 *  $Log: aes128.h $
 *  Revision 1.3.1.1  2009/12/22 12:23:09Z  martin
 *  Started to fix possible 32/64 bit issues.
 *  Revision 1.3  2009/10/01 14:04:52  martin
 *  Code cleanup.
 *  Updated function prototypes.
 *  Revision 1.2  2006/08/22 15:28:11Z  martin
 *  Added standard file header.
 *  Added definition for AES_BLOCK_SIZE.
 *
 **************************************************************************/

#ifndef _AES128_H
#define _AES128_H

/* Other headers to be included */

#include <words.h>


#ifdef _AES128
 #define _ext
 #define _DO_INIT
#else
 #define _ext extern
#endif


/* Start of header body */

#define AES_BLOCK_SIZE    16


typedef struct
{
  uint32_t erk[64];     /* encryption round keys */
  uint32_t drk[64];     /* decryption round keys */
} aes128_context;

/* function prototypes: */

#ifdef __cplusplus
extern "C" {
#endif

/* ----- function prototypes begin ----- */

/* This section was generated automatically */
/* by MAKEHDR, do not remove the comments. */

 void aes_gen_tables( void ) ;
 int aes128_set_key( aes128_context *ctx, uint8_t *key ) ;
 int aes_encrypt_buff( uint8_t *p_data, uint8_t *p_key, uint8_t *p_init, int n ) ;
 int aes_decrypt_buff ( uint8_t *p_data, uint8_t *p_key, uint8_t *p_init, int n ) ;

/* ----- function prototypes end ----- */

#ifdef __cplusplus
}
#endif


/* End of header body */

#undef _ext
#undef _DO_INIT

#endif  /* _AES128_H */
