#if !defined _COMPAT_H
#define _COMPAT_H

#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/pci.h>

#define MBG_DRVR_NAME  "mbgclock-probe"

// Override the format for dmesg log output.
#ifdef pr_fmt
#undef pr_fmt
#endif
#define pr_fmt( _fmt )   MBG_DRVR_NAME ": " _fmt

// Use specific names for the logging functions
// so they are easier to find.
#define mbg_msg_info  pr_info
#define mbg_msg_err   pr_err


// Starting around kernel 3.8, __devinit and friends
// are not supported anymore.
#if !defined( __devinit )
  #define __devinit
#endif

#if !defined( __devinitdata )
  #define __devinitdata
#endif

#if !defined( __devexit )
  #define __devexit
#endif


// Early hotplug systems may have defined __devexit,
// but not __devexit_p, and similarly, kernel 3.8 and newer
// may not have defined __devexit_p anymore.
#if !defined( __devexit_p )
  #define __devexit_p( _x ) _x
#endif


// from pcpsdefs.h

#define PCI_VENDOR_MEINBERG  0x1360

#endif  // !defined _COMPAT_H
